<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6050"
	title	= "ポップアップ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- データが選ばれていなければエラー -->
<og:columnCheck minRowCount="1" command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- forward.jsp から command = "MODIFY" がセットされて遷移してきます。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}" >
	<!-- action には、DEFAULT,CLEAR,ADD,LOWER,UPPER,COPY,SET,NULLSET,TBLSET が指定できます。 -->
	<og:columnSet command="{@command}" columnId="LABEL_NAME" action="TBLSET" value="[NAME_JA]"
					conditionKey="LABEL_NAME" conditionList=""
	/>
</og:entry>

<og:message lbl="MSG0046" comment="変更処理を行います。" /><br />
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンと、EXCEL(CSV)変更リンクを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<og:view
	viewFormType = "HTMLTable" 
	command    = "{@command}" 
	noDisplay  = "FGJ"
	noWritable = "SYSTEM_ID,LANG"
	checked    = "{@checked}"
	startNo    = "{@startNo}" 
	pageSize   = "{@pageSize}"
/>

<!-- 登録データは、entry.jsp に送られます。-->
<!-- ここでは、各ページで登録方法（INSERT,UPDATE,DELETE）を指定して、entry.jspを共通で使用します。-->
<!-- 下記に示す方法は、SQL文の直接記述方式です。-->

<og:value scope="session" key="SQL" >
	UPDATE GF41 SET
			NAME_JA		= [NAME_JA],
			LABEL_NAME	= [LABEL_NAME],
			KBSAKU		= [KBSAKU],
			DYUPD		= '{@USER.YMDH}',
			USRUPD		= '{@USER.ID}',
			PGUPD		= '{@GUI.KEY}'
	WHERE SYSTEM_ID = [SYSTEM_ID]
	AND   LANG		= [LANG]
	AND   CLM		= [CLM]
</og:value>
<!-- データ登録時のマスターチェックの方法を指定します。-->
<!-- entry.jsp で、tableExistタグを使用する場合のみ必要です。-->
<og:hidden name="exist" value="true" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
