/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.table;

import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.AbstractTableFilter;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.resource.ResourceManager;

public class TableFilter_STDDEV
extends AbstractTableFilter {
    private static final String VERSION = "6.7.2.0 (2017/01/16)";
    private static final String[] ADD_CLMS = new String[]{"CNT", "SUM", "AVG", "STDEVS", "STDEVP", "M3S", "M2S", "M1S", "M0S", "P0S", "P1S", "P2S", "P3S"};
    private static final int HIST_SU = 8;
    private DBTableModel table;

    public TableFilter_STDDEV() {
        this.initSet("GROUP_KEY", "\u30b0\u30eb\u30fc\u30d7\u30ab\u30e9\u30e0     (\u8907\u6570\u6307\u5b9a\u53ef)");
        this.initSet("VAL_KEY", "\u5024\u306e\u30ab\u30e9\u30e0         (\u5fc5\u9808)");
        this.initSet("USE_TYPE", "P(\u6bcd) or S(\u6a19\u672c)   (\u521d\u671f\u5024:P)");
        this.initSet("FORMAT", "\u6570\u5024\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8 (\u521d\u671f\u5024:%.3f \uff65\uff65\uff65 \u5c0f\u6570\u4ee3\uff13\u4f4d\u4ee5\u4e0b\u3092\u3001\u56db\u6368\u4e94\u5165\u3059\u308b)");
        this.initSet("FILTER", "1 , 2 , 3          (\u521d\u671f\u5024:0)");
    }

    public DBTableModel execute() {
        int n;
        this.table = this.getDBTableModel();
        ResourceManager resourceManager = this.getResource();
        String[] stringArray = StringUtil.csv2Array((String)this.getValue("GROUP_KEY"));
        int n2 = this.table.getColumnNo(this.getValue("VAL_KEY"));
        String string = this.getValue("USE_TYPE");
        String string2 = this.getValue("FORMAT");
        int n3 = StringUtil.nval((String)this.getValue("FILTER"), (int)0);
        boolean bl = string == null || string.isEmpty() || "P".equals(string);
        String string3 = string2 == null || string2.isEmpty() ? "%.3f" : string2;
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.table.getColumnNo(stringArray[i]);
        }
        DBColumn[] dBColumnArray = this.table.getDBColumns();
        String[] stringArray2 = new String[dBColumnArray.length + ADD_CLMS.length - 1];
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(stringArray2.length);
        int n4 = 0;
        for (n = 0; n < stringArray2.length; ++n) {
            if (n == n2) {
                for (int i = 0; i < ADD_CLMS.length; ++i) {
                    dBTableModel.setDBColumn(n++, resourceManager.makeDBColumn(ADD_CLMS[i]));
                }
                --n;
                ++n4;
                continue;
            }
            dBTableModel.setDBColumn(n, dBColumnArray[n4++]);
        }
        n = this.table.getRowCount();
        String string4 = this.getSeparatedValue(0, nArray);
        String[] stringArray3 = (String[])this.table.getValues(0);
        int n5 = 1;
        double d = this.parseDouble(stringArray3[n2]);
        int n6 = 0;
        for (int i = 1; i <= n; ++i) {
            int n7;
            String string5 = i == n ? "" : this.getSeparatedValue(i, nArray);
            int n8 = i;
            if (string4.equals(string5)) {
                stringArray3 = (String[])this.table.getValues(i);
                ++n5;
                d += this.parseDouble(stringArray3[n2]);
                continue;
            }
            double d2 = d / (double)n5;
            double d3 = 0.0;
            for (int j = n6; j < n8; ++j) {
                double d4 = this.parseDouble((String)this.table.getValue(j, n2));
                d3 += Math.pow(d4 - d2, 2.0);
            }
            double d5 = n5 == 1 ? 0.0 : Math.sqrt(d3 / (double)(n5 - 1));
            double d6 = Math.sqrt(d3 / (double)n5);
            int[] nArray2 = new int[8];
            double d7 = bl ? d6 : d5;
            for (n7 = n6; n7 < n8; ++n7) {
                double d8 = this.parseDouble((String)this.table.getValue(n7, n2)) - d2;
                if (0.0 == d8 || n5 == 1) {
                    nArray2[4] = nArray2[4] + 1;
                    continue;
                }
                if (d8 < -d7 * 3.0) {
                    nArray2[0] = nArray2[0] + 1;
                    continue;
                }
                if (-d7 * 3.0 <= d8 && d8 < -d7 * 2.0) {
                    nArray2[1] = nArray2[1] + 1;
                    continue;
                }
                if (-d7 * 2.0 <= d8 && d8 < -d7 * 1.0) {
                    nArray2[2] = nArray2[2] + 1;
                    continue;
                }
                if (-d7 * 1.0 <= d8 && d8 < 0.0) {
                    nArray2[3] = nArray2[3] + 1;
                    continue;
                }
                if (0.0 <= d8 && d8 < d7 * 1.0) {
                    nArray2[4] = nArray2[4] + 1;
                    continue;
                }
                if (d7 * 1.0 <= d8 && d8 < d7 * 2.0) {
                    nArray2[5] = nArray2[5] + 1;
                    continue;
                }
                if (d7 * 2.0 <= d8 && d8 < d7 * 3.0) {
                    nArray2[6] = nArray2[6] + 1;
                    continue;
                }
                if (!(d7 * 3.0 <= d8)) continue;
                nArray2[7] = nArray2[7] + 1;
            }
            switch (n3) {
                case 1: {
                    n7 = nArray2[0] + nArray2[1] + nArray2[2] + nArray2[5] + nArray2[6] + nArray2[7] > 0 ? 1 : 0;
                    break;
                }
                case 2: {
                    n7 = nArray2[0] + nArray2[1] + nArray2[6] + nArray2[7] > 0 ? 1 : 0;
                    break;
                }
                case 3: {
                    n7 = nArray2[0] + nArray2[7] > 0 ? 1 : 0;
                    break;
                }
                default: {
                    n7 = 1;
                }
            }
            if (n7 != 0) {
                String[] stringArray4 = new String[stringArray2.length];
                n4 = 0;
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (j == n2) {
                        stringArray4[j++] = String.valueOf(n5);
                        stringArray4[j++] = String.format(string3, d);
                        stringArray4[j++] = String.format(string3, d2);
                        stringArray4[j++] = String.format(string3, d5);
                        stringArray4[j++] = String.format(string3, d6);
                        stringArray4[j++] = String.valueOf(nArray2[0]);
                        stringArray4[j++] = String.valueOf(nArray2[1]);
                        stringArray4[j++] = String.valueOf(nArray2[2]);
                        stringArray4[j++] = String.valueOf(nArray2[3]);
                        stringArray4[j++] = String.valueOf(nArray2[4]);
                        stringArray4[j++] = String.valueOf(nArray2[5]);
                        stringArray4[j++] = String.valueOf(nArray2[6]);
                        stringArray4[j] = String.valueOf(nArray2[7]);
                        ++n4;
                        continue;
                    }
                    stringArray4[j] = stringArray3[n4++];
                }
                dBTableModel.addColumnValues(stringArray4);
            }
            if (i == n) break;
            n5 = 1;
            stringArray3 = (String[])this.table.getValues(i);
            d = this.parseDouble(stringArray3[n2]);
            n6 = i;
            string4 = string5;
        }
        return dBTableModel;
    }

    private String getSeparatedValue(int n, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            String string;
            if (nArray[i] < 0 || (string = (String)this.table.getValue(n, nArray[i])) == null || string.length() <= 0) continue;
            stringBuilder.append(string).append('_');
        }
        return stringBuilder.toString();
    }

    private double parseDouble(String string) {
        double d = 0.0;
        if (string != null && !string.trim().isEmpty()) {
            try {
                d = Double.parseDouble(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "\u6587\u5b57\u5217\u3092\u6570\u5024\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002val=[" + string + "]" + numberFormatException.getMessage();
                System.out.println(string2);
            }
        }
        return d;
    }
}

