/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.Connection;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;

public class TransactionImpl
implements Transaction {
    private static final String VERSION = "6.4.3.4 (2016/03/11)";
    private static final long serialVersionUID = 643420160311L;
    private static final String DBID = "DEFAULT";
    private final ApplicationInfo appInfo;
    private Connection defconn;
    private final ConcurrentMap<String, Connection> dbidMap = new ConcurrentHashMap<String, Connection>();
    private boolean isCommit;
    private boolean isEndCommit;
    private boolean isRollback;
    private boolean isFinish;

    public TransactionImpl(ApplicationInfo applicationInfo) {
        this.appInfo = applicationInfo;
    }

    @Override
    public Connection getConnection(String string) {
        if (string == null || string.isEmpty() || DBID.equalsIgnoreCase(string)) {
            if (this.defconn == null) {
                this.defconn = ConnectionFactory.connection(DBID, this.appInfo);
            }
            return this.defconn;
        }
        String string3 = string.toUpperCase(Locale.JAPAN);
        return this.dbidMap.computeIfAbsent(string3, string2 -> ConnectionFactory.connection(string3, this.appInfo));
    }

    @Override
    public void commit() {
        this.isCommit = true;
    }

    @Override
    public void rollback() {
        this.isRollback = true;
    }

    @Override
    public void close() {
    }

    @Override
    public void endCommit() {
        this.isEndCommit = true;
        this.isCommit = true;
    }

    public void finish() {
        if (this.isFinish) {
            String string2 = "\u3059\u3067\u306b\u3001finish() \u5b9f\u884c\u6e08\u307f\u3067\u3059\u3002" + HybsConst.CR + "  \u65b0\u898f\u306b Transaction \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u4f5c\u6210\u304b\u3089\u884c\u3063\u3066\u304f\u3060\u3055\u3044\u3002" + HybsConst.CR;
            throw new OgRuntimeException(string2);
        }
        if (this.defconn != null) {
            this.connClose(this.defconn, DBID);
            this.defconn = null;
        }
        this.dbidMap.forEach((string, connection) -> this.connClose((Connection)connection, (String)string));
        this.dbidMap.clear();
        this.isFinish = true;
    }

    private void connClose(Connection connection, String string) {
        boolean bl = this.isCommit && this.isEndCommit && !this.isRollback ? Closer.commit(connection) : Closer.rollback(connection);
        if (this.isRollback || !bl) {
            ConnectionFactory.remove(connection, string);
        } else {
            ConnectionFactory.close(connection, string);
        }
    }
}

