/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.model.Formatter;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.HybsEntry;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.SystemParameter;

public class Process_DBWriter
extends AbstractProcess
implements ChainProcess {
    private static final String CNST_KEY = "const_";
    private static final String SQL_KEY = "sql_";
    private Connection connection;
    private PreparedStatement pstmt;
    private ParameterMetaData pMeta;
    private boolean useParamMetaData;
    private String dbid;
    private String sql;
    private String endSql;
    private String table;
    private int[] clmNos;
    private int commitCnt;
    private boolean display;
    private boolean debug;
    private String[] cnstClm;
    private int[] cnstClmNos;
    private String[] constVal;
    private boolean firstRow = true;
    private int count;
    private String[] omitClms;
    private static final Map<String, String> MUST_PROPARTY = new LinkedHashMap<String, String>();
    private static final Map<String, String> USABLE_PROPARTY = new LinkedHashMap<String, String>();

    public Process_DBWriter() {
        super("org.opengion.fukurou.process.Process_DBWriter", MUST_PROPARTY, USABLE_PROPARTY);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Object object;
        Argument argument = this.getArgument();
        this.table = argument.getProparty("table");
        this.sql = argument.getFileProparty("sql", "sqlFile", false);
        this.endSql = argument.getFileProparty("endSql", "endSqlFile", false);
        this.commitCnt = argument.getProparty("commitCnt", this.commitCnt);
        this.display = argument.getProparty("display", this.display);
        this.debug = argument.getProparty("debug", this.debug);
        this.dbid = argument.getProparty("dbid");
        this.connection = paramProcess.getConnection(this.dbid);
        this.useParamMetaData = ConnectionFactory.useParameterMetaData(this.dbid);
        String string = argument.getProparty("omitClms", null);
        if (string != null) {
            this.omitClms = StringUtil.csv2Array(string);
        }
        if (this.sql == null && this.table == null) {
            throw new OgRuntimeException("sql \u3092\u6307\u5b9a\u3057\u306a\u3044\u5834\u5408\u306f\u3001table \u3092\u5fc5\u305a\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        HybsEntry[] hybsEntryArray = argument.getEntrys(SQL_KEY);
        SystemParameter systemParameter = new SystemParameter(this.sql);
        this.sql = systemParameter.replace(hybsEntryArray);
        String string2 = argument.getFileProparty("initSql", "initSqlFile", false);
        if (string2 != null) {
            object = new SystemParameter(string2);
            string2 = ((SystemParameter)object).replace(hybsEntryArray);
            this.execSql(string2);
        }
        if (this.endSql != null) {
            object = new SystemParameter(this.endSql);
            this.endSql = ((SystemParameter)object).replace(hybsEntryArray);
        }
        object = argument.getEntrys(CNST_KEY);
        int n = ((HybsEntry[])object).length;
        this.cnstClm = new String[n];
        this.constVal = new String[n];
        for (int i = 0; i < n; ++i) {
            this.cnstClm[i] = ((HybsEntry)object[i]).getKey();
            this.constVal[i] = ((HybsEntry)object[i]).getValue();
        }
    }

    @Override
    public void end(boolean bl) {
        boolean bl2 = Closer.stmtClose(this.pstmt);
        this.pstmt = null;
        this.pMeta = null;
        Throwable throwable = null;
        if (bl && this.endSql != null) {
            try {
                this.execSql(this.endSql);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
        }
        if (bl && bl2 && throwable == null) {
            Closer.commit(this.connection);
        } else {
            Closer.rollback(this.connection);
        }
        ConnectionFactory.remove(this.connection, this.dbid);
        if (!bl2) {
            throw new OgRuntimeException("\u30b9\u30c6\u30fc\u30c8\u30e1\u30f3\u30c8\u3092\u30af\u30ed\u30fc\u30ba\u51fa\u6765\u307e\u305b\u3093\u3002");
        }
        if (throwable != null) {
            String string = "endSql \u306e\u5b9f\u884c\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002sql=[" + this.endSql + "]" + CR + throwable.getMessage() + CR;
            throw new OgRuntimeException(string, throwable);
        }
    }

    @Override
    public LineModel action(LineModel lineModel) {
        ++this.count;
        try {
            int n;
            int n2;
            if (this.firstRow) {
                this.pstmt = this.makePrepareStatement(this.table, lineModel);
                if (this.useParamMetaData) {
                    this.pMeta = this.pstmt.getParameterMetaData();
                }
                n2 = this.cnstClm.length;
                this.cnstClmNos = new int[n2];
                for (n = 0; n < n2; ++n) {
                    this.cnstClmNos[n] = lineModel.getColumnNo(this.cnstClm[n]);
                }
                this.firstRow = false;
                if (this.display) {
                    this.println(lineModel.nameLine());
                }
            }
            for (n2 = 0; n2 < this.cnstClmNos.length; ++n2) {
                lineModel.setValue(this.cnstClmNos[n2], this.constVal[n2]);
            }
            if (this.useParamMetaData) {
                for (n2 = 0; n2 < this.clmNos.length; ++n2) {
                    n = this.pMeta.getParameterType(n2 + 1);
                    Object object = lineModel.getValue(this.clmNos[n2]);
                    if (object == null || object instanceof String && ((String)object).isEmpty()) {
                        this.pstmt.setNull(n2 + 1, n);
                        continue;
                    }
                    this.pstmt.setObject(n2 + 1, object, n);
                }
            } else {
                for (n2 = 0; n2 < this.clmNos.length; ++n2) {
                    this.pstmt.setObject(n2 + 1, lineModel.getValue(this.clmNos[n2]));
                }
            }
            this.pstmt.execute();
            if (this.commitCnt > 0 && this.count % this.commitCnt == 0) {
                Closer.commit(this.connection);
            }
        }
        catch (SQLException sQLException) {
            String string = "SQL \u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "errMsg=[" + sQLException.getMessage() + "]" + CR + "errCode=[" + sQLException.getErrorCode() + "] State=[" + sQLException.getSQLState() + "]" + CR + "dbid=[" + this.dbid + "]" + CR + "sql =[" + this.sql + "]" + CR + "data=[" + lineModel.dataLine() + "]" + CR;
            throw new OgRuntimeException(string, sQLException);
        }
        if (this.display) {
            this.println(lineModel.dataLine());
        }
        return lineModel;
    }

    private PreparedStatement makePrepareStatement(String string, LineModel lineModel) {
        CharSequence charSequence;
        Object object;
        if (this.sql == null) {
            int n;
            object = lineModel.getNames();
            if (this.omitClms != null) {
                int n2;
                HashSet<Object> hashSet = new HashSet<Object>();
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    hashSet.add(object[n2]);
                }
                for (n2 = 0; n2 < this.omitClms.length; ++n2) {
                    hashSet.remove(this.omitClms[n2]);
                }
                object = hashSet.toArray(new String[hashSet.size()]);
            }
            int n3 = ((String[])object).length;
            charSequence = new StringBuilder(200).append("INSERT INTO ").append(string).append(" (").append(String.join((CharSequence)",", (CharSequence[])object)).append(" ) VALUES ( ?");
            for (n = 1; n < n3; ++n) {
                charSequence.append(",?");
            }
            charSequence.append(" )");
            this.sql = charSequence.toString();
            this.clmNos = new int[n3];
            for (n = 0; n < n3; ++n) {
                this.clmNos[n] = lineModel.getColumnNo((String)object[n]);
            }
        } else {
            object = new Formatter(lineModel, this.sql);
            this.sql = ((Formatter)object).getQueryFormatString();
            this.clmNos = ((Formatter)object).getClmNos();
        }
        try {
            object = this.connection.prepareStatement(this.sql);
        }
        catch (SQLException sQLException) {
            charSequence = "PreparedStatement \u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "errMsg=[" + sQLException.getMessage() + "]" + CR + "errCode=[" + sQLException.getErrorCode() + "] State=[" + sQLException.getSQLState() + "]" + CR + "dbid =[" + this.dbid + "]" + CR + "sql  =[" + this.sql + "]" + CR + "table=[" + string + "]" + CR + "data =[" + lineModel.dataLine() + "]" + CR;
            throw new OgRuntimeException((String)charSequence, sQLException);
        }
        return object;
    }

    private void execSql(String string) {
        try (Statement statement = this.connection.createStatement();){
            statement.execute(string);
        }
        catch (SQLException sQLException) {
            String string2 = "SQL \u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "errMsg=[" + sQLException.getMessage() + "]" + CR + "errCode=[" + sQLException.getErrorCode() + "] State=[" + sQLException.getSQLState() + "]" + CR + "dbid=[" + this.dbid + "]" + CR + "sql =[" + string + "]" + CR;
            throw new OgRuntimeException(string2, sQLException);
        }
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + '\t' + "DBID         : " + this.dbid + CR + '\t' + "Output Count : " + this.count;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder(500).append("Process_DBWriter \u306f\u3001\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f\u30c7\u30fc\u30bf\u3092\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u66f8\u304d\u8fbc\u3080").append(CR).append("CainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR).append(CR).append("\u4e0a\u6d41(\u30d7\u30ed\u30bb\u30b9\u30c1\u30a7\u30a4\u30f3\u306e\u30c7\u30fc\u30bf\u306f\u4e0a\u6d41\u304b\u3089\u4e0b\u6d41\u3078\u3068\u6e21\u3055\u308c\u307e\u3059\u3002)\u304b\u3089").append(CR).append("\u53d7\u3051\u53d6\u3063\u305f LineModel \u3092\u5143\u306b\u3001\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3078\u306e\u66f8\u304d\u8fbc\u307f\u3092\u884c\u3044\u307e\u3059\u3002").append(CR).append(CR).append("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u5148\u7b49\u306f\u3001ParamProcess \u306e\u30b5\u30d6\u30af\u30e9\u30b9(Process_DBParam)\u306b").append(CR).append("\u8a2d\u5b9a\u3055\u308c\u305f\u63a5\u7d9a(Connection)\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002").append(CR).append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR).append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR).append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR).append(CR).append("SQL\u6587\u306b\u306f\u3001{@DATE.YMDH}\u7b49\u306e\u30b7\u30b9\u30c6\u30e0\u5909\u6570\u304c\u4f7f\u7528\u3067\u304d\u307e\u3059\u3002").append(CR).append(CR).append(CR).append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_DBWriter().usage());
    }

    static {
        USABLE_PROPARTY.put("dbid", "Process_DBParam \u306e -configFile \u3067\u6307\u5b9a\u3059\u308b DBConfig.xml \u30d5\u30a1\u30a4\u30eb\u3067\u898f\u5b9a");
        USABLE_PROPARTY.put("table", "INSERT \u3059\u308b\u5834\u5408\u306e\u30c6\u30fc\u30d6\u30ebID SQL\u6587\u3092\u6307\u5b9a\u3059\u308b\u5834\u5408\u306f\u4e0d\u8981\u3002");
        USABLE_PROPARTY.put("sql", "\u66f4\u65b0SQL\u6587(sql or sqlFile \u5fc5\u9808)" + CR + "\u4f8b: \"UPDATE GE41 " + CR + "SET NAME_JA = [NAME_JA],LABEL_NAME = [LABEL_NAME] " + CR + "WHERE SYSTEM_ID = [SYSTEM_ID] AND CLM = [CLM]\"");
        USABLE_PROPARTY.put("sqlFile", "\u767b\u9332SQL\u30d5\u30a1\u30a4\u30eb(sql or sqlFile \u5fc5\u9808)\u4f8b: update.sql");
        USABLE_PROPARTY.put(SQL_KEY, "SQL\u6587\u4e2d\u306e{&#064;XXXX}\u6587\u5b57\u5217\u3092\u6307\u5b9a\u306e\u56fa\u5b9a\u5024\u3067\u7f6e\u304d\u63db\u3048\u307e\u3059\u3002" + CR + "WHERE SYSTEM_ID='{&#064;SYSTEM_ID}' \u21d2 WHERE SYSTEM_ID='GE'");
        USABLE_PROPARTY.put(CNST_KEY, "LineModel \u306e\u30ad\u30fc(const_ \u306b\u7d9a\u304f\u6587\u5b57\u5217)\u306e\u5024\u306b\u3001\u56fa\u5b9a\u5024\u3092" + CR + "\u8a2d\u5b9a\u3057\u307e\u3059\u3002\u30ad\u30fc\u304c\u7570\u306a\u308c\u3070\u3001\u8907\u6570\u306e\u30ab\u30e9\u30e0\u540d\u3092\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002" + CR + "\u4f8b: -sql_SYSTEM_ID=GE");
        USABLE_PROPARTY.put("omitClms", "-table \u5c5e\u6027\u3067INSERT\u6587\u3092\u81ea\u52d5\u4f5c\u6210\u3059\u308b\u5834\u5408\u3001\u53d6\u308a\u9664\u304f\u30ab\u30e9\u30e0\u540d\u3092" + CR + "CSV\u5f62\u5f0f\u3067\u8907\u6570\u6307\u5b9a\u3067\u304d\u307e\u3059\u3002" + CR + "\u4f8b: -omitClms=UNIQ,FGJ,DYSET");
        USABLE_PROPARTY.put("initSql", "\u958b\u59cb\u6642\u306b\u4e00\u5ea6\u3060\u3051\u5b9f\u884c\u3055\u308c\u308bSQL\u6587\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        USABLE_PROPARTY.put("initSqlFile", "\u958b\u59cb\u6642\u306b\u4e00\u5ea6\u3060\u3051\u5b9f\u884c\u3055\u308c\u308bSQL\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        USABLE_PROPARTY.put("endSql", "\u7d42\u4e86\u6642\u306b\u4e00\u5ea6\u3060\u3051\u5b9f\u884c\u3055\u308c\u308bSQL\u6587\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        USABLE_PROPARTY.put("endSqlFile", "\u7d42\u4e86\u6642\u306b\u4e00\u5ea6\u3060\u3051\u5b9f\u884c\u3055\u308c\u308bSQL\u30d5\u30a1\u30a4\u30eb\u3092\u6307\u5b9a\u3057\u307e\u3059\u3002");
        USABLE_PROPARTY.put("commitCnt", "\u6307\u5b9a\u6570\u6bce\u306b\u30b3\u30df\u30c3\u30c8\u3092\u767a\u884c\u3057\u307e\u3059\u3002" + CR + "0 \u306e\u5834\u5408\u306f\u3001\u7d42\u4e86\u307e\u3067\u30b3\u30df\u30c3\u30c8\u3057\u307e\u305b\u3093(\u521d\u671f\u5024:0)");
        USABLE_PROPARTY.put("display", "\u7d50\u679c\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
        USABLE_PROPARTY.put("debug", "\u30c7\u30d0\u30c3\u30b0\u60c5\u5831\u3092\u6a19\u6e96\u51fa\u529b\u306b\u8868\u793a\u3059\u308b(true)\u304b\u3057\u306a\u3044(false)\u304b" + CR + "(\u521d\u671f\u5024:false:\u8868\u793a\u3057\u306a\u3044)");
    }
}

