/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.xml;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.xml.HybsErrorListener;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class DomParser {
    private DomParser() {
    }

    public static Document read(File file) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(file);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println(parserConfigurationException.getMessage());
            System.err.println(ThrowUtil.ogStackTrace(parserConfigurationException));
        }
        catch (SAXException sAXException) {
            System.err.println(sAXException.getMessage());
            System.err.println(ThrowUtil.ogStackTrace(sAXException));
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.err.println(ThrowUtil.ogStackTrace(iOException));
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void write(File file, Document document) {
        block7: {
            HybsErrorListener hybsErrorListener = new HybsErrorListener();
            PrintWriter printWriter = null;
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.setErrorListener(hybsErrorListener);
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setErrorListener(hybsErrorListener);
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
                transformer.setOutputProperty("encoding", "UTF-8");
                printWriter = FileUtil.getPrintWriter(file, "UTF-8");
                transformer.transform(new DOMSource(document), new StreamResult(printWriter));
                Closer.ioClose(printWriter);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                System.err.println(hybsErrorListener.toString());
                System.err.println(ThrowUtil.ogStackTrace(transformerConfigurationException));
            }
            catch (TransformerException transformerException) {
                System.err.println(hybsErrorListener.toString());
                System.err.println(ThrowUtil.ogStackTrace(transformerException));
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Closer.ioClose(printWriter);
            }
        }
    }
}

