/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* RPAD2 ( FUNCTION )                                                       */
/* Created : 2017/01/05 15:19:05                                            */
/****************************************************************************/

CREATE 
FUNCTION RPAD2(
	XTEXT       IN VARCHAR2 ,
	XLEN        IN NUMBER   ,
	XVAL        IN VARCHAR2 := ' ' )
RETURN VARCHAR2
/**********************************************************************/
/* UTF-8対応 RPAD ファンクション                                      */
/*  RPAD2( XTEXT,XLEN,[XVAL] )                                        */
/*                                                                    */
/*	 XTEXT       IN VARCHAR2          文字列式                        */
/*	 XLEN        IN NUMBER            調整後の文字列長                */
/*	[XVAL        IN VARCHAR2 :=' ']   充填する文字列(デフォルト' ')   */
/*                                                                    */
/*	右側から文字列を充填します。                                      */
/*                                                                    */
/**********************************************************************/
AS
BEGIN
	RETURN SUBSTRB( RPAD( XTEXT,XLEN,XVAL ) , 1, XLEN ) ;
END RPAD2;
;
