<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC30"
	title	= "対訳"
	date	= "2015/05/09"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- リソースを検索する時の基準となる SQL 文 -->
<!-- @1:LNAME,SNAME,DESCRIPTION などの取得先カラム名。@2:en,zh などの言語 -->
<!-- 注意：action="REPLACE"は正規表現を使用するので、$1,$2 は前方参照の特殊キーワードになります。 -->
<og:value command="SET" key="GEA08_SQL">
	select A.SYSTEM_ID, COALESCE(B.LANG,'@2') as LANG_YAKU , A.CLM as ID
			,A.@1 as GENBUN,B.@1 as YAKU , '@3' as KBYAKU
			, CASE WHEN B.LANG is null THEN '0' ELSE '1' END as KBHORYU , null as UNIQ
	from GEA08 A left outer join GEA08 B
			on  A.SYSTEM_ID = B.SYSTEM_ID
			and A.CLM       = B.CLM
			and A.KBSAKU    = B.KBSAKU
			and A.UNIQ     != B.UNIQ
			and A.@1       != B.@1
			and B.FGJ       = '1'
			and B.LANG      = '@2'
	where A.SYSTEM_ID       = '{@F_SYSTEM_ID}'
			and A.KBSAKU    = '{@KBSAKU}'
			and A.@1       is not null
			and A.LANG      = 'ja'
			and A.FGJ       = '1'
			and A.KBLBL     &lt;= '9'			<!-- GF の タグリブは省く -->
</og:value>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="NEW" dbid="{@DBID}" debug="{@debug}" maxRowCount="0">
	<!-- 訳文区分 1:通常ﾗﾍﾞﾙ , en:英語 -->
	<og:value command="GET" key="GEA08_SQL" action="REPLACE" fromVal="@1,@2,@3" toVal="LNAME,en,1" />
	union
	<!-- 訳文区分 1:通常ﾗﾍﾞﾙ , zh:中国語 -->
	<og:value command="GET" key="GEA08_SQL" action="REPLACE" fromVal="@1,@2,@3" toVal="LNAME,zh,1" />
	union
	<!-- 訳文区分 2:短縮ﾗﾍﾞﾙ , en:英語 -->
	<og:value command="GET" key="GEA08_SQL" action="REPLACE" fromVal="@1,@2,@3" toVal="SNAME,en,2" />
	union
	<!-- 訳文区分 2:短縮ﾗﾍﾞﾙ , zh:中国語 -->
	<og:value command="GET" key="GEA08_SQL" action="REPLACE" fromVal="@1,@2,@3" toVal="SNAME,zh,2" />
	union
	<!-- 訳文区分 3:概要説明 , en:英語 -->
	<og:value command="GET" key="GEA08_SQL" action="REPLACE" fromVal="@1,@2,@3" toVal="DESCRIPTION,en,3" />
	union
	<!-- 訳文区分 3:概要説明, zh:中国語 -->
	<og:value command="GET" key="GEA08_SQL" action="REPLACE" fromVal="@1,@2,@3" toVal="DESCRIPTION,zh,3" />
</og:query>

<og:entry command="MODIFY" useConsistency="false" selectedAll="true">
	<og:columnSet command="MODIFY" columnId="LANG_YAKU" action="NULLSET" value="**" />
	<og:columnSet command="MODIFY" columnId="SYSTEM_ID" action="SET"     value="{@F_SYSTEM_ID}" />
</og:entry>

<!-- すでにDB登録済みのデータがあれば、無視する為に、取得します。 -->
<og:query command="NEW" debug="{@debug}" maxRowCount="0" scope="request" >
	select SYSTEM_ID,LANG_YAKU,ID,GENBUN,YAKU,KBYAKU,KBHORYU,UNIQ
	from   GF28
	where  SYSTEM_ID='{@F_SYSTEM_ID}'
</og:query>

<!-- すでにDB登録済みの完全一致データを除外します。 -->
<og:tableMerge
	action		= "MINUS"
	masterKeys	= "LANG_YAKU,ID,GENBUN,YAKU,KBYAKU"
/>

<br />
<!-- キー情報で、改廃コードを設定します。条件にあれば、C:更新、なければ、A:追加になります。 -->
<og:tableMerge
	action		= "CDKH"
	masterKeys	= "LANG_YAKU,ID,GENBUN,KBYAKU"
	modifyClms	= "UNIQ"
/>
<br />

<og:transaction>
	<!-- リソースは、直接登録します。 -->
	<og:tableUpdate command="ENTRY" queryType="JDBCTableUpdate" sqlType="UPDATE" followCdkh="true" selectedAll="true" debug="{@debug}">
		<og:tableUpdateParam
			sqlType  = "UPDATE"
			table    = "GF28"
			where    = "SYSTEM_ID='{@F_SYSTEM_ID}' and LANG_YAKU=[LANG_YAKU] and ID=[ID] and UNIQ=[UNIQ]"
		/>
	</og:tableUpdate>

	<!-- リソースは、直接登録します。 -->
	<og:tableUpdate command="ENTRY" queryType="JDBCTableUpdate" sqlType="INSERT" followCdkh="true" selectedAll="true" debug="{@debug}">
		<og:tableUpdateParam
			sqlType  = "INSERT"
			table    = "GF28"
		/>
	</og:tableUpdate>
</og:transaction>

<!-- 変更はここまでです。 -->
<og:forward page="result.jsp" keys="command" vals="RENEW" />

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
