<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2190"
	title	= "移行DB対応明細"
	date	= "2014/05/01"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- entryタグのcommandとcolumnSetのコマンドが同じ場合のみ、動作します。 -->
<og:entry command = "{@command}" repeatCount="{@repeatCount}" >
	<og:columnSet command="{@command}" columnId="SYSTEM_ID"	action="NULLSET" value="{@SYSTEM_ID}"		/>
	<og:columnSet command="COPY"       columnId="NOJUN"		action="ADD" />
</og:entry>

<og:message command="{@command}" /><br />  <!-- 動的にコメントを表示します。 -->

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">
	<!-- 登録、取消、リセットボタンを作成します。 -->
	<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
	<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
	<og:writeCheck>
		<og:submit  action="ENTRY" />
		<og:submit  action="RESET" />
		<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
		<br />
	</og:writeCheck>

	<og:view
		viewFormType = "HTMLTable"
		command    = "{@command}"
		noDisplay  = "SYSTEM_ID,TABLE_NAME,TABLE_LBL,KBCLM,F_TABLE_NAME,F_TABLE_LBL,CLS_NAME,VIEW_LENGTH,USE_LENGTH,BIKO,NOJUN,F_DTYPE,FGJ,UNIQ"
		noWritable = "{@noWritable}"
		columnWritable  = "{@columnWritable}"
		checked    = "{@checked}"
		startNo    = "{@startNo}"
		pageSize   = "{@pageSize}"
		columnBulkSet= "*"
	/>

<!--
	<jsp:directive.include file="view.jsp" />
-->
	<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
