<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<script type="text/javascript" language="JavaScript" src="{@SYS.JSP}/common/unrecommend/accessFunctionKey.js" ><!-- --></script>
</og:head>
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6010"
	title	= "セレクトメニュー"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "TABLE_CLM2"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<form name="form1" method="GET" action="result.jsp" target="RESULT">
	<table summary="layout" >
	<tr>
		<og:column name="LANG"	defaultVal="{@USER.LANG}"	writable="false" />	<!-- MENU -->
		<og:column name="TABLE_CLM2"						writable="false" />	<!-- INDBMENU -->
			<!-- renewするタイプの親子プルダウンです -->
		<td>
			<strong><og:message lbl="SYSTEM_ID"/>:</strong>
		</td>
		<td>
			<!-- DBMENU -->
			<og:select name="SYSTEM_ID" addNoValue="true" disabled="true" onChange="renew('query.jsp','QUERY',this)"  td="false">
				<og:queryOption>
					SELECT SYSTEM_ID FROM GF41
					WHERE	FGJ			= '1'
					AND		LANG		= '{@NVL.LANG ja}'
					GROUP BY SYSTEM_ID
					ORDER BY SYSTEM_ID
				</og:queryOption>
			</og:select>
			<strong>:</strong>
			<og:select name="CLM"  td="false" disabled="true" >
				<og:option lbl=""/>
				<og:queryOption separator=":">
					SELECT CLM,KBSAKU,LABEL_NAME FROM GF41
					WHERE	SYSTEM_ID	= '{@SYSTEM_ID}'
					AND		LANG		= '{@NVL.LANG ja}'
					AND		FGJ			= '1'
					ORDER BY CLM,KBSAKU
				</og:queryOption>
			</og:select>
		</td>
		<td>
			<og:select name="GUI Menu" colspan="3" disabled="true" >
				<og:queryOption  groupUseNo="2" classUseNo="3">
						SELECT CLM,LABEL_NAME,KBSAKU,
								case when MOD(UNIQ,3) = 0 then 'row_mark' else '' end
						from GF41 
						where SYSTEM_ID	= '{@SYSTEM_ID}' 
						AND		LANG	= '{@NVL.LANG ja}'
						AND		FGJ		= '1'
						ORDER BY CLM,KBSAKU
				</og:queryOption>
			</og:select>
		</td>
	</tr>
	<tr>
			<og:select name="EMP Menu1" colspan="2" disabled="true">
				<og:queryOption groupUseNo="2" disabledUseNo="3">
						select A.EMPNO,A.ENAME,B.DNAME,'disabled' as CLS
						from EMP A left outer join DEPT B
						on   A.DEPTNO = B.DEPTNO
						order by A.DEPTNO,A.EMPNO
				</og:queryOption>
			</og:select>

			<og:select name="EMP Menu2" colspan="2" disabled="true">
				<og:queryOption groupUseNo="2" styleUseNo="3">
						select A.EMPNO,A.ENAME,B.DNAME,'color:green;' as CLS
						from EMP A left outer join DEPT B
						on   A.DEPTNO = B.DEPTNO
						order by A.DEPTNO,A.EMPNO
				</og:queryOption>
			</og:select>

			<og:column name="EMP Menu3" colspan="2" editor="DBMENU"  writable="false"
				param="select A.EMPNO,A.ENAME,'',B.DNAME,'style=&quot;color:blue;&quot;' as CLS
						from EMP A left outer join DEPT B
						on   A.DEPTNO = B.DEPTNO
						order by A.DEPTNO,A.EMPNO" />

			<og:select name="EMP Menu4" colspan="2" multiple="true"  disabled="true">
				<og:queryOption groupUseNo="2"  disabledUseNo="3" styleUseNo="4">
						select A.EMPNO,A.ENAME || rownum,B.DNAME,
						case mod( rownum , 4 ) when 0 then 'disabled' else '' end as CLS1,
						case mod( rownum , 3 ) when 0 then 'color:yellow;' when 1 then 'color:green;' when 2 then 'color:red;' else 'color:blue;' end as CLS2
						from EMP A left outer join DEPT B
						on   A.DEPTNO = B.DEPTNO
						order by A.DEPTNO,A.EMPNO
				</og:queryOption>
			</og:select>

			<!-- 5.9.4.5 (2016/01/29) eventColumn で、multiple 対応 -->
			<og:select name="GUIMenu" colspan="3" multiple="multiple" eventColumn="_LANG" value="ALBANIA">
				<og:queryOption  groupUseNo="2" classUseNo="3">
						SELECT CLM,LABEL_NAME,KBSAKU,
								case when MOD(UNIQ,3) = 0 then 'row_mark' else '' end
						from GF41 
						where SYSTEM_ID	= '{@SYSTEM_ID}' 
						AND		LANG	= '{@LANG}'
						AND		FGJ		= '1'
						ORDER BY CLM,KBSAKU
				</og:queryOption>
			</og:select>

	</tr>
	</table>

	<table summary="layout" >
		<tr>
			<og:column name="NUM1"	editor="NUMMENU"						writable="false" />
			<og:column name="NUM2"	editor="NUMMENU"	param="-5,5,1"		writable="false" />
			<og:column name="NUM3"	editor="NUMMENU"	param="0,100,10"	writable="false" />
			<og:column name="NUM4"	editor="NUMMENU"	param="10,0,-1"		writable="false" />
			<og:column name="NUM5"	editor="NUMMENU"	param="5,10"		writable="false" />
			<og:column name="NUM6"	editor="NUMMENU"	param="7"			writable="false" />
		<tr>
		</tr>
			<og:column name="YMD1"	renderer="MD"							writable="false" />
			<og:column name="YMD2"	renderer="MD"							writable="false" />
			<og:column name="YMD3"	renderer="MD"							writable="false" />
			<og:column name="YMD4"	renderer="DATE"		param="MM/dd(EEE)"	writable="false" />
			<og:column name="YMD5"	renderer="MD"							writable="false" />
			<og:column name="YMD6"	renderer="DATE"		param="MM/dd(EEE)"	writable="false" />
		<tr>
		</tr>
			<og:column name="HM1"	renderer="HM"		writable="false" />
			<og:column name="HM2"	renderer="HM"		writable="false" />
			<og:column name="HM3"	renderer="HM"		writable="false" />
			<og:column name="HM4"	renderer="HM"		writable="false" />
			<og:column name="HM5"	renderer="HM"		writable="false" />
			<og:column name="HM6"	renderer="HM"		writable="false" />
		</tr>
	</table>
	<table>
		<tr>
			<og:column name="RD1"	editor="RADIO"  	codeName="LANG"		writable="false" />
			<og:column name="RD2"	editor="RADIO2" 	codeName="LANG"		writable="false" />
			<og:column name="KV1"	codeKeyVal="1:A 2:B 3:C"				writable="false" />
			<og:column name="KV2"	renderer="KVMENU" 	param="1:A 2:B 3:C"	writable="false" />
		</tr>
	</table>
	<table>
		<tr>
			<og:column name="DBR1"	editor="DBRADIO" writable="false" 
				param="SELECT CLM,LABEL_NAME FROM GF41
						WHERE	SYSTEM_ID	= '{@SYSTEM_ID}'
						AND		LANG		= '{@NVL.LANG ja}'
						AND		FGJ			= '1'
						AND		CLM		like  'A%'
						GROUP BY CLM,LABEL_NAME
						ORDER BY CLM"
			/>
		</tr>
	</table>
</form>

<hr />

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select table_name,table_name as TABLE_CLM2 from GF02
</og:query>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT" >

<og:writeCheck>
	<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
	<og:submit  action="COPY"    noWritable="null" />
	<og:submit  action="MODIFY"  noWritable="SYSTEM_ID,LANG,CLM"  />
	<og:submit  action="DELETE"  columnWritable="null" />
<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = ""
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
