<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:fn="http://java.sun.com/jsp/jstl/functions"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:異常ﾃﾞｰﾀ検知"
	pgid	= "GFX030"
	title	= "DB異常検知"
	date	= "2017/05/17"
	author	= "T.OTA"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<og:equals val1="{@FLG_CALC}" nullCheck="true">
	<og:columnCheck
		command   = "{@command}"
	/>
</og:equals>
<og:equals val1="{@FLG_CALC}" nullCheck="true" notEquals="true">
	<!-- 画面下で判定ﾎﾞﾀﾝ押下時のﾁｪｯｸ用 -->
	<og:columnCheck
		command   = "{@command}"
		nullCheck = "JUDGE_COLUMN_NAME1,JUDGE_COLUMN_NAME2"
		useColumnLabel = "true"
	>
		<jsp:directive.include file="/jsp/common/history_back.jsp" />
	</og:columnCheck>
</og:equals>

<!-- ﾃｰﾌﾞﾙﾚｺｰﾄﾞの2件以上の存在ﾁｪｯｸ -->
<og:dataCheck
	command			= "NEW"
	lbl				= "ﾚｺｰﾄﾞが2件以上存在する必要があります。"
	lblParamKeys	= "2"
	exist     		= "true">
	select DECODE(COUNT(*),1,0,COUNT(*))
	from {@TABLE_NAME}
</og:dataCheck>

<!-- 同一列の未選択ﾁｪｯｸ -->
<og:dataCheck
	command			= "NEW"
	lbl				= "異なる列を選択して下さい。">
	'{@COLUMN_NAME1}' != '{@COLUMN_NAME2}'
</og:dataCheck>

<!-- 異なるﾃﾞｰﾀの存在ﾁｪｯｸ -->
<og:dataCheck
	command			= "NEW"
	lbl				= "異なるﾃﾞｰﾀが登録されている必要があります。"
	lblParamKeys	= "{@COLUMN_NAME1}"
	exist			= "true">
	select DECODE(COUNT(*),1,0,COUNT(*))
	from
	(select
		DISTINCT NVL({@COLUMN_NAME1},0)
	from
		{@TABLE_NAME})
</og:dataCheck>

<og:dataCheck
	command			= "NEW"
	lbl				= "異なるﾃﾞｰﾀが登録されている必要があります。"
	lblParamKeys	= "{@COLUMN_NAME2}"
	exist			= "true">
	select DECODE(COUNT(*),1,0,COUNT(*))
	from
	(select
		DISTINCT NVL({@COLUMN_NAME2},0)
	from
		{@TABLE_NAME})
</og:dataCheck>

<!-- ﾃｰﾌﾞﾙﾃﾞｰﾀを取得(CALC列はﾏﾊﾗﾉﾋﾞｽ距離による、異常判定結果ｾｯﾄ用) -->
<og:query command="NEW" debug="{@debug}" maxRowCount="0">
	select {@COLUMN_NAME1},{@COLUMN_NAME2},'' CALC
	from {@TABLE_NAME}
	order by 1
</og:query>

<!-- ﾏﾊﾗﾉﾋﾞｽ距離の計算 -->
<!-- ﾃｰﾌﾞﾙのCALC列に閾値内外判定値の設定。RETURN値にﾁｬｰﾄのｵﾌﾟｼｮﾝ(点の背景色)を設定 -->
<og:bizLogic logics="gf.GFX030A" keys="COLUMN_NAME1,COLUMN_NAME2"
	vals="{@COLUMN_NAME1},{@COLUMN_NAME2}" selectedAll="true" />

<!-- ﾃﾞｰﾀ一覧表示 -->
<og:message comment="CALC列にﾏﾊﾗﾉﾋﾞｽ距離による異常検知結果(D=2.448)を設定しています。" />
<og:view height="200px"
	pageSize="1000" />
<br /><br />

<!-- グラフ出力 -->
<og:message comment="CALCが正常(true)の場合は黒色,異常(false)の場合は赤色で表示しています。" />
<og:jsChart id	= "chart1"
	chartType	= "line"
	labelColumn	= "{@COLUMN_NAME1}"
	xscaleType	= "linear"
	xlabel		= "{@COLUMN_NAME1}"
	ylabel		= "{@COLUMN_NAME2}"
	debug		= "false">
 	<!-- 散布図:optionAttributesにpointBackgroundColor属性を設定 -->
 	<og:jsChartData
 		chartColumn = "{@COLUMN_NAME2}"
 		label		= "{@COLUMN_NAME2}"
 		borderColor = "rgba(0,0,0,0)"
 		backgroundColor		= "rgb(0,0,0)"
 		optionAttributes	= "{@RETURN}"
 		 />
</og:jsChart><br />

<!-- ﾃﾞｰﾀを入力して、判定用のﾌｫｰﾑ -->
<form onSubmit="return oneClick();" method="POST" action="result.jsp">
	<og:input name="JUDGE_COLUMN_NAME1" lbl="{@COLUMN_NAME1}" value="{@JUDGE_COLUMN_NAME1}" />
	<og:input name="JUDGE_COLUMN_NAME2" lbl="{@COLUMN_NAME2}" value="{@JUDGE_COLUMN_NAME2}" />
	<og:button type="submit" lbl="判定" />
	<og:equals val1="{@FLG_CALC}" val2="1">
		<!-- ﾃﾞｰﾀ異常判定 -->
		<og:bizLogic logics="gf.GFX030B" keys="COLUMN_NAME1,COLUMN_NAME2,JUDGE_COLUMN_NAME1,JUDGE_COLUMN_NAME2"
			vals="{@COLUMN_NAME1},{@COLUMN_NAME2},{@JUDGE_COLUMN_NAME1},{@JUDGE_COLUMN_NAME2}" selectedAll="true" />
		<og:text>結果：{@RETURN}</og:text>
	</og:equals>
	<og:hidden keys="TABLE_NAME,COLUMN_NAME1,COLUMN_NAME2,FLG_CALC" vals="{@TABLE_NAME},{@COLUMN_NAME1},{@COLUMN_NAME2},1" />
</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
