/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.hayabusa.html.FormatterType;

/**
 * 検索結果に対してヘッダーフォーマットを変更するタグです。
 *
 * @og.formSample
 * ●形式：&lt;og:thead rowspan="..." &gt; ... Body ... &lt;/og:thead&gt;
 * ●body：あり(EVAL_BODY_BUFFERED:BODYを評価し、{&#064;XXXX} を解析します)
 *
 * ●Tag定義：
 *   &lt;og:thead
 *       rowspan          ○【TAG】表示データを作成する場合のフォーマットの行数(rowspan)をセットします(初期値:2)(必須)。
 *       useTrCut           【TAG】先頭trタグを削除するかどうか[true/false]を指定します(初期値:true)
 *       caseKey            【TAG】このタグ自体を利用するかどうかの条件キーを指定します(初期値:null)
 *       caseVal            【TAG】このタグ自体を利用するかどうかの条件値を指定します(初期値:null)
 *       caseNN             【TAG】指定の値が、null/ゼロ文字列 でない場合(Not Null=NN)は、このタグは使用されます(初期値:判定しない)
 *       caseNull           【TAG】指定の値が、null/ゼロ文字列 の場合は、このタグは使用されます(初期値:判定しない)
 *       caseIf             【TAG】指定の値が、true/TRUE文字列の場合は、このタグは使用されます(初期値:判定しない)
 *       debug              【TAG】デバッグ情報を出力するかどうか[true/false]を指定します(初期値:false)
 *   &gt;   ... Body ...
 *   &lt;/og:thead&gt;
 *
 * ●使用例
 *      &lt;og:view
 *          viewFormType = &quot;HTMLCustomTable&quot;
 *          command      = &quot;{&#064;command}&quot;
 *          writable     = &quot;false&quot;
 *          startNo      = &quot;{&#064;startNo}&quot;
 *          pageSize     = &quot;{&#064;pageSize}&quot;
 *          rowspan      = &quot;1&quot;
 *          numberType   = &quot;delete&quot;
 *      &gt;
 *          &lt;og:thead rowspan=&quot;1&quot; &gt;
 *              &lt;tr&gt;&lt;td&gt;&amp;amp;nbsp;&lt;/td&gt;&lt;td&gt;[VALUENAME]&lt;/td&gt;&lt;td&gt;[DESCRIPTION]&lt;/td&gt;&lt;/tr&gt;
 *          &lt;/og:thead&gt;
 *        ...
 *      &lt;/og:view&gt;
 *
 * @og.rev 3.5.4.0 (2003/11/25) TFormatTag のサブクラスとして再定義。
 * @og.group 画面部品
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
// public class TheadTag extends TFormatTag {
public class TheadTag extends TFormatImpl {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.4.2.0 (2016/01/29)" ;
	private static final long serialVersionUID = 642020160129L ;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public TheadTag() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * このフォーマットのタイプを返します。
	 *
	 * @og.rev 3.5.4.0 (2003/11/25) 新規追加
	 *
	 * @return	このフォーマットのタイプを返します。
	 */
	@Override
	protected FormatterType getType() {
		return FormatterType.TYPE_HEAD;
	}
}
