/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

// import org.opengion.fukurou.system.OgBuilder ;				// 6.4.4.1 (2016/03/18)

/**
 * TableFilter_TABLE_ORACLE は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。とくに、ORACLE用のDB定義スクリプトを作成します。
 *
 * ※ 他のデータベースと同じ形で扱いたいため、用意したクラスですが、内容は、TableFilter_TABLE と同じです。
 *
 * ここでは、テーブル一覧の検索結果より、GF05 のテーブルカラム定義テーブルから
 * 必要な情報を取得し、テーブル作成スクリプトを作成します。
 * 出力ファイルは、テーブル名＋"S.sql" という命名規則で作成します。
 * 検索では、(SYSTEM_ID,TBLSYU,TABLE_NAME,NAME_JA,TABLESPACE_NAME,INITIAL_EXTENT,COMMENTS)
 * の項目を取得する必要があります。
 *
 * @og.rev 6.5.0.0 (2016/09/30) 新規作成
 *
 * @version  6.5.0.0  2016/09/13
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.8,
 */
public class TableFilter_TABLE_ORACLE extends TableFilter_TABLE {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.5.0.0 (2016/09/30)" ;
}
