/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.ValueMapParamTag;

public class ValueMapTag
extends CommonTagSupport {
    private static final String VERSION = "6.7.8.0 (2017/04/21)";
    private static final long serialVersionUID = 678020170421L;
    private static final String CLS_KEY = "cls=";
    private static final String TIPS_KEY = "tips=";
    private static final String NONE1 = "<style type=\"text/css\">.";
    private static final String NONE2 = " { display : none ;} </style>";
    private DBTableModel table;
    private String tableId = "h_tblmdl";
    private boolean selectedAll = true;
    private String keys;
    private String valClm;
    private String nnClms;
    private String holdTag;
    private String clsClms;
    private String tipsClms;
    private String scope = "session";
    private String separator = "_";
    private boolean xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
    private int[] clsClmsNo;
    private int[] tipsClmsNo;
    private int valClmNo = 1;
    private String body;
    private String restChangeKey;
    private boolean useNoneClsKey;
    private final Map<String, String[]> mapObj = Collections.synchronizedMap(new LinkedHashMap());
    private final ConcurrentMap<ValueMapParamTag.VMP_KEYS, String> paramMap = new ConcurrentHashMap<ValueMapParamTag.VMP_KEYS, String>();
    private final Map<String, String[]> restMap = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    public int doStartTag() {
        if (this.useTag()) {
            this.useXssCheck(this.xssCheck);
            this.table = (DBTableModel)this.getObject(this.tableId);
            if (this.table != null && this.table.getRowCount() > 0 && this.table.getColumnCount() > 0) {
                this.makeMapObj(this.table);
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        this.body = this.getBodyString();
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag() && this.body != null) {
            this.jspPrint(this.body);
        }
        if (this.useNoneClsKey) {
            String string = (String)this.paramMap.get((Object)ValueMapParamTag.VMP_KEYS.NONE_CLS_KEY);
            this.jspPrint(NONE1 + string + NONE2);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.table = null;
        this.tableId = "h_tblmdl";
        this.selectedAll = true;
        this.keys = null;
        this.valClm = null;
        this.nnClms = null;
        this.holdTag = null;
        this.clsClms = null;
        this.tipsClms = null;
        this.scope = "session";
        this.separator = "_";
        this.xssCheck = HybsSystem.sysBool("USE_XSS_CHECK");
        this.body = null;
        this.mapObj.clear();
        this.clsClmsNo = null;
        this.tipsClmsNo = null;
        this.valClmNo = 1;
        this.paramMap.clear();
        this.restMap.clear();
        this.restChangeKey = null;
        this.useNoneClsKey = false;
    }

    private void makeMapObj(DBTableModel dBTableModel) {
        int[] nArray = this.getParameterRows();
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = this.getClmNos(dBTableModel, this.keys, 0);
        int[] nArray3 = this.getClmNos(dBTableModel, this.nnClms, -1);
        this.clsClmsNo = this.getClmNos(dBTableModel, this.clsClms, -1);
        this.tipsClmsNo = this.getClmNos(dBTableModel, this.tipsClms, -1);
        for (int i = 0; i < nArray.length; ++i) {
            String[] stringArray = (String[])dBTableModel.getValues(i);
            if (!this.isNotNullCheck(stringArray, nArray3)) continue;
            String string2 = this.getAppendKeys(stringArray, nArray2, this.separator);
            this.mapObj.computeIfAbsent(string2, string -> stringArray);
        }
        this.restMap.putAll(this.mapObj);
        this.valClmNo = this.valClm == null || this.valClm.isEmpty() ? 1 : dBTableModel.getColumnNo(this.valClm.trim());
    }

    private int[] getClmNos(DBTableModel dBTableModel, String string, int n) {
        int[] nArray;
        if (string == null || string.isEmpty()) {
            nArray = n < 0 ? new int[]{} : new int[]{n};
        } else {
            String[] stringArray = string.split(",");
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = dBTableModel.getColumnNo(stringArray[i].trim());
            }
        }
        return nArray;
    }

    private boolean isNotNullCheck(String[] stringArray, int[] nArray) {
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            String string = stringArray[nArray[i]];
            if (string != null && !string.isEmpty()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private String getAppendKeys(String[] stringArray, int[] nArray, String string) {
        StringBuilder stringBuilder = new StringBuilder(200);
        if (nArray.length > 0) {
            stringBuilder.append(stringArray[nArray[0]]);
            for (int i = 1; i < nArray.length; ++i) {
                String string2 = stringArray[nArray[i]];
                if (string2 == null || string2.isEmpty()) continue;
                stringBuilder.append(string).append(string2);
            }
        }
        return stringBuilder.toString().trim();
    }

    private String getMapVals(String[] stringArray, String string, boolean bl, String string2, String string3, String string4) {
        String string5;
        String string6 = string5 = string4 == null || string4.isEmpty() ? string : string4;
        if (!bl && this.holdTag != null && !this.holdTag.isEmpty()) {
            String string7 = string2 == null ? this.getAppendKeys(stringArray, this.clsClmsNo, " ") : string2;
            String string8 = string3 == null ? this.getAppendKeys(stringArray, this.tipsClmsNo, " ") : string3;
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append('<').append(this.holdTag);
            if (!string7.isEmpty()) {
                stringBuilder.append(" class=\"").append(string7).append('\"');
            }
            if (!string8.isEmpty()) {
                stringBuilder.append(" title=\"").append(string8).append('\"');
            }
            stringBuilder.append('>').append(string5).append("</").append(this.holdTag).append('>');
            string5 = stringBuilder.toString();
        }
        return string5;
    }

    @Override
    protected String getRequestValue(String string2) {
        String string3;
        int n;
        char c;
        if (string2.equals(this.restChangeKey)) {
            return this.makeRestValue();
        }
        char c2 = string2.charAt(0);
        boolean bl = c2 == '$';
        boolean bl2 = c2 == '*';
        boolean bl3 = c2 == '^';
        StringBuilder stringBuilder = new StringBuilder(string2.trim());
        if (bl || bl2 || bl3) {
            stringBuilder.deleteCharAt(0);
        }
        int n2 = stringBuilder.lastIndexOf(" ");
        int n3 = this.valClmNo;
        if (n2 > 0 && '0' <= (c = stringBuilder.charAt(n2 + 1)) && c <= '9') {
            try {
                n3 = Integer.parseInt(stringBuilder.substring(n2 + 1));
                stringBuilder.setLength(n2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String string4 = null;
        int n4 = stringBuilder.lastIndexOf(CLS_KEY);
        if (n4 > 0) {
            int n5 = n4 + CLS_KEY.length();
            String string5 = stringBuilder.substring(n5, n5 + 1);
            n = stringBuilder.indexOf(string5, n5 + 1);
            if (n >= 0) {
                string4 = stringBuilder.substring(n5 + 1, n);
                stringBuilder.delete(n4, n + 1);
            } else {
                System.err.println("cls\u6307\u5b9a\u306e\u6587\u6cd5\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002key=" + string2);
            }
        }
        String string6 = null;
        int n6 = stringBuilder.lastIndexOf(TIPS_KEY);
        if (n6 > 0) {
            n = n6 + TIPS_KEY.length();
            String string7 = stringBuilder.substring(n, n + 1);
            int n7 = stringBuilder.indexOf(string7, n + 1);
            if (n7 >= 0) {
                string6 = stringBuilder.substring(n + 1, n7);
                stringBuilder.delete(n6, n7 + 1);
            } else {
                System.err.println("tips\u6307\u5b9a\u306e\u6587\u6cd5\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002key=" + string2);
            }
        }
        int n8 = (string3 = stringBuilder.toString().trim()).endsWith("!*") ? 2 : (string3.endsWith("*") ? 1 : 0);
        StringBuilder stringBuilder2 = new StringBuilder(200);
        if (n8 == 0) {
            String[] stringArray = this.mapObj.get(string3);
            this.restMap.remove(string3);
            if (stringArray != null && n3 < stringArray.length) {
                String string8 = bl3 ? StringUtil.nval((String)((String)this.getRequestAttribute(string3.toUpperCase(Locale.JAPAN))), (String)stringArray[n3]) : stringArray[n3];
                stringBuilder2.append(this.getMapVals(stringArray, string8, bl, string4, string6, null));
            } else {
                stringBuilder2.append(super.getRequestValue(string2, this.xssCheck));
            }
        } else {
            String string9 = string3.substring(0, string3.length() - n8);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map.Entry<String, String[]> entry : this.mapObj.entrySet()) {
                String[] stringArray;
                String string10 = entry.getKey();
                if (!string10.startsWith(string9) || (stringArray = entry.getValue()) == null || n3 >= stringArray.length) continue;
                String string11 = bl2 ? string10.substring(string9.length()) : null;
                String string12 = bl3 ? StringUtil.nval((String)((String)this.getRequestAttribute(string10.toUpperCase(Locale.JAPAN))), (String)stringArray[n3]) : stringArray[n3];
                arrayList.add(this.getMapVals(stringArray, string12, bl, string4, string6, string11));
                this.restMap.remove(string10);
            }
            if (n8 == 2) {
                Collections.reverse(arrayList);
            }
            arrayList.forEach(string -> stringBuilder2.append((String)string));
        }
        return stringBuilder2.toString();
    }

    @Override
    protected int[] getParameterRows() {
        int[] nArray;
        if (this.selectedAll) {
            int n = this.table.getRowCount();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        } else {
            nArray = super.getParameterRows();
        }
        return nArray;
    }

    protected void setParam(ConcurrentMap<ValueMapParamTag.VMP_KEYS, String> concurrentMap) {
        this.paramMap.putAll(concurrentMap);
        this.restChangeKey = (String)this.paramMap.get((Object)ValueMapParamTag.VMP_KEYS.REST_CHANGE_KEY);
    }

    /*
     * WARNING - void declaration
     */
    private String makeRestValue() {
        Object[] objectArray;
        Object object;
        String string = (String)this.paramMap.get((Object)ValueMapParamTag.VMP_KEYS.REST_MARK_CLM);
        String string2 = (String)this.paramMap.get((Object)ValueMapParamTag.VMP_KEYS.REST_MARK_VAL);
        if (!this.restMap.isEmpty() && string != null && string2 != null) {
            int n = this.table.getColumnNo(string, false);
            object = this.getParameterRows();
            if (n >= 0 && ((int[])object).length > 0) {
                void var6_8;
                objectArray = this.getClmNos(this.table, this.keys, 0);
                boolean i = false;
                while (var6_8 < ((int[])object).length) {
                    String[] stringArray = (String[])this.table.getValues((int)var6_8);
                    String string3 = this.getAppendKeys(stringArray, (int[])objectArray, this.separator);
                    if (this.restMap.containsKey(string3)) {
                        this.table.setValueAt(string2, (int)var6_8, n);
                    }
                    ++var6_8;
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        if (this.restMap.isEmpty()) {
            this.useNoneClsKey = this.paramMap.containsKey((Object)ValueMapParamTag.VMP_KEYS.NONE_CLS_KEY);
        } else {
            object = (String)this.paramMap.get((Object)ValueMapParamTag.VMP_KEYS.BODY_VAL);
            for (String string4 : objectArray = this.restMap.keySet().toArray(new String[this.restMap.size()])) {
                String string5 = ((String)object).replaceAll("XXXX", string4);
                stringBuilder.append(this.getRequestParameter(string5));
            }
        }
        return stringBuilder.toString();
    }

    public void setSelectedAll(String string) {
        this.selectedAll = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.selectedAll);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setKeys(String string) {
        this.keys = StringUtil.nval((String)this.getRequestParameter(string), (String)this.keys);
    }

    public void setValClm(String string) {
        this.valClm = StringUtil.nval((String)this.getRequestParameter(string), (String)this.valClm);
    }

    public void setNnClms(String string) {
        this.nnClms = StringUtil.nval((String)this.getRequestParameter(string), (String)this.nnClms);
    }

    public void setHoldTag(String string) {
        this.holdTag = StringUtil.nval((String)this.getRequestParameter(string), (String)this.holdTag);
    }

    public void setClsClms(String string) {
        this.clsClms = StringUtil.nval((String)this.getRequestParameter(string), (String)this.clsClms);
    }

    public void setTipsClms(String string) {
        this.tipsClms = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tipsClms);
    }

    public void setSeparator(String string) {
        this.separator = StringUtil.nval((String)this.getRequestParameter(string), (String)this.separator);
    }

    public void setXssCheck(String string) {
        this.xssCheck = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xssCheck);
    }

    @Override
    public String toString() {
        String string = ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tableId", (Object)this.tableId).println("selectedAll", (Object)this.selectedAll).println("keys", (Object)this.keys).println("holdTag", (Object)this.holdTag).println("clsClms", (Object)this.clsClms).println("tipsClms", (Object)this.tipsClms).println("valClm", (Object)this.valClm).println("nnClms", (Object)this.nnClms).println("scope", (Object)this.scope).println("separator", (Object)this.separator).println("xssCheck", (Object)this.xssCheck).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
        return string.toString();
    }
}

