/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.table;

import java.util.ArrayList;
import java.util.List;

class StandardDeviation {
    private static final String VERSION = "6.7.7.0 (2017/03/31)";
    public static final String[] ADD_CLMS = new String[]{"CNT", "SUM", "AVG", "STDEVS", "STDEVP", "M3S", "M2S", "M1S", "M0S", "P0S", "P1S", "P2S", "P3S"};
    private static final int HIST_SU = 8;
    private final List<Double> data = new ArrayList<Double>();
    private final int ftype;
    private final boolean useDEVP;
    private final String format;
    private double sum;

    public StandardDeviation(int n, boolean bl, String string) {
        this.ftype = n;
        this.useDEVP = bl;
        this.format = string;
    }

    public void clear() {
        this.data.clear();
        this.sum = 0.0;
    }

    public void addData(String string) {
        double d = this.parseDouble(string);
        if (d != 0.0) {
            this.data.add(d);
            this.sum += d;
        }
    }

    public String[] getData() {
        boolean bl;
        int n = this.data.size();
        if (n == 0) {
            return null;
        }
        double d = this.sum / (double)n;
        double d2 = 0.0;
        for (double d3 : this.data) {
            d2 += Math.pow(d3 - d, 2.0);
        }
        double d4 = n == 1 ? 0.0 : Math.sqrt(d2 / (double)(n - 1));
        double d5 = Math.sqrt(d2 / (double)n);
        double d6 = this.useDEVP ? d5 : d4;
        int[] nArray = new int[8];
        for (double d7 : this.data) {
            double d8 = d7 - d;
            if (0.0 == d8 || n == 1) {
                nArray[4] = nArray[4] + 1;
                continue;
            }
            if (d8 < -d6 * 3.0) {
                nArray[0] = nArray[0] + 1;
                continue;
            }
            if (-d6 * 3.0 <= d8 && d8 < -d6 * 2.0) {
                nArray[1] = nArray[1] + 1;
                continue;
            }
            if (-d6 * 2.0 <= d8 && d8 < -d6 * 1.0) {
                nArray[2] = nArray[2] + 1;
                continue;
            }
            if (-d6 * 1.0 <= d8 && d8 < 0.0) {
                nArray[3] = nArray[3] + 1;
                continue;
            }
            if (0.0 <= d8 && d8 < d6 * 1.0) {
                nArray[4] = nArray[4] + 1;
                continue;
            }
            if (d6 * 1.0 <= d8 && d8 < d6 * 2.0) {
                nArray[5] = nArray[5] + 1;
                continue;
            }
            if (d6 * 2.0 <= d8 && d8 < d6 * 3.0) {
                nArray[6] = nArray[6] + 1;
                continue;
            }
            if (!(d6 * 3.0 <= d8)) continue;
            nArray[7] = nArray[7] + 1;
        }
        switch (this.ftype) {
            case 1: {
                bl = nArray[0] + nArray[1] + nArray[2] + nArray[5] + nArray[6] + nArray[7] > 0;
                break;
            }
            case 2: {
                bl = nArray[0] + nArray[1] + nArray[6] + nArray[7] > 0;
                break;
            }
            case 3: {
                bl = nArray[0] + nArray[7] > 0;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl) {
            String[] stringArray = new String[ADD_CLMS.length];
            stringArray[0] = String.valueOf(n);
            stringArray[1] = String.format(this.format, this.sum);
            stringArray[2] = String.format(this.format, d);
            stringArray[3] = String.format(this.format, d4);
            stringArray[4] = String.format(this.format, d5);
            stringArray[5] = String.valueOf(nArray[0]);
            stringArray[6] = String.valueOf(nArray[1]);
            stringArray[7] = String.valueOf(nArray[2]);
            stringArray[8] = String.valueOf(nArray[3]);
            stringArray[9] = String.valueOf(nArray[4]);
            stringArray[10] = String.valueOf(nArray[5]);
            stringArray[11] = String.valueOf(nArray[6]);
            stringArray[12] = String.valueOf(nArray[7]);
            return stringArray;
        }
        return null;
    }

    private double parseDouble(String string) {
        double d = 0.0;
        if (string != null && !string.trim().isEmpty()) {
            try {
                d = Double.parseDouble(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = "\u6587\u5b57\u5217\u3092\u6570\u5024\u306b\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002val=[" + string + "]" + numberFormatException.getMessage();
                System.out.println(string2);
            }
        }
        return d;
    }
}

