/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.nio.file.Path;
import org.opengion.fukurou.fileexec.AppliExec;
import org.opengion.fukurou.fileexec.BasePath;
import org.opengion.fukurou.fileexec.CommandLine;
import org.opengion.fukurou.fileexec.DBUtil;
import org.opengion.fukurou.fileexec.FileUtil;
import org.opengion.fukurou.fileexec.FileWatch;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.StringUtil;
import org.opengion.fukurou.fileexec.XLogger;

public class Machine {
    private static final XLogger LOGGER = XLogger.getLogger(Machine.class.getName());
    public static final String CR = System.getProperty("line.separator");
    private final GE71 tableGE71;
    private final String systemId;
    private final String rsrvNo;
    private final String execId;
    private final String fileFltr;
    private final BasePath basePath;
    private final FileWatch fWatch;

    public Machine(CommandLine commandLine) {
        this.systemId = commandLine.getValue(CommandLine.GE70.SYSTEM_ID);
        this.rsrvNo = commandLine.getValue(CommandLine.GE70.RSRV_NO);
        this.execId = commandLine.getValue(CommandLine.GE70.EXECID);
        this.fileFltr = commandLine.getValue(CommandLine.GE70.FILE_FILTER);
        this.basePath = new BasePath(commandLine.getValue(CommandLine.GE70.DIR_BASE), commandLine.getValue(CommandLine.GE70.DIR_SUB), commandLine.getValue(CommandLine.GE70.DIR_WORK), commandLine.getValue(CommandLine.GE70.DIR_BKUP_OK), commandLine.getValue(CommandLine.GE70.DIR_BKUP_NG));
        this.tableGE71 = new GE71(this.systemId, this.rsrvNo, this.execId);
        this.fWatch = new FileWatch(this.basePath.SUB_PATH);
    }

    public void watchStart() {
        this.fWatch.setEventKinds(FileWatch.CREATE, FileWatch.MODIFY);
        this.fWatch.callback((string, path) -> this.checkFile((String)string, (Path)path));
        this.fWatch.start();
    }

    public void watchStop() {
        this.fWatch.stop();
    }

    private void checkFile(String string, Path path) {
        try {
            if (FileUtil.stablePath(path)) {
                LOGGER.debug(() -> "event=" + string + " , Path=" + path);
                Path path2 = FileUtil.backup(path, this.basePath.WORK_PATH);
                String string2 = StringUtil.getTimeFormat();
                AppliExec appliExec = AppliExec.newInstance(this.systemId, this.execId);
                boolean bl = appliExec.exec(path2);
                Path path3 = null;
                Path path4 = null;
                String string3 = "1";
                if (bl) {
                    path3 = FileUtil.backup(path2, this.basePath.OK_PATH);
                    string3 = "2";
                } else {
                    path4 = FileUtil.backup(path2, this.basePath.NG_PATH);
                    string3 = "8";
                }
                this.tableGE71.dbInsert(string3, string2, path, path3, path4);
                LOGGER.info(() -> "DAT execute. " + path);
            }
        }
        catch (Throwable throwable) {
            MsgUtil.errPrintln(throwable, "MSG0021", path);
            this.tableGE71.dbInsert("7", StringUtil.getTimeFormat(), path, null, null);
        }
    }

    public String toString() {
        return this.systemId + " , " + this.execId;
    }

    private static final class GE71 {
        private static final String[] KEYS = new String[]{"SYSTEM_ID", "RSRV_NO", "EXECID", "FGTKAN", "TMSTR", "TMEND", "FILE_IN", "FILE_OK", "FILE_NG", "DYSET", "DYUPD"};
        private static final String[] CON_KEYS = new String[]{"FGJ", "PGSET", "PGUPD"};
        private static final String[] CON_VALS = new String[]{"1", "Machine", "Machine"};
        private static final String INS_QUERY = DBUtil.getInsertSQL("GE71", KEYS, CON_KEYS, CON_VALS);
        private final String systemId;
        private final String rsrvNo;
        private final String execId;

        public GE71(String string, String string2, String string3) {
            this.systemId = string;
            this.rsrvNo = string2;
            this.execId = string3;
        }

        public void dbInsert(String string, String string2, Path path, Path path2, Path path3) {
            String string3 = StringUtil.getTimeFormat();
            String string4 = path == null ? "" : path.toString();
            String string5 = path2 == null ? "" : path2.toString();
            String string6 = path3 == null ? "" : path3.toString();
            String[] stringArray = new String[]{this.systemId, this.rsrvNo, this.execId, string, string2, string3, string4, string5, string6, string3, string3};
            DBUtil.execute(INS_QUERY, stringArray);
        }
    }
}

