/****************************************************************************/
/* GE74 ( 処理定義ﾏｽﾀ )                                                     */
/*                                                                          */
/* Created : 2017/07/18 08:41:11                                            */
/****************************************************************************/

CREATE TABLE GE74 (
   SYSTEM_ID        VARCHAR2 (   10 )                   NOT NULL            /*  10 ｼｽﾃﾑID       */
 , EXECID           VARCHAR2 (   20 )                   NOT NULL            /*  20 処理ID       */
 , NAME_JA          VARCHAR2 (  200 )                                       /*  30 名称         */
 , SEQNO            NUMBER   (    7 )       DEFAULT 0   NOT NULL            /*  40 表示順       */
 , RUNTYPE          VARCHAR2 (    1 )                   NOT NULL            /*  50 実行方法     */
 , RUNPG            VARCHAR2 (  200 )                                       /*  60 実行ﾌﾟﾛｸﾞﾗﾑ  */
 , PARAMS           VARCHAR2 ( 4000 )                                       /*  70 ﾊﾟﾗﾒｰﾀ       */
 , TORIID           VARCHAR2 (   20 )                                       /*  80 取込ID       */
 , DBID             VARCHAR2 (   20 )                                       /*  90 ﾃﾞｰﾀﾍﾞｰｽID   */
 , TABLE_NAME       VARCHAR2 (   50 )                                       /* 100 ﾃｰﾌﾞﾙ名      */
 , SHT_NOS          VARCHAR2 (   50 )                                       /* 110 ｼｰﾄ番号      */
 , READER_CLS       VARCHAR2 (   20 )                                       /* 120 取込ｸﾗｽ      */
 , FILE_ENC         VARCHAR2 (   20 )                                       /* 130 ｴﾝｺｰﾄﾞ       */
 , SKIP_CNT         NUMBER   (    3 )                   NOT NULL            /* 140 先頭ｽｷｯﾌﾟ数  */
 , NEXTID           VARCHAR2 (   20 )                                       /* 150 次処理ID     */
 , RELEASE_NOTES    VARCHAR2 (  120 )                                       /* 160 ﾘﾘｰｽﾉｰﾄ      */
 , RDC_CODE         VARCHAR2 (   20 )                                       /* 170 設変番号     */
 , UNIQ             NUMBER   (    9 )                   NOT NULL            /* 800 ﾕﾆｰｸｷｰ       */
 , FGJ              VARCHAR2 (    1 )                   NOT NULL            /* 810 状態ﾌﾗｸﾞ     */
 , DYSET            VARCHAR2 (   14 )                                       /* 820 登録日時     */
 , PGSET            VARCHAR2 (   10 )                                       /* 830 作成PG       */
 , PGPSET           VARCHAR2 (   10 )                                       /* 840 作成親PG     */
 , USRSET           VARCHAR2 (   10 )                                       /* 850 作成社員     */
 , DYUPD            VARCHAR2 (   14 )                                       /* 860 更新日時     */
 , PGUPD            VARCHAR2 (   10 )                                       /* 870 更新PG       */
 , PGPUPD           VARCHAR2 (   10 )                                       /* 880 更新親PG     */
 , USRUPD           VARCHAR2 (   10 )                                       /* 890 更新者       */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );


CREATE SEQUENCE GE74S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GE74T00 
  BEFORE INSERT ON GE74
  FOR EACH ROW 
  BEGIN 
    SELECT GE74S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
