/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.awt.Color;
import java.awt.Paint;
import java.util.List;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.plot.RingPlot;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.opengion.hayabusa.io.ChartCreate;
import org.opengion.hayabusa.io.ChartDataset;
import org.opengion.hayabusa.io.ChartPlot;
import org.opengion.hayabusa.io.HybsURLGenerator;

public class ChartPlot_Pie
implements ChartPlot {
    @Override
    public Plot getPlot(ChartCreate chartCreate) {
        List<ChartDataset> list = chartCreate.getDatasetList();
        ChartDataset chartDataset = list.get(0);
        Dataset dataset = chartDataset.getDataset();
        HybsURLGenerator hybsURLGenerator = chartCreate.getURLGenerator();
        boolean bl = chartCreate.isUseToolTip();
        MultiplePiePlot multiplePiePlot = null;
        Color[] colorArray = chartDataset.getChartType();
        if ("Pie".equalsIgnoreCase((String)colorArray) || "Pie3D".equalsIgnoreCase((String)colorArray) || "Ring".equalsIgnoreCase((String)colorArray)) {
            Color[] colorArray2;
            PiePlot piePlot;
            switch (colorArray) {
                case "Pie": {
                    piePlot = new PiePlot();
                    break;
                }
                case "Pie3D": {
                    piePlot = new PiePlot3D();
                    break;
                }
                case "Ring": {
                    piePlot = new RingPlot();
                    break;
                }
                default: {
                    piePlot = new PiePlot();
                }
            }
            piePlot.setDataset((PieDataset)dataset);
            if (hybsURLGenerator != null) {
                piePlot.setURLGenerator((PieURLGenerator)hybsURLGenerator);
            }
            if (bl) {
                piePlot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
            }
            if ((colorArray2 = chartDataset.getSeriesColors()) != null && colorArray2.length > 0) {
                int n = ((PieDataset)dataset).getItemCount();
                for (int i = 0; i < colorArray2.length && i < n; ++i) {
                    Comparable comparable = ((PieDataset)dataset).getKey(i);
                    piePlot.setSectionPaint(comparable, (Paint)colorArray2[i]);
                }
            }
            multiplePiePlot = piePlot;
        } else if ("MultiplePie".equalsIgnoreCase((String)colorArray)) {
            multiplePiePlot = new MultiplePiePlot();
            multiplePiePlot.setDataset((CategoryDataset)dataset);
        } else if ("SpiderWeb".equalsIgnoreCase((String)colorArray)) {
            Color[] colorArray3;
            multiplePiePlot = new SpiderWebPlot();
            ((SpiderWebPlot)multiplePiePlot).setDataset((CategoryDataset)dataset);
            if (hybsURLGenerator != null) {
                ((SpiderWebPlot)multiplePiePlot).setURLGenerator((CategoryURLGenerator)hybsURLGenerator);
            }
            if (bl) {
                ((SpiderWebPlot)multiplePiePlot).setToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
            }
            if ((colorArray3 = chartDataset.getSeriesColors()) != null && colorArray3.length > 0) {
                for (int i = 0; i < colorArray3.length; ++i) {
                    ((SpiderWebPlot)multiplePiePlot).setSeriesPaint(i, (Paint)colorArray3[i]);
                }
            }
        } else if ("Polar".equalsIgnoreCase((String)colorArray)) {
            multiplePiePlot = new PolarPlot();
            ((PolarPlot)multiplePiePlot).setDataset((XYDataset)dataset);
        } else if ("Meter".equalsIgnoreCase((String)colorArray)) {
            multiplePiePlot = chartDataset.makeMeterPlot();
        } else if ("Thermometer".equalsIgnoreCase((String)colorArray)) {
            multiplePiePlot = chartDataset.makeThermometerPlot();
        } else if ("Compass".equalsIgnoreCase((String)colorArray)) {
            multiplePiePlot = chartDataset.makeCompassPlot();
        }
        return multiplePiePlot;
    }
}

