/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.StringUtil;

public final class FileUtil {
    public static final int STABLE_SLEEP_TIME = 2000;
    public static final int STABLE_RETRY_COUNT = 10;
    public static final int LOCK_SLEEP_TIME = 2000;
    public static final int LOCK_RETRY_COUNT = 10;
    public static final Charset WINDOWS_31J = Charset.forName("Windows-31J");
    private static final OpenOption[] CREATE = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] APPEND = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    private static final Object STATIC_LOCK = new Object();
    private static final FileVisitor<Path> DELETE_VISITOR = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            Files.deleteIfExists(path);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
            if (iOException == null) {
                Files.deleteIfExists(path);
                return FileVisitResult.CONTINUE;
            }
            throw iOException;
        }
    };
    public static final String USAGE = "Usage: java jp.euromap.eu63.util.FileUtil [-MOVE|-COPY|-DELETE|-BACKUP|-SAVE] from to [-useLock] [-append] [-help]";

    private FileUtil() {
    }

    public static Path readPath(String string, String ... stringArray) {
        Path path = Paths.get(string, stringArray).toAbsolutePath().normalize();
        if (!Files.exists(path, new LinkOption[0])) {
            throw MsgUtil.throwException("MSG0002", path);
        }
        return path;
    }

    public static Path writePath(String string, String ... stringArray) {
        Path path = Paths.get(string, stringArray).toAbsolutePath().normalize();
        FileUtil.mkdirs(path);
        return path;
    }

    public static Path newPath(Path path, String string) {
        if (string == null || string.isEmpty()) {
            return path;
        }
        if (string.charAt(0) == '/' || string.charAt(0) == '\\' || string.length() > 1 && string.charAt(1) == ':') {
            return new File(string).toPath();
        }
        return path.resolve(string);
    }

    public static void mkdirs(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            Path path2;
            boolean bl = path.getFileName().toString().contains(".");
            Path path3 = path2 = bl ? path.toAbsolutePath().getParent() : path;
            if (Files.notExists(path2, new LinkOption[0])) {
                try {
                    Files.createDirectories(path2, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    throw MsgUtil.throwException(iOException, "MSG0007", path2);
                }
            }
        }
    }

    public static void copy(Path path, Path path2) {
        FileUtil.copy(path, path2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Path path, Path path3, boolean bl) {
        if (Files.exists(path, new LinkOption[0])) {
            FileUtil.mkdirs(path3);
            boolean bl2 = path3.getFileName().toString().contains(".");
            Path path4 = bl2 ? path3 : path3.resolve(path.getFileName());
            Object object = STATIC_LOCK;
            synchronized (object) {
                if (bl) {
                    FileUtil.lockPath(path, path2 -> FileUtil.localCopy(path2, path4));
                } else {
                    FileUtil.localCopy(path, path4);
                }
            }
        } else {
            MsgUtil.errPrintln("MSG0002", path);
        }
    }

    private static void localCopy(Path path, Path path2) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            MsgUtil.errPrintln(iOException, "MSG0012", path, path2);
        }
    }

    public static void move(Path path, Path path2) {
        FileUtil.move(path, path2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void move(Path path, Path path3, boolean bl) {
        if (Files.exists(path, new LinkOption[0])) {
            FileUtil.mkdirs(path3);
            boolean bl2 = path3.getFileName().toString().contains(".");
            Path path4 = bl2 ? path3 : path3.resolve(path.getFileName());
            Object object = STATIC_LOCK;
            synchronized (object) {
                if (bl) {
                    FileUtil.lockPath(path, path2 -> FileUtil.localMove(path2, path4));
                } else {
                    FileUtil.localMove(path, path4);
                }
            }
        } else {
            MsgUtil.errPrintln("MSG0002", path);
        }
    }

    private static void localMove(Path path, Path path2) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.move(path, path2, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            MsgUtil.errPrintln(iOException, "MSG0008", path, path2);
        }
    }

    public static Path backup(Path path, Path path2, String string) {
        return FileUtil.backup(path, path2, true, false, string);
    }

    public static Path backup(Path path, Path path2) {
        return FileUtil.backup(path, path2, true, true, null);
    }

    public static Path backup(Path path, Path path2, boolean bl, boolean bl2, String string) {
        Path path3;
        boolean bl3;
        Path path4 = path2 == null ? path.getParent() : path2;
        String string2 = path.getFileName().toString();
        Path path5 = path4.resolve(string2);
        boolean bl4 = bl3 = bl2 && Files.notExists(path5, new LinkOption[0]);
        if (bl3) {
            path3 = path5;
        } else {
            int n = string2.lastIndexOf(46);
            path3 = path4.resolve(string2.substring(0, n) + "_" + StringUtil.nval(string, StringUtil.getTimeFormat()) + string2.substring(n));
        }
        FileUtil.move(path, path3, bl);
        return path3;
    }

    public static void mergeFile(Path path, Path path2) {
        if (!path.equals(path2) && Files.exists(path2, new LinkOption[0])) {
            try {
                String string;
                List<String> list = Files.readAllLines(path2, StandardCharsets.UTF_8);
                if (list.size() >= 2 && (string = list.get(0)).contains("COUNT") && string.contains("DATE") && string.contains("TIME")) {
                    list.remove(0);
                }
                FileUtil.save(path, list, true);
                Files.deleteIfExists(path2);
            }
            catch (IOException iOException) {
                throw MsgUtil.throwException(iOException, "MSG0003", path2.toAbsolutePath().normalize());
            }
        }
    }

    public static void delete(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.walkFileTree(path, DELETE_VISITOR);
            }
        }
        catch (IOException iOException) {
            throw MsgUtil.throwException(iOException, "MSG0011", path);
        }
    }

    public static boolean stablePath(Path path) {
        return FileUtil.stablePath(path, 2000L, 10);
    }

    public static boolean stablePath(Path path, long l, int n) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                for (int i = 0; i < n; ++i) {
                    if (Files.notExists(path, new LinkOption[0])) {
                        return false;
                    }
                    long l2 = Files.size(path);
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (Files.notExists(path, new LinkOption[0])) {
                        return false;
                    }
                    long l3 = Files.size(path);
                    if (l2 == 0L || l2 != l3) continue;
                    return true;
                }
            }
            catch (IOException iOException) {
                MsgUtil.errPrintln(iOException, "MSG0005", path);
            }
        }
        return false;
    }

    public static void lockPath(Path path, Consumer<Path> consumer) {
        if (Files.exists(path, new LinkOption[0])) {
            try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.READ);){
                for (int i = 0; i < 10; ++i) {
                    try {
                        if (fileChannel.tryLock(0L, Long.MAX_VALUE, true) != null) {
                            consumer.accept(path);
                            return;
                        }
                    }
                    catch (OverlappingFileLockException overlappingFileLockException) {
                        System.err.println(overlappingFileLockException.getMessage());
                    }
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException iOException) {
                throw MsgUtil.throwException(iOException, "MSG0005", path);
            }
            MsgUtil.errPrintln("MSG0015", path, 2000, 10);
        }
    }

    public static void forEach(Path path, Consumer<String> consumer) {
        if (Files.exists(path, new LinkOption[0])) {
            String string = null;
            int n = 0;
            try (FileInputStream fileInputStream = new FileInputStream(path.toFile());
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                while ((string = bufferedReader.readLine()) != null) {
                    consumer.accept(string);
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw MsgUtil.throwException(iOException, "MSG0016", path, n, string);
            }
        }
    }

    public static void lockForEach(Path path2, Consumer<String> consumer) {
        FileUtil.lockPath(path2, path -> FileUtil.forEach(path, consumer));
    }

    public static void save(Path path, List<String> list) {
        FileUtil.save(path, list, false);
    }

    public static void save(Path path, List<String> list, boolean bl) {
        FileUtil.mkdirs(path.toAbsolutePath().getParent());
        String string = null;
        int n = 0;
        try (PrintWriter printWriter = new PrintWriter(Files.newBufferedWriter(path, StandardCharsets.UTF_8, bl ? APPEND : CREATE));){
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2;
                string = string2 = iterator.next();
                ++n;
                printWriter.println(string);
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            throw MsgUtil.throwException(iOException, "MSG0017", path, n, string);
        }
    }

    public static void lockSave(Path path, List<String> list) {
        FileUtil.lockSave(path, list, false);
    }

    public static void lockSave(Path path, List<String> list, boolean bl) {
        FileUtil.mkdirs(path.toAbsolutePath().getParent());
        String string = null;
        int n = 0;
        try {
            try (PrintWriter printWriter = new PrintWriter(Files.newBufferedWriter(path, StandardCharsets.UTF_8, bl ? APPEND : CREATE));){
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    string = string2 = iterator.next();
                    ++n;
                    printWriter.println(string);
                }
                printWriter.flush();
            }
            return;
        }
        catch (OverlappingFileLockException overlappingFileLockException) {
            System.err.println(overlappingFileLockException.getMessage());
        }
        catch (IOException iOException) {
            throw MsgUtil.throwException(iOException, "MSG0017", path, n, string);
        }
        MsgUtil.errPrintln("MSG0015", path, 2000, 10);
    }

    public static String timeStamp(Path path, String string) {
        long l = 0L;
        try {
            if (Files.exists(path, new LinkOption[0])) {
                l = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            }
        }
        catch (IOException iOException) {
            MsgUtil.errPrintln(iOException, "MSG0018", path, iOException.getMessage());
        }
        if (l == 0L) {
            l = System.currentTimeMillis();
        }
        return StringUtil.getTimeFormat(l, string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println(USAGE);
            return;
        }
        Path path = null;
        Path path2 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        int n2 = 0;
        for (String string2 : stringArray) {
            if ("-help".equalsIgnoreCase(string2)) {
                System.out.println(USAGE);
                return;
            }
            if ("-useLock".equalsIgnoreCase(string2)) {
                bl = true;
                continue;
            }
            if ("-append ".equalsIgnoreCase(string2)) {
                bl2 = true;
                continue;
            }
            if ("-MOVE".equalsIgnoreCase(string2)) {
                n = 0;
                continue;
            }
            if ("-COPY".equalsIgnoreCase(string2)) {
                n = 1;
                continue;
            }
            if ("-DELETE".equalsIgnoreCase(string2)) {
                n = 2;
                continue;
            }
            if ("-BACKUP".equalsIgnoreCase(string2)) {
                n = 3;
                continue;
            }
            if ("-SAVE".equalsIgnoreCase(string2)) {
                n = 4;
                continue;
            }
            if (n2 == 0) {
                path = FileUtil.readPath(string2, new String[0]);
            } else if (n2 == 1) {
                path2 = FileUtil.writePath(string2, new String[0]);
            }
            ++n2;
        }
        switch (n) {
            case 0: {
                System.out.println("TYPE=MOVE FROM=" + path + " , TO=" + path2);
                FileUtil.move(path, path2, bl);
                break;
            }
            case 1: {
                System.out.println("TYPE=COPY FROM=" + path + " , TO=" + path2);
                FileUtil.copy(path, path2, bl);
                break;
            }
            case 2: {
                System.out.println("TYPE=DELETE START=" + path);
                FileUtil.delete(path);
                break;
            }
            case 3: {
                System.out.println("TYPE=BACKUP FROM=" + path + " , TO=" + path2);
                FileUtil.backup(path, path2, bl, false, null);
                break;
            }
            case 4: {
                System.out.println("TYPE=SAVE FROM=" + path + " , TO=" + path2);
                if (bl) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    FileUtil.lockForEach(path, string -> arrayList.add((String)string));
                    FileUtil.lockSave(path2, arrayList, bl2);
                    break;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                FileUtil.forEach(path, string -> arrayList.add((String)string));
                FileUtil.save(path2, arrayList, bl2);
                break;
            }
            default: {
                System.out.println(USAGE);
            }
        }
    }
}

