/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import com.sun.nio.file.ExtendedWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import org.opengion.fukurou.fileexec.DirWatch;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.PathMatcherSet;
import org.opengion.fukurou.fileexec.XLogger;

public class FileWatch
implements Runnable {
    private static final XLogger LOGGER = XLogger.getLogger(FileWatch.class.getName());
    public static final WatchEvent.Kind<Path> CREATE = StandardWatchEventKinds.ENTRY_CREATE;
    public static final WatchEvent.Kind<Path> MODIFY = StandardWatchEventKinds.ENTRY_MODIFY;
    public static final WatchEvent.Kind<Path> DELETE = StandardWatchEventKinds.ENTRY_DELETE;
    public static final WatchEvent.Kind<?> OVERFLOW = StandardWatchEventKinds.OVERFLOW;
    private static final WatchEvent.Kind<?>[] WE_KIND = new WatchEvent.Kind[]{CREATE, MODIFY, DELETE, OVERFLOW};
    private static final WatchEvent.Modifier[] WE_MOD_ONE = new WatchEvent.Modifier[0];
    private static final WatchEvent.Modifier[] WE_MOD_TREE = new WatchEvent.Modifier[]{ExtendedWatchEventModifier.FILE_TREE};
    public static final String DIR_WATCH_EVENT = "DirWatch";
    private final Path dirPath;
    private final boolean useTree;
    private final WatchEvent.Modifier[] extModifiers;
    private BiConsumer<String, Path> action = (string, path) -> System.out.println("Event=" + string + " , Path=" + path);
    private WatchEvent.Kind<?>[] weKind = WE_KIND;
    private final PathMatcherSet pathMch = new PathMatcherSet();
    private final PathMatcherSet dirWatchMch = new PathMatcherSet();
    private boolean useDirWatch = true;
    private DirWatch dWatch;
    private Thread thread;
    public static final String USAGE = "Usage: java jp.euromap.eu63.util.FileWatch [[-S] dir]...";

    public FileWatch(Path path) {
        this(path, false);
    }

    public FileWatch(Path path2, boolean bl) {
        this.dirPath = path2;
        this.useTree = bl;
        this.extModifiers = bl ? WE_MOD_TREE : WE_MOD_ONE;
    }

    public void setEventKinds(WatchEvent.Kind<?> ... kindArray) {
        if (kindArray != null && kindArray.length > 0) {
            this.weKind = kindArray;
        }
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMch.addPathMatcher(pathMatcher);
    }

    public void setPathEndsWith(String ... stringArray) {
        this.pathMch.addEndsWith(stringArray);
    }

    public void callback(BiConsumer<String, Path> biConsumer) {
        if (biConsumer != null) {
            this.action = biConsumer;
        }
    }

    public void setUseDirWatch(boolean bl) {
        this.useDirWatch = bl;
    }

    public void setDirWatchEndsWith(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.useDirWatch = true;
            this.dirWatchMch.addEndsWith(stringArray);
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
        if (this.useDirWatch) {
            this.dWatch = new DirWatch(this.dirPath, this.useTree);
            if (this.dirWatchMch.isEmpty()) {
                this.dWatch.setPathMatcher(this.pathMch);
            } else {
                this.dWatch.setPathMatcher(this.dirWatchMch);
            }
            this.dWatch.callback((Path path) -> this.action.accept(DIR_WATCH_EVENT, (Path)path));
            this.dWatch.start();
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        if (this.dWatch != null) {
            this.dWatch.stop();
            this.dWatch = null;
        }
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (IOException iOException) {
            MsgUtil.errPrintln(iOException, "MSG3002", this.dirPath);
        }
        catch (Throwable throwable) {
            MsgUtil.errPrintln(throwable, "MSG0021", this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() throws IOException {
        LOGGER.info(() -> "FileWatch Start: " + this.dirPath);
        try (FileSystem fileSystem = this.dirPath.getFileSystem();
             WatchService watchService = fileSystem.newWatchService();){
            WatchKey watchKey = this.dirPath.register(watchService, this.weKind, this.extModifiers);
            try {
                boolean bl = true;
                while (bl) {
                    WatchKey watchKey2 = watchService.take();
                    if (watchKey2.equals(watchKey)) {
                        for (WatchEvent<?> watchEvent : watchKey2.pollEvents()) {
                            Path path = (Path)watchEvent.context();
                            if (path == null || !this.pathMch.matches(path)) continue;
                            this.action.accept(watchEvent.kind().name(), this.dirPath.resolve(path));
                        }
                    }
                    watchKey2.reset();
                    bl = watchKey.isValid() && !Thread.currentThread().isInterrupted();
                }
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warning(() -> "FileWatch Canceled:" + this.dirPath);
            }
            finally {
                watchKey.cancel();
            }
        }
        LOGGER.info(() -> "FileWatch End: " + this.dirPath);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println(USAGE);
            return;
        }
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        boolean bl = false;
        for (String string2 : stringArray) {
            if ("-help".equalsIgnoreCase(string2)) {
                System.out.println(USAGE);
                return;
            }
            if ("-S".equalsIgnoreCase(string2)) {
                bl = true;
                continue;
            }
            Path path2 = new File(string2).toPath();
            FileWatch fileWatch = new FileWatch(path2, bl);
            fileWatch.callback((string, path) -> System.out.println(string + ": path=" + path.toString()));
            Thread thread2 = new Thread(fileWatch);
            thread2.start();
            arrayList.add(thread2);
            bl = false;
        }
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        arrayList.forEach(thread -> thread.interrupt());
        System.out.println("done.");
    }
}

