/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.fileexec.CommandLine;
import org.opengion.fukurou.fileexec.Machine;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.XLogger;

public final class MainProcess {
    private static final XLogger LOGGER = XLogger.getLogger(MainProcess.class.getName());
    private final ConcurrentMap<Integer, Machine> machMap = new ConcurrentHashMap<Integer, Machine>();
    public static final String USAGE = "Usage: java org.opengion.fukurou.fileexec.MainProcess [-LOOP n(\u79d2)] [-help]";

    public void startTask(CommandLine commandLine) {
        int n = Integer.parseInt(commandLine.getValue(CommandLine.GE70.RSRV_NO));
        this.stopTask(n);
        String string = commandLine.getValue(CommandLine.GE70.FGYKAN);
        if ("4".equals(string)) {
            return;
        }
        Machine machine = new Machine(commandLine);
        LOGGER.info(() -> "Task Scheduled. yoyakuNo=[" + n + "]");
        machine.watchStart();
        this.machMap.put(n, machine);
    }

    private void stopTask(int n) {
        Machine machine = (Machine)this.machMap.remove(n);
        if (machine != null) {
            machine.watchStop();
        }
        LOGGER.info(() -> "Task Stoped. yoyakuNo=[" + n + "]");
    }

    public void watchStop() {
        LOGGER.debug(() -> "WatchStop All");
        this.machMap.forEach((n, machine) -> machine.watchStop());
    }

    public static void main(String[] stringArray) {
        Object object;
        int n = 10;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if ("-help".equalsIgnoreCase((String)object)) {
                System.out.println(USAGE);
                return;
            }
            if (!"-LOOP".equalsIgnoreCase((String)object)) {
                throw MsgUtil.throwException("MSG2011", Arrays.toString(stringArray));
            }
            n = Integer.parseInt(stringArray[++i]);
        }
        MainProcess mainProcess = new MainProcess();
        block5: while (true) {
            try {
                while (true) {
                    object = CommandLine.dbCommand();
                    object.forEach(commandLine -> mainProcess.startTask((CommandLine)commandLine));
                    try {
                        Thread.sleep((long)n * 1000L);
                        continue block5;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                MsgUtil.errPrintln(throwable, "MSG0021", throwable.getMessage());
                mainProcess.watchStop();
                continue;
            }
            break;
        }
    }
}

