/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.model;

/**
 * １レコードのデータを管理するインターフェースです。
 * Formatter で使用される単純なメソッドを定義しています。
 *
 * @og.group 画面表示
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public interface DataModel<T> {

	/**
	 * 変更されたタイプ(追加)
	 *
	 * @og.rev 6.7.9.1 (2017/05/19) インターフェースの見直しにより、追加
	 */
	String INSERT_TYPE = "A";

	/**
	 * 変更されたタイプ(変更)
	 *
	 * @og.rev 6.7.9.1 (2017/05/19) インターフェースの見直しにより、追加
	 */
	String UPDATE_TYPE = "C";

	/**
	 * 変更されたタイプ(削除)
	 *
	 * @og.rev 6.7.9.1 (2017/05/19) インターフェースの見直しにより、追加
	 */
	String DELETE_TYPE = "D";

	/**
	 * row にあるセルのオブジェクト値を置き換えます。
	 *
	 * @param   vals  新しい配列値。
	 * @param   row   値が変更される行(無視されます)
	 */
	void setValues( final T[] vals,final int row ) ;

//	/**
//	 * column および row にあるセルのオブジェクト値を設定します。
//	 *
//	 * @og.rev 6.7.9.1 (2017/05/19) インターフェースの見直しにより、追加
//	 *
//	 * @param   value	新しい値。null も可
//	 * @param   row		値が変更される行
//	 * @param   clm		値が変更される列
//	 */
//	void setValueAt( String value, int row, int clm ) ;

	/**
	 * カラム名に対応する カラム番号を返します。
	 *
	 * 特殊なカラムが指定された場合は、負の値を返します。
	 * 例えば、[KEY.カラム名]、[I]、[ROW.ID] など、特定の負の値を返します。
	 * また、カラム名が元のデータモデルに存在しない場合も、負の値か、
	 * Exception を返します。負の値なのか、Exception なのかは、
	 * 実装に依存します。
	 *
	 * @param   columnName  値が参照されるカラム番号
	 *
	 * @return  指定されたセルのカラム番号
	 */
	int getColumnNo( final String columnName ) ;

//	/**
//	 * カラム名配列に対応する カラム番号配列を返します。
//	 *
//	 * これは、#getColumnNo( String ) に対する 複数のカラム名を検索した
//	 * 場合と同じです。
//	 *
//	 * @param	clmNms 	値が参照されるカラム名配列(可変長引数)
//	 *
//	 * @return  指定されたセルのカラム番号配列。
//	 * @og.rtnNotNull
//	 */
//	int[] getColumnNos( final String... clmNms ) ;

	/**
	 * カラム名配列を返します。
	 * 配列オブジェクトは、clone されたコピーを返します。
	 *
	 * @return	カラム名配列
	 */
	String[] getNames();

	/**
	 * row にあるセルの属性値を配列で返します。
	 *
	 * @param   row     値が参照される行
	 *
	 * @return  指定されたセルの属性値
	 */
	T[] getValues( int row ) ;

	/**
	 * row および clm にあるセルの属性値を返します。
	 *
	 * @param   row     値が参照される行
	 * @param   clm     値が参照される列
	 *
	 * @return  指定されたセルの値 T
	 */
	T getValue( int row, int clm ) ;

	/**
	 * データテーブル内の行の数を返します。
	 *
	 * 後付I/Fのため、default 設定しておきます。
	 *
	 * @og.rev 6.7.9.1 (2017/05/19) インターフェースの見直しにより、追加
	 *
	 * @return  モデルの行数
	 */
	default int getRowCount() { return -1; }

	/**
	 * row 単位に変更されたタイプ(追加/変更/削除)を返します。
	 *
	 * 後付I/Fのため、default 設定しておきます。
	 *
	 * @og.rev 6.7.9.1 (2017/05/19) インターフェースの見直しにより、追加
	 *
	 * @param   row     値が参照される行
	 *
	 * @return  変更されたタイプの値 String
	 */
	default String getModifyType( int row ) { return ""; }

	/**
	 * row 単位に変更タイプ(追加/変更/削除)をセットします。
	 * このメソッドでは、データのバックアップは取りません。
	 * タイプは始めに一度登録するとそれ以降に変更はかかりません。
	 * なにも変更されていない場合は, ""(ゼロストリング)の状態です。
	 *
	 * 後付I/Fのため、default 設定しておきます。
	 *
	 * @og.rev 6.7.9.1 (2017/05/19) インターフェースの見直しにより、追加
	 *
	 * @param   row      値が参照される行
	 * @param   modType  変更タイプ(追加/変更/削除)
	 *
	 */
	default void setModifyType( int row,String modType ) {}

	/**
	 * clm のNativeタイプを返します。
	 * Nativeタイプはorg.opengion.fukurou.model.NativeTypeで定義されています。
	 *
	 * @og.rev 4.1.1.2 (2008/02/28) 新規追加
	 *
	 * @param  clm      値が参照される列
	 *
	 * @return Nativeタイプ
	 * @see org.opengion.fukurou.model.NativeType
	 */
	NativeType getNativeType( int clm );
}
