/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.hayabusa.common.HybsSystemException;

import java.util.Map;
// import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;							// 6.4.3.3 (2016/03/04)
import java.util.concurrent.ConcurrentHashMap;						// 6.4.3.1 (2016/02/12) refactoring
// import java.io.ObjectOutputStream;
// import java.io.ObjectInputStream;
// import java.io.IOException;

/**
 * ViewFormTag にパラメーターを渡す為のスーパークラスです。
 *
 * ViewForm 関連の各クラスは、特殊・専用化の傾向が強くなりつつあり、
 * 設定するパラメーターも増えています。これらのパラメータを、共通の
 * ViewFormインターフェースに設定することは、得策とは考えられない為、
 * パラメーターを一括して渡すようにします。
 * ただし、key1=**** val2=**** 的な渡し方では、エラーチェックや自動ドキュメント化
 * が難しいため、各ViewFormのサブクラスごとに、パラメータクラスを作成し、
 * それらのスーパークラスとして、最終的には、同一方法で、パラメータオブジェクト
 * として渡すことにします。
 *
 * @og.rev 3.5.4.8 (2004/02/23) 新規作成
 * @og.rev 6.3.4.0 (2015/08/01) ViewParamTag.java → ViewParamImpl.java
 * @og.group 画面表示
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
// public class ViewParamTag extends CommonTagSupport {
class ViewParamImpl extends CommonTagSupport {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.4.8.2 (2016/07/08)" ;
	private static final long serialVersionUID = 648220160708L ;

	/** 6.4.3.1 (2016/02/12) PMD refactoring. HashMap → ConcurrentHashMap に置き換え。  */
//	private transient Map<String,String> paramMap ;					// 3.5.6.2 (2004/07/05)
//	private transient ConcurrentMap<String,String> paramMap ;			// 6.4.3.3 (2016/03/04)
	private final ConcurrentMap<String,String> paramMap = new ConcurrentHashMap<>();		// 6.4.3.3 (2016/03/04)
	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public ViewParamImpl() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * Taglibの終了タグが見つかったときに処理する doEndTag() を オーバーライドします。
	 *
	 * @og.rev 6.4.4.1 (2016/03/18) 設定元のMapをクリアすると、データが消えてしまうので、新規に作る。
	 * @og.rev 6.4.8.2 (2016/07/08) debug 属性を、パラメータにセットします。
	 *
	 * @return	後続処理の指示
	 */
	@Override
	public int doEndTag() {
		debugPrint();		// 4.0.0 (2005/02/28)

		putParam( "debug" , String.valueOf ( isDebug() ) );		// 6.4.8.2 (2016/07/08)

		final ViewFormTag viewform = (ViewFormTag)findAncestorWithClass( this,ViewFormTag.class );
		if( viewform == null ) {
			final String errMsg = "<b>" + getTagName() + "タグは、ViewFormTagの内側(要素)に記述してください。</b>";
			throw new HybsSystemException( errMsg );
		}

		// 6.4.4.1 (2016/03/18) 
//		viewform.setParam( paramMap );
		viewform.setParam( new ConcurrentHashMap<>( paramMap ) );

		return EVAL_PAGE ;
	}

	/**
	 * タグリブオブジェクトをリリースします。
	 * キャッシュされて再利用されるので、フィールドの初期設定を行います。
	 *
	 * @og.rev 6.4.3.3 (2016/03/04) Mapの初期化を、clear()メソッドで行う。
	 */
	@Override
	protected void release2() {
		super.release2();		// 3.5.6.0 (2004/06/18) 追加(抜けていた)
//		paramMap = null;
		paramMap.clear();
	}

	/**
	 * パラメータのMapを初期設定します。
	 *
	 * パラメータのキーと値の初期値をセットしたMapを初期設定します。
	 * 処理のタイミングとして、すでにパラメータ変数は、設定されています。
//	 * 一つも設定されていない場合は、paramMap == null なので、引数の初期値マップを
//	 * そのまま（コピーして）作成します。
	 * すでに、登録されている場合は、キーが存在しているため、キーの存在しない
	 * データのみ、初期値マップからコピーします。
	 *
	 * @og.rev 5.5.5.6 (2012/08/31) 新規追加
	 * @og.rev 6.0.2.5 (2014/10/31) entrySet イテレータを使用するように変更。
	 * @og.rev 6.4.3.1 (2016/02/12) PMD refactoring. HashMap → ConcurrentHashMap に置き換え。
	 * @og.rev 6.4.3.3 (2016/03/04) Mapの初期化を、clear()メソッドで行う。
	 *
	 * @param   map		パラメータのMap(null値を許容する)
	 */
	protected void initParam( final Map<String,String> map ) {
//		if( paramMap == null ) {
//			// 6.4.3.1 (2016/02/12) PMD refactoring. HashMap → ConcurrentHashMap に置き換え。
////			paramMap = new HashMap<>( map );
//			paramMap = new ConcurrentHashMap<>( map );
//		}
//		else {
			// 6.4.3.3 (2016/03/04) キーが存在しなければ、初期化情報を登録する処理を、Map#putIfAbsent を使用して実現します。
			// putIfAbsent → 追加有り、置換なし、削除なし
			if( map != null ) {
				map.forEach( (k,v) -> { if( v != null ) { paramMap.putIfAbsent(k,v); } } );
			}

//			// 6.0.2.5 (2014/10/31) entrySet イテレータを使用するように変更。
//			for( final Map.Entry<String, String> ent : map.entrySet() ) {
//				// 6.4.3.1 (2016/02/12) ConcurrentHashMap は、key,val ともに、not null 制限がある。
//				final String key = ent.getKey();
//				final String val = ent.getValue();
//				if( key != null && val != null && !paramMap.containsKey( key ) ) {			// キーが存在しなければ、初期化情報を登録する。
//					paramMap.put( key,val );
//				}
////				if( !paramMap.containsKey( ent.getKey() ) ) {			// キーが存在しなければ、初期化情報を登録する。
////					paramMap.put( ent.getKey(),ent.getValue() );
////				}
//			}
//		}
	}

	/**
	 * パラメータのキーと値をセットします。
	 *
	 * @og.rev 6.4.3.1 (2016/02/12) PMD refactoring. HashMap → ConcurrentHashMap に置き換え。
	 * @og.rev 6.4.3.3 (2016/03/04) Mapの初期化を、clear()メソッドで行う。
	 *
	 * @param   key		キー
	 * @param   value	値
	 */
	protected void putParam( final String key, final String value ) {
//		if( key != null ) {
		if( key != null && value != null ) {
			// 6.4.3.1 (2016/02/12) PMD refactoring. HashMap → ConcurrentHashMap に置き換え。
//			if( paramMap == null ) { paramMap = new HashMap<>(); }
//			if( paramMap == null ) { paramMap = new ConcurrentHashMap<>(); }
			paramMap.put( key,value );
		}
	}

//	/**
//	 * シリアライズ用のカスタムシリアライズ書き込みメソッド。
//	 *
//	 * @og.rev 4.0.0.0 (2006/09/31) 新規追加
//	 * @serialData 一部のオブジェクトは、シリアライズされません。
//	 *
//	 * @param	strm	ObjectOutputStreamオブジェクト
//	 * @throws IOException	入出力エラーが発生した場合
//	 */
//	private void writeObject( final ObjectOutputStream strm ) throws IOException {
//		strm.defaultWriteObject();
//	}

//	/**
//	 * シリアライズ用のカスタムシリアライズ読み込みメソッド
//	 *
//	 * ここでは、transient 宣言された内部変数の内、初期化が必要なフィールドのみ設定します。
//	 *
//	 * @og.rev 4.0.0.0 (2006/09/31) 新規追加
//	 * @serialData 一部のオブジェクトは、シリアライズされません。
//	 *
//	 * @param	strm	ObjectInputStreamオブジェクト
//	 * @see #release2()
//	 * @throws IOException	シリアライズに関する入出力エラーが発生した場合
//	 * @throws ClassNotFoundException	クラスを見つけることができなかった場合
//	 */
//	private void readObject( final ObjectInputStream strm ) throws IOException , ClassNotFoundException {
//		strm.defaultReadObject();
//	}

	/**
	 * このオブジェクトの文字列表現を返します。
	 * 基本的にデバッグ目的に使用します。
	 *
	 * @og.rev 5.2.1.0 (2010/10/01) Map の内容表示方法を変更
	 * @og.rev 6.4.3.3 (2016/03/04) Mapの初期化を、clear()メソッドで行う。
	 *
	 * @return このクラスの文字列表現
	 * @og.rtnNotNull
	 */
	@Override
	public String toString() {
		final StringBuilder rtn = new StringBuilder( BUFFER_MIDDLE );

		// 6.0.2.5 (2014/10/31) char を append する。
		rtn.append( '[' ).append( this.getClass().getName() ).append( ']' ).append( CR );
		paramMap.forEach( (k,v) -> { rtn.append( k ).append( '=' ).append( v ).append( CR ); } );

//		if( paramMap != null ) {
//			for( final Map.Entry<String, String> ent : paramMap.entrySet() ) {
//				rtn.append( ent.getKey() ).append( '=' ).append( ent.getValue() ).append( CR );
//			}
//		}

		return rtn.toString();
	}
}
