/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.fileexec.DBUtil;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.XLogger;

public final class AppliExec {
    private static final XLogger LOGGER = XLogger.getLogger(AppliExec.class.getName());
    private static final ConcurrentMap<String, AppliExec> APP_EXEC_MAP = new ConcurrentHashMap<String, AppliExec>();
    private final String[] ge74Data;

    private AppliExec(String string, String string2) {
        LOGGER.debug(() -> "[AppliExec] systemId=" + string + " , execId=" + string2);
        List<String[]> list = DBUtil.dbQuery(GE74.SELECT, string, string2);
        if (list.isEmpty()) {
            throw MsgUtil.throwException("MSG2001", "SYSTEM_ID=" + string + " , EXECID=" + string2);
        }
        this.ge74Data = list.get(0);
    }

    public static AppliExec newInstance(String string, String string2) {
        String string4 = string + "_" + string2;
        return APP_EXEC_MAP.computeIfAbsent(string4, string3 -> new AppliExec(string, string2));
    }

    public boolean exec(Path path) {
        LOGGER.debug(() -> "exec() : Path=" + path + " , runType=" + this.ge74Data[GE74.RUNTYPE.NO]);
        boolean bl = false;
        try {
            switch (this.ge74Data[GE74.RUNTYPE.NO]) {
                case "0": {
                    bl = true;
                    break;
                }
                case "1": {
                    bl = this.execDBin(path);
                    break;
                }
                case "2": {
                    bl = this.execPLSQL(path);
                    break;
                }
                case "3": {
                    bl = this.execBAT(path);
                    break;
                }
                case "4": {
                    bl = this.execJSP(path);
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            MsgUtil.errPrintln(throwable, "MSG0021", path);
        }
        return bl;
    }

    private boolean execDBin(Path path) {
        LOGGER.debug(() -> "execDBin() : Path=" + path);
        return true;
    }

    private boolean execPLSQL(Path path) {
        LOGGER.debug(() -> "execPLSQL() : Path=" + path);
        return false;
    }

    private boolean execBAT(Path path) {
        LOGGER.debug(() -> "execBAT() : Path=" + path);
        return false;
    }

    private boolean execJSP(Path path) {
        LOGGER.debug(() -> "execJSP() : Path=" + path);
        return false;
    }

    public static enum GE74 {
        RUNTYPE,
        RUNPG,
        PARAMS,
        TORIID,
        DBID,
        TABLE_NAME,
        SHT_NOS,
        READER_CLS,
        FILE_ENC,
        SKIP_CNT,
        NEXTID;

        private static final String FROM_WHERE = " from GE74 where SYSTEM_ID=? and EXECID=? and FGJ='1'";
        public static final String SELECT;
        public final int NO = this.ordinal();

        static {
            StringJoiner stringJoiner = new StringJoiner(",", "select ", FROM_WHERE);
            Arrays.stream(GE74.values()).forEachOrdered(gE74 -> stringJoiner.add(gE74.name()));
            SELECT = stringJoiner.toString();
        }
    }
}

