/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.penguin.math.statistics;

import java.util.Arrays;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;

public class HybsCorrelation {
    private String[] names;
    private double[][] pearsonsMatrix;
    private final RealMatrix corrMatrix;

    public HybsCorrelation(String[] stringArray, double[][] dArray) {
        this.names = stringArray;
        this.pearsonsMatrix = dArray;
        this.corrMatrix = new PearsonsCorrelation().computeCorrelationMatrix(this.pearsonsMatrix);
    }

    public HybsCorrelation(double[][] dArray) {
        this.corrMatrix = MatrixUtils.createRealMatrix((double[][])dArray);
    }

    public double[][] multiply(double[][] dArray) {
        RealMatrix realMatrix = MatrixUtils.createRealMatrix((double[][])dArray);
        RealMatrix realMatrix2 = realMatrix.multiply(this.corrMatrix);
        return realMatrix2.getData();
    }

    public double[][] getCorrMatrix() {
        return this.corrMatrix.getData();
    }

    public double[] getCorrMatrixRow(int n) {
        return this.corrMatrix.getRow(n);
    }

    public double[] getCorrMatrixCol(int n) {
        return this.corrMatrix.getColumn(n);
    }

    public String[] getNames() {
        return this.names;
    }

    public void setNames(String[] stringArray) {
        this.names = stringArray;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"A", "B", "C", "D", "E"};
        double[][] dArrayArray = new double[][]{{3.0, 1.0, 0.0, 0.0, 1.0}, {1.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 2.0, 2.0, 2.0}, {2.0, 2.0, 1.0, 0.0, 0.0}, {1.0, 0.0, 2.0, 4.0, 1.0}};
        HybsCorrelation hybsCorrelation = new HybsCorrelation(stringArray2, dArrayArray);
        for (int i = 0; i < hybsCorrelation.getCorrMatrix().length; ++i) {
            System.out.println(Arrays.toString(hybsCorrelation.getCorrMatrix()[i]));
        }
        System.out.println(Arrays.toString(hybsCorrelation.multiply(new double[][]{{0.0, 1.0, 0.0, 0.0, 0.0}})[0]));
    }
}

