/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.PathMatcherSet;
import org.opengion.fukurou.fileexec.XLogger;

public class DirWatch
implements Runnable {
    private static final XLogger LOGGER = XLogger.getLogger(DirWatch.class.getName());
    public static final long INIT_DELAY = 5L;
    public static final long PERIOD = 10L;
    public static final long TIME_DIFF = 30L;
    private final Path sPath;
    private final boolean useTree;
    private Consumer<Path> action = path -> System.out.println("DirWatch Path=" + path);
    private final PathMatcherSet pathMch = new PathMatcherSet();
    private DirectoryStream.Filter<Path> filter;
    private ScheduledFuture<?> stFuture;
    public static final String USAGE = "Usage: java jp.euromap.eu63.util.DirWatch dir [-SF sufix]... [-S] [-D delay(s)] [-P period(s)] [-T timeDiff(s)]";

    public DirWatch(Path path) {
        this(path, false);
    }

    public DirWatch(Path path2, boolean bl) {
        this.sPath = path2;
        this.useTree = bl;
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMch.addPathMatcher(pathMatcher);
    }

    public void setPathEndsWith(String ... stringArray) {
        this.pathMch.addEndsWith(stringArray);
    }

    public void callback(Consumer<Path> consumer) {
        if (consumer != null) {
            this.action = consumer;
        }
    }

    public void start() {
        this.start(5L, 30L, 10L);
    }

    public void start(long l, long l2, long l3) {
        LOGGER.info(() -> "DirWatch Start: " + this.sPath + " Tree=" + this.useTree + " Delay=" + l + " Period=" + l2 + " TimeDiff=" + l3);
        this.filter = path -> Files.isDirectory(path, new LinkOption[0]) || this.pathMch.matches((Path)path) && l3 * 1000L < System.currentTimeMillis() - path.toFile().lastModified();
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.stFuture = scheduledExecutorService.scheduleAtFixedRate(this, l, l2, TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.stFuture != null && !this.stFuture.isDone()) {
            LOGGER.info(() -> "DirWatch Stop: [" + this.sPath + "]");
            this.stFuture.cancel(true);
        }
    }

    @Override
    public void run() {
        try {
            LOGGER.debug(() -> "DirWatch Running: " + this.sPath + " Tree=" + this.useTree);
            this.execute(this.sPath);
        }
        catch (Throwable throwable) {
            MsgUtil.errPrintln(throwable, "MSG0021", this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute(Path path) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, this.filter);){
            Iterator<Path> iterator = directoryStream.iterator();
            while (iterator.hasNext()) {
                Path path2 = iterator.next();
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    if (!this.useTree) continue;
                    this.execute(path2);
                    continue;
                }
                Consumer<Path> consumer = this.action;
                synchronized (consumer) {
                    this.action.accept(path2);
                }
            }
            return;
        }
        catch (IOException iOException) {
            throw MsgUtil.throwException(iOException, "MSG0005", path);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println(USAGE);
            return;
        }
        long l = 5L;
        long l2 = 10L;
        long l3 = 30L;
        Path path = new File(".").toPath();
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("-help".equalsIgnoreCase(string)) {
                System.out.println(USAGE);
                return;
            }
            if ("-D".equalsIgnoreCase(string)) {
                l = Long.valueOf(stringArray[++i]);
                continue;
            }
            if ("-P".equalsIgnoreCase(string)) {
                l2 = Long.valueOf(stringArray[++i]);
                continue;
            }
            if ("-T".equalsIgnoreCase(string)) {
                l3 = Long.valueOf(stringArray[++i]);
                continue;
            }
            if ("-S".equalsIgnoreCase(string)) {
                bl = true;
                continue;
            }
            if ("-SF".equalsIgnoreCase(string)) {
                arrayList.add(stringArray[++i]);
                continue;
            }
            path = new File(string).toPath();
        }
        DirWatch dirWatch = new DirWatch(path, bl);
        if (!arrayList.isEmpty()) {
            dirWatch.setPathEndsWith(arrayList.toArray(new String[arrayList.size()]));
        }
        dirWatch.start(l, l2, l3);
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        dirWatch.stop();
        System.out.println("done.");
    }
}

