/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.ResultSetValue;
import org.opengion.fukurou.fileexec.XLogger;

public final class DBUtil {
    private static final XLogger LOGGER = XLogger.getLogger(DBUtil.class.getName());
    public static final String DATABASE_KEY = "DATABASE";
    public static final String URL_KEY = "REALM_URL";
    public static final String DRIVER_KEY = "REALM_DRIVER";
    public static final String NAME_KEY = "REALM_NAME";
    public static final String PASSWORD_KEY = "REALM_PASSWORD";
    private static final DataSource DATA_SOURCE = new DataSource();
    private static boolean readyFlag;
    private static boolean oracleFlag;
    private static final int BUFFER_MIDDLE = 200;

    private DBUtil() {
    }

    public static void init() {
        DBUtil.init(System.getProperty(URL_KEY, System.getenv(URL_KEY)), System.getProperty(DRIVER_KEY, System.getenv(DRIVER_KEY)), System.getProperty(NAME_KEY, System.getenv(NAME_KEY)), System.getProperty(PASSWORD_KEY, System.getenv(PASSWORD_KEY)));
    }

    public static void init(Map<String, String> map) {
        DBUtil.init(map.getOrDefault(URL_KEY, System.getProperty(URL_KEY, System.getenv(URL_KEY))), map.getOrDefault(DRIVER_KEY, System.getProperty(DRIVER_KEY, System.getenv(DRIVER_KEY))), map.getOrDefault(NAME_KEY, System.getProperty(NAME_KEY, System.getenv(NAME_KEY))), map.getOrDefault(PASSWORD_KEY, System.getProperty(PASSWORD_KEY, System.getenv(PASSWORD_KEY))));
    }

    public static void init(String ... stringArray) {
        if (readyFlag) {
            throw MsgUtil.throwException("MSG0024", DATA_SOURCE);
        }
        if (stringArray == null || stringArray.length != 4) {
            throw MsgUtil.throwException("MSG0027", Arrays.toString(stringArray));
        }
        PoolProperties poolProperties = new PoolProperties();
        poolProperties.setUrl(stringArray[0]);
        poolProperties.setDriverClassName(stringArray[1]);
        poolProperties.setUsername(stringArray[2]);
        poolProperties.setPassword(stringArray[3]);
        DATA_SOURCE.setPoolProperties((PoolConfiguration)poolProperties);
        readyFlag = true;
        oracleFlag = stringArray[0] != null && stringArray[0].startsWith("jdbc:oracle");
    }

    public static boolean isReady() {
        return readyFlag;
    }

    public static boolean isOracle() {
        return oracleFlag;
    }

    public static Connection getConnection() throws SQLException {
        if (!readyFlag) {
            DBUtil.init();
        }
        Connection connection = DATA_SOURCE.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    public static int execute(String string, String ... stringArray) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(stringArray);
        return DBUtil.execute(string, arrayList);
    }

    public static int execute(String string, List<String[]> list) {
        LOGGER.debug(() -> "execute query=" + string);
        String[] stringArray = null;
        int n = 0;
        try (Connection connection = DBUtil.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            ParameterMetaData parameterMetaData = oracleFlag ? null : preparedStatement.getParameterMetaData();
            Iterator<String[]> iterator = list.iterator();
            while (iterator.hasNext()) {
                String[] stringArray2;
                stringArray = stringArray2 = iterator.next();
                LOGGER.debug(() -> "execute values=" + Arrays.toString(stringArray2));
                DBUtil.setObject(preparedStatement, stringArray2, parameterMetaData);
                n += preparedStatement.executeUpdate();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            throw MsgUtil.throwException(sQLException, "MSG0019", sQLException.getMessage(), string, Arrays.toString(stringArray));
        }
        return n;
    }

    private static void setObject(PreparedStatement preparedStatement, String[] stringArray, ParameterMetaData parameterMetaData) throws SQLException {
        block5: {
            if (stringArray == null || stringArray.length <= 0) break block5;
            if (parameterMetaData == null) {
                int n = 1;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    preparedStatement.setObject(n++, string);
                }
            } else {
                int n = 1;
                for (int i = 0; i < stringArray.length; ++i) {
                    int n2 = parameterMetaData.getParameterType(n);
                    String string = stringArray[i];
                    if (string == null || string.isEmpty()) {
                        preparedStatement.setNull(n++, n2);
                        continue;
                    }
                    preparedStatement.setObject(n++, (Object)string, n2);
                }
            }
        }
    }

    public static int execute(String string, String string2, List<String[]> list, List<String[]> list2) {
        LOGGER.debug(() -> "execute insQuery=" + string + " , updQuery=" + string2);
        String[] stringArray = null;
        String string3 = null;
        int n = 0;
        try (Connection connection = DBUtil.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);
             PreparedStatement preparedStatement2 = connection.prepareStatement(string2);){
            ParameterMetaData parameterMetaData = oracleFlag ? null : preparedStatement.getParameterMetaData();
            ParameterMetaData parameterMetaData2 = oracleFlag ? null : preparedStatement2.getParameterMetaData();
            for (int i = 0; i < list2.size(); ++i) {
                String[] stringArray2;
                string3 = string2;
                stringArray = stringArray2 = list2.get(i);
                DBUtil.setObject(preparedStatement2, stringArray2, parameterMetaData2);
                int n2 = preparedStatement2.executeUpdate();
                if (n2 <= 0) {
                    string3 = string;
                    String[] stringArray3 = list.get(i);
                    stringArray = stringArray3;
                    DBUtil.setObject(preparedStatement, stringArray3, parameterMetaData);
                    LOGGER.debug(() -> "execute INSERT=" + Arrays.toString(stringArray3));
                    n2 = preparedStatement.executeUpdate();
                } else {
                    LOGGER.debug(() -> "execute UPDATE=" + Arrays.toString(stringArray2));
                }
                n += n2;
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            throw MsgUtil.throwException(sQLException, "MSG0019", sQLException.getMessage(), string3, Arrays.toString(stringArray));
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String[]> dbQuery(String string, String ... stringArray) {
        try (Connection connection = DBUtil.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(string);){
            ParameterMetaData parameterMetaData = oracleFlag ? null : preparedStatement.getParameterMetaData();
            DBUtil.setObject(preparedStatement, stringArray, parameterMetaData);
            if (preparedStatement.execute()) {
                try (ResultSet resultSet = preparedStatement.getResultSet();){
                    List<String[]> list = DBUtil.resultToArray(resultSet);
                    return list;
                }
            }
            connection.commit();
            return new ArrayList<String[]>();
        }
        catch (SQLException sQLException) {
            throw MsgUtil.throwException(sQLException, "MSG0019", sQLException.getMessage(), string, Arrays.toString(stringArray));
        }
    }

    public static List<String[]> resultToArray(ResultSet resultSet) throws SQLException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ResultSetValue resultSetValue = new ResultSetValue(resultSet);
        while (resultSetValue.next()) {
            arrayList.add(resultSetValue.getValues());
        }
        return arrayList;
    }

    public static String getInsertSQL(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        Object[] objectArray = new String[stringArray.length];
        Arrays.fill(objectArray, "?");
        boolean bl = stringArray2 != null && stringArray3 != null && stringArray2.length == stringArray3.length && stringArray2.length > 0;
        StringBuilder stringBuilder = new StringBuilder(200).append("INSERT INTO ").append(string).append(" ( ").append(String.join((CharSequence)",", stringArray));
        if (bl) {
            stringBuilder.append(',').append(String.join((CharSequence)",", stringArray2));
        }
        stringBuilder.append(" ) VALUES ( ").append(String.join((CharSequence)",", (CharSequence[])objectArray));
        if (bl) {
            stringBuilder.append(",'").append(String.join((CharSequence)"','", stringArray3)).append('\'');
        }
        return stringBuilder.append(" )").toString();
    }

    public static String getUpdateSQL(String string, String[] stringArray, String[] stringArray2, String[] stringArray3, String string2) {
        boolean bl = stringArray2 != null && stringArray3 != null && stringArray2.length == stringArray3.length && stringArray2.length > 0;
        StringBuilder stringBuilder = new StringBuilder(200).append("UPDATE ").append(string).append(" SET ").append(String.join((CharSequence)" = ? ,", stringArray)).append(" = ? ");
        if (bl) {
            for (int i = 0; i < stringArray2.length; ++i) {
                stringBuilder.append(',').append(stringArray2[i]).append(" = '").append(stringArray3[i]).append("' ");
            }
        }
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append(" WHERE ").append(string2);
        }
        return stringBuilder.toString();
    }

    public static String getDeleteSQL(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(200).append("DELETE FROM ").append(string);
        if (string2 != null && !string2.isEmpty()) {
            stringBuilder.append(" WHERE ").append(string2);
        }
        return stringBuilder.toString();
    }
}

