<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "REP03"
	title    = "レイアウトテーブル"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- 変更はここからです。 -->
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true">
	<og:value command="SET" key="C_CLM" value="COLUMN_NAME" />
</og:equals>
<og:equals val1="{@SYS.VER4_COMPATIBLE_MODE}" val2="true" notEquals="true">
	<og:value command="SET" key="C_CLM" value="CLM" />
</og:equals>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェックを行います。 -->
<!-- 入力内容がNULLの場合にエラーを返したい場合は、nullCheck属性を追加して下さい。-->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DBを検索するための SQL文を記述します。 debug="true" で画面からSQL文を確認できます。 -->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select
			LISTID,KBTEXT,{@C_CLM} CLM,SEQ,START_POS,USE_LENGTH,FGUSE,SYSTEM_ID,
			RDC_CODE,RELEASE_NOTES,FGJ,DYSET,DYUPD,USRSET,USRUPD,PGUPD
		from GE52

	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "SYSTEM_ID	= '{@SYSTEM_ID}'"	/>
		<og:and value = "LISTID		LIKE '{@LISTID}'"	/>
		<og:and value = "KBTEXT		= '{@KBTEXT}'"		/>
		<og:and value = "CLM		LIKE '{@CLM}'"		/>
		<og:and value = "FGJ		in ('0','1')"		/>
		<og:and value = "FGUSE		= '{@FGUSE}'"		/>
		<jsp:directive.include file="/jsp/custom/releaseNotesWhere.jsp" />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@ORDER_BY}" defaultVal="SYSTEM_ID,LISTID,KBTEXT,SEQ" />
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor column="SYSTEM_ID"    must="true" />
<og:columnEditor column="LISTID"       must="true" />
<og:columnEditor column="KBTEXT"       must="true" />
<og:columnEditor column="CLM"          must="true" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 追加、複写、変更、削除ボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="Z" />

	<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	checked      = "{@checked}"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
/>

</form>

<!-- 変更はここまでです。 -->

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
