/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.XLogger;

public class PathMatcherSet
implements PathMatcher {
    private static final XLogger LOGGER = XLogger.getLogger(PathMatcherSet.class.getName());
    private final Set<PathMatcher> pathMchSet = new CopyOnWriteArraySet<PathMatcher>();
    private int cnt = 0;
    public static final String USAGE = "Usage: java jp.euromap.eu63.util.PathMatcherSet [dir] [-start \uff65\uff65\uff65\uff65] [-end \uff65\uff65\uff65\uff65]";

    public boolean addAll(PathMatcherSet pathMatcherSet) {
        return pathMatcherSet != null && this.pathMchSet.addAll(pathMatcherSet.pathMchSet);
    }

    public boolean isEmpty() {
        return this.pathMchSet.isEmpty();
    }

    public void clear() {
        this.pathMchSet.clear();
    }

    public PathMatcherSet addPathMatcher(PathMatcher pathMatcher) {
        if (pathMatcher != null) {
            this.pathMchSet.add(pathMatcher);
        }
        return this;
    }

    public PathMatcherSet addStartsWith(String ... stringArray) {
        if (stringArray != null) {
            LOGGER.debug(() -> "addStartsWith : String[]=" + Arrays.toString(stringArray));
            this.pathMchSet.add(path -> {
                String string = path.getFileName().toString().toUpperCase(Locale.JAPAN);
                for (String string2 : stringArray) {
                    if (string2 != null && !string2.isEmpty() && !string.startsWith(string2.toUpperCase(Locale.JAPAN))) continue;
                    return true;
                }
                return false;
            });
        }
        return this;
    }

    public PathMatcherSet addEndsWith(String ... stringArray) {
        if (stringArray != null) {
            LOGGER.debug(() -> "addEndsWith : String[]=" + Arrays.toString(stringArray));
            this.pathMchSet.add(path -> {
                String string = path.getFileName().toString().toUpperCase(Locale.JAPAN);
                for (String string2 : stringArray) {
                    if (string2 != null && !string2.isEmpty() && !string.endsWith(string2.toUpperCase(Locale.JAPAN))) continue;
                    return true;
                }
                return false;
            });
        }
        return this;
    }

    public PathMatcherSet addFileName(String string) {
        if (string != null && !string.isEmpty()) {
            LOGGER.debug(() -> "addFileName : filename=" + string);
            int n = string.indexOf(42);
            if (n != string.lastIndexOf(42)) {
                MsgUtil.errPrintln("MSG2005", string);
                return this;
            }
            if (n < 0) {
                this.addStartsWith(string);
            } else if (n == 0) {
                this.addEndsWith(string.substring(1));
            } else if (n == string.length() - 1) {
                this.addStartsWith(string.substring(0, string.length() - 1));
            } else {
                String string2 = string.substring(0, n).toUpperCase(Locale.JAPAN);
                String string3 = string.substring(n + 1).toUpperCase(Locale.JAPAN);
                this.pathMchSet.add(path -> {
                    String string3 = path.getFileName().toString().toUpperCase(Locale.JAPAN);
                    return string3.startsWith(string2) && string3.endsWith(string3);
                });
            }
        }
        return this;
    }

    @Override
    public boolean matches(Path path) {
        return this.allMatch(path);
    }

    public boolean allMatch(Path path) {
        System.out.println(this.cnt++ + "\u3010" + this.pathMchSet.size() + "\u3011" + this);
        boolean bl = this.pathMchSet.isEmpty() || this.pathMchSet.stream().allMatch((? super T pathMatcher) -> pathMatcher.matches(path));
        LOGGER.debug(() -> "allMatch [" + bl + "] : Path=" + path);
        return bl;
    }

    public boolean anyMatch(Path path) {
        boolean bl = this.pathMchSet.isEmpty() || this.pathMchSet.stream().anyMatch((? super T pathMatcher) -> pathMatcher.matches(path));
        LOGGER.debug(() -> "anyMatch [" + bl + "] : Path=" + path);
        return bl;
    }

    public boolean noneMatch(Path path) {
        boolean bl = this.pathMchSet.isEmpty() || this.pathMchSet.stream().noneMatch((? super T pathMatcher) -> pathMatcher.matches(path));
        LOGGER.debug(() -> "noneMatch [" + bl + "] : Path=" + path);
        return bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println(USAGE);
            return;
        }
        Path path2 = new File(".").toPath();
        String string = null;
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if ("-help".equalsIgnoreCase(string3)) {
                System.out.println(USAGE);
                return;
            }
            if ("-start".equalsIgnoreCase(string3)) {
                string = stringArray[++i];
                continue;
            }
            if ("-end".equalsIgnoreCase(string3)) {
                string2 = stringArray[++i];
                continue;
            }
            path2 = new File(string3).toPath();
        }
        PathMatcherSet pathMatcherSet = new PathMatcherSet();
        pathMatcherSet.addStartsWith(string);
        pathMatcherSet.addEndsWith(string2);
        try {
            Files.walk(path2, new FileVisitOption[0]).filter(path -> pathMatcherSet.allMatch((Path)path)).forEach(path -> System.out.println(path));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

