/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

import org.opengion.fukurou.system.OgBuilder ;				// 6.4.4.1 (2016/03/18)

/**
 * TableFilter_INDEX_FIREBIRD は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。とくに、FireBird用のインデックス作成スクリプトを作成します。
 *
 * ここでは、テーブル一覧の検索結果より、GF07 のインデックスカラム定義テーブルから
 * 必要な情報を取得し、テーブル作成スクリプトを作成します。
 * 出力ファイルは、テーブル名＋"I.sql" という命名規則で作成します。
 * 検索では、(SYSTEM_ID,TBLSYU,TABLE_NAME,TABLE_LABEL,INDEX_NAME,NAME_JA,INDTYPE,TABLESPACE_NAME,INITIAL_EXTENT)
 * の項目を取得する必要があります。
 *
 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
 *
 * @version  0.9.0  2000/10/17
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.1,
 */
public class TableFilter_INDEX_FIREBIRD extends TableFilter_INDEX {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.4.4.1 (2016/03/18)" ;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public TableFilter_INDEX_FIREBIRD() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * インデックス作成の処理を実行します。
	 *
	 * @og.rev 5.6.9.2 (2013/10/18) プライマリキーの指定があった時の処理を追加
	 * @og.rev 6.4.4.1 (2016/03/18) StringBuilderの代わりに、OgBuilderを使用する。
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 * @param   clms	カラム名(CSV形式)
	 *
	 * @return	インデックス作成
	 * @og.rtnNotNull
	 */
	@Override
	protected String makeLineList( final int[] clmNo,final String[] data,final String clms ) {
		final String tableName = data[clmNo[TABLE_NAME]];
		final String indexName = data[clmNo[INDEX_NAME]];
		final String idxtype   = data[clmNo[INDTYPE]];

		return new OgBuilder()
				.appendCR()													// 先頭に、改行を入れておきます。
				.appendIfCR( isXml , EXEC_START_TAG )
				.appendCase( "0".equals( idxtype ) || "1".equals( idxtype )	// 0:プライマリキー、1:ユニークキー
							, "CREATE UNIQUE INDEX "						// true : 0:プライマリキー、1:ユニークキー
							, "CREATE INDEX " )								// false: 2:通常
				.append( indexName , " ON " , tableName , "( " , clms , " )" )
				.toString();

//		final String tableName = data[clmNo[TABLE_NAME]];
//		final String indexName = data[clmNo[INDEX_NAME]];
//		final String idxtype   = data[clmNo[INDTYPE]];
//
//		final StringBuilder buf = new StringBuilder( BUFFER_MIDDLE )
//			.append( CR );			// 先頭に、改行を入れておきます。
//		if( isXml ) { buf.append( EXEC_START_TAG ).append( CR ); }
//
//		// 5.6.9.2 (2013/10/18) プライマリキーの指定。今まで、else に飛んでいた。
//		if( "0".equals( idxtype ) || "1".equals( idxtype )  ) {	// 0:プライマリキー、1:ユニークキー
//			buf.append( "CREATE UNIQUE INDEX " ).append( indexName ).append( " ON " );
//			buf.append( tableName ).append( "( " ).append( clms );
//			buf.append( " )" );
//		}
//		// 5.6.9.2 (2013/10/18) INDTYPE で、その他ではなく、2:通常 で判断する。
//		else if( "2".equals( idxtype ) ) {	// 2:通常
//			buf.append( "CREATE INDEX " ).append( indexName ).append( " ON " );
//			buf.append( tableName ).append( "( " ).append( clms );
//			buf.append( " )" );
//		}
//		else {
//			final String errMsg = "INDTYPE が、0,1,2 以外の値が使われています。INDTYPE=[" + idxtype + "]"
//							+ " TABLE_NAME=[" + tableName + "] INDEX_NAME=[" + indexName + "]" ;
//			System.out.println( errMsg );
//		}
//
//		return buf.toString();
	}

	/**
	 * 定義の最後の部分の処理を実行します。
	 *
	 * @og.rev 6.0.2.3 (2014/10/10) EXEC_END_TAG を追加。キャッシュします。
	 *
	 * @param	clmNo	カラム番号配列
	 * @param	data	１行分のデータ配列
	 *
	 * @return	定義の最後の部分
	 */
	@Override
	protected String makeEndLine( final int[] clmNo,final String[] data ) {
		return execEndTag ;
	}
}
