<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
	
	<!-- ﾁｬｰﾄ情報の取得 -->
	<og:query command="NEW">
		SELECT ENAME LABELS
			,SAL VAL1
			,COMM VAL2
		FROM BONUS
		union all
		select 'TEST2', 13000.5 VA1, 0.1 VAL2 FROM DUAL
		order by 1
	</og:query>
	
	
	<!--  バーありのチャート用CSS -->
	<style>
		/* ﾁｬｰﾄ全体の設定 */
		div.chartContents{
			position:relative;
		}
		/* 垂直バー用テーブルの設定 */
		table.verticalBar{
			bottom:110px;
			left:-60px;
			position:absolute;
			transform:rotate(-90deg);	#-90度回転
			float:left;
		}
		/* 水平バーの設定 */
		div.horizonBar{
			position:absolute;
			bottom:0px;
			left:30px;
		}
		/* チャートの設定 */
		div.chart{
			margin-left:80px;
		}
		/* rangeバーの設定 */
		input.rangeBar{
			width:150px;
			padding:0px;
		}
		
	</style>

	<og:columnEditor column="VAL1" className="NUMBER" /> <!-- max,minを数値で出すため -->
	<og:value command="SETTBL" action="ALL_MAX_MIN" />
	
	<!-- バーありのチャートサンプル -->
	<div class="chartContents">
		<!-- 垂直バーテーブル -->
		<table class="verticalBar"><tr>
			<!-- heightバー -->
			<td>height：</td><td><og:input name="height" id="range2" clazz="rangeBar" type="range" min="200" max="800" td="false" value="400"/></td>
		</tr><tr>
			<!-- minバー -->
			<td>min：</td><td><og:input name="min" id="range3" clazz="rangeBar" type="range" min="0" max="{@MAX.VAL1}" td="false" value="0" step="0.1" /></td>
		</tr><tr>
			<!-- maxバー -->
			<td>max：</td><td><og:input name="max" id="range4" clazz="rangeBar" type="range" min="0" max="{@MAX.VAL1}" td="false" step="0.1" /></td>
		</tr></table>
		<!--  水平バー -->
		<div class="horizonBar">width：<og:input name="width" id="range1" clazz="rangeBar" type="range" min="200" max="1000"  td="false" value="400"/></div>
		<!--  チャート -->
		<div class="chart">
			<!-- 全ての属性を設定した形式 -->
			<og:jsChart
				chartType			= "{@chartType}"
				height				= "{@height}"
				width				= "{@width}"
				max					= ""
				min					= ""
				stepSize			= "{@stepSize}"
				timeUnit			= "{@timeUnit}"
				timeUnitStepSize	= "{@timeUnitStepSize}"
				timeSetFormat		= "{@timeSetFormat}"
				timeLblFormat		= "{@timeLblFormat}"
				timeMax				= "{@timeMax}"
				timeMin				= "{@timeMin}"
				labelColumn			= "LABELS"
				title				= "{@title}"
				titlePosition		= "{@titlePosition}"
				ylabel				= "yラベル"
				xlabel				= "xラベル"
				legendDisplay		= "{@legendDisplay}"
				legendPosition		= "{@legendPosition}"
				xscaleType			= "{@xscaleType}"
				xmax				= "{@xmax}"
				xmin				= "{@xmin}"
				xstepSize			= "{@xstepSize}"
				yscaleType			= "{@yscaleType}"
				ycategoryList		= "{@ycategoryList}"
				barWidthPer			= "{@barWidthPer}"
				optionAttributes	= ""
				debug				= "{@debug}"
				widthEventColumn	= "range1"
				heightEventColumn	= "range2"
				minEventColumn		= "range3"
				maxEventColumn		= "range4"
			>
			<og:jsChartData
					chartColumn			= "VAL1"
					label				= "給料"
					fill				= "{@fill}"
					tension				= "{@tension}"
					borderColor			= "{@borderColor}"
					borderWidth			= "{@borderWidth}"
					backgroundColor		= "{@backgroundColor}"
					optionAttributes	= ""
					 />
			</og:jsChart>
		</div>
	</div>
	<div style="color:red;">max,minを小数指定する場合は、og:input属性にstep="0.1"の形式で指定して下さい。</div>
</jsp:root>