/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.servlet;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint(value="/wsdemo")
public class WebSocketDemo {
    private static final Set<Session> sessSET = Collections.newSetFromMap(new ConcurrentHashMap());

    @OnOpen
    public void onOpen(Session session, EndpointConfig endpointConfig) {
        System.out.println(session.getId() + " was connected.");
        this.printSession(session);
        sessSET.add(session);
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        System.out.println(session.getId() + " was closed by " + closeReason.getCloseCode() + "[" + closeReason.getCloseCode().getCode() + "]");
        this.printSession(session);
        sessSET.remove(session);
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        System.out.println(session.getId() + " was error.");
        throwable.printStackTrace();
    }

    @OnMessage
    public void onMessage(String string, Session session) throws IOException {
        System.out.println(session.getId() + " was message." + string);
        WebSocketDemo.broadCast(string);
    }

    private static void broadCast(String string) {
        for (Session session2 : sessSET) {
            session2.getOpenSessions().forEach(session -> session.getAsyncRemote().sendText(string));
        }
    }

    @OnMessage
    public void onMessage(ByteBuffer byteBuffer, Session session) throws IOException {
        session.getBasicRemote().sendBinary(this.grayScall(byteBuffer));
    }

    private ByteBuffer grayScall(ByteBuffer byteBuffer) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byteBuffer.array()));
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
        bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage2, "png", byteArrayOutputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    private void printSession(Session session) {
        System.out.println(" ID    = " + session.getId());
        System.out.println(" URI   = " + session.getRequestURI());
        System.out.println(" RequestParameter : ");
        session.getRequestParameterMap().forEach((string, list) -> {
            System.out.println("  Key=" + string);
            System.out.println("  Val=" + Arrays.toString(list.toArray(new String[list.size()])));
        });
    }
}

