<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system   = "GE:エンジンサンプル"
	pgid     = "GE1004"
	title    = "DB検索"
	date     = "2007/12/12"
	author   = "K.HASEGAWA"
	text     = "ZZZZ"
	version  = "001"
/>

<!-- localResource を使用する。 -->
<og:equals val1="{@resource}" val2="localResource">
	<og:localResource systemId="{@OWNER}" />
</og:equals>

<jsp:directive.include file="changeSQL.jsp" />

<og:columnCheck
	nullCheck = "SQL"
/>

<og:equals val1="{@SQL}" val2="UPDATE" startsWith="true" useStop="true" >
	<og:message lbl="ERR0038" val0="SQL" val1="{@LBL.ENTRY}" comment="{0} は、{1} には使用できません。" />
</og:equals>

<og:transaction>
	<c:forTokens items="${SQL}" delims=";" var="SQL2" >
		<og:equals val1="{@SQL2}" useTrim="true" nullCheck="true" notEquals="true" >
			<og:query
				command		= "{@command}"
				queryType	= "JDBC{@queryType}"
				maxRowCount	= "{@maxRowCount}"
				dbid		= "{@DBID}"
				debug		= "{@debug}"
				quotCheck	= "false" >
			{@SQL2}
			</og:query>

			<og:equals val1="{@DB.IS_UPDATE}" val2="true" >
				<og:text>{@DB.COUNT} {@LBL.MSG0040}</og:text>
			</og:equals>
		</og:equals>
	</c:forTokens>
</og:transaction>

<!-- DB更新処理は、メッセージ表示後、終了する。 -->
<og:equals val1="{@DB.IS_UPDATE}" val2="true" useStop="true" >
	<og:text>{@DB.COUNT} {@LBL.MSG0040}</og:text>
</og:equals>

<!-- DB検索件数で、実行後に、エラーが発生しないように、判定する。 -->
<og:equals val1="{@DB.COUNT}" val2="0" notEquals="true" >
	<!-- DBLABEL にリソースを適用します。 -->
	<og:tableFilter classId="LABEL" keys="CLM,LBL" vals="COLUMN_NAME,DBLABEL" />
	<!-- OBJECT_NAME にリソースを適用します。 -->
	<og:tableFilter classId="LABEL" keys="CLM,LBL" vals="OBJECT_NAME,OBJ_NAME" />
</og:equals>

<!-- NAME_JA にリソースを適用します。 -->
<og:equals val1="{@resource},{@TBL_NM}" val2="noResource,1" notEquals="true" >
	<og:tableFilter classId="LABEL" caseNN="{@OWNER}"
		 keys="SYSTEM_ID,CLM,LBL" vals="{@OWNER},NAME_JA,NAME_JA" />
</og:equals>

<!-- localResourceでは、DBMENU は使用します。 -->
<og:columnEditor columns="*" renderer="DBMENU:LABEL" caseKey="{@resource}" caseVal="localResource" />

<!-- noResourceでは、ResourceManager を使用しない。つまり、DB検索結果そのものを表示する。 -->
<og:columnEditor column="*" noResource="true" caseKey="{@resource}" caseVal="noResource" />

<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	writable	= "false"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
