/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.view;

import java.util.Arrays;									// 5.9.27.0 (2017/12/01)

import org.opengion.fukurou.util.StringUtil;
// import org.opengion.hayabusa.common.HybsSystem;
// import org.opengion.hayabusa.common.HybsSystemException;
// import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.html.AbstractViewForm;
//import org.opengion.hayabusa.html.ViewCrossTableParam;
import org.opengion.hayabusa.html.ViewJsonParam;

/**
 * 検索結果を自動的に表形式に変換する、テーブル作成クラスです。
 *
 * ユーザー単位に表示するカラムの順番、表示可非を指定できるように対応します。
 * setColumnDisplay( final String columnName ) に、指定された順番に
 * 表示するというHTMLFormatTable の簡易版として用意します。
 * 各HTMLのタグに必要な setter/getterメソッドのみ，追加定義しています。
 *
 * AbstractViewForm を継承している為,ロケールに応じたラベルを出力させる事が出来ます。
 *
 * @og.group 画面表示
 * @og.rev 5.1.7.0 (2016/04/01) 新規作成
 *
 * @version  5.0
 * @author	 Takahashi Masakazu
 * @since    JDK5.0,
 */
public class ViewForm_JSON extends AbstractViewForm {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.8.3.1 (2017/12/01)" ;

	private int		clmCnt		= -1;

	private String	viewClms	;

	private String dataName;
	private boolean useHead;
	private boolean useInfo;
	private boolean useRenderer;
	private boolean useNullOmit;	// 6.7.7.0 (2017/03/31)
	private boolean useZeroOmit;	// 6.7.7.0 (2017/03/31)
	private boolean useEqValOmit;	// 6.8.3.0 (2017/11/27)
	private boolean useUtfEncode;	// '\u0000'形式への変換は仕様上必須ではないので現時点では実装しない

	private String rendererCols;	// 5.9.27.0 (2017/12/01)

	/** ヘッダー部分のキャッシュ変数 */
//	protected String	headerLine	 = null;
	protected String	headerLine;

	/**
	 * デフォルトコンストラクター
	 *
	 * @og.rev 6.4.9.1 (2016/08/05) Each class should declare at least one constructor
	 */
	public ViewForm_JSON() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * DBTableModel から HTML文字列を作成して返します。
	 * startNo(表示開始位置)から、pageSize(表示件数)までのView文字列を作成します。
	 * 表示残りデータが pageSize 以下の場合は,残りのデータをすべて出力します。
	 *
	 * @og.rev 5.5.4.2 (2012/07/13) editName指定時の編集対応
	 * @og.rev 6.8.3.0 (2017/11/27) 処理速度向上(カラムのキャッシュ)と、同一値のomit処理(useEqValOmit)。
	 * @og.rev 6.8.3.1 (2017/12/01) nullの場合、useNullOmit || useZeroOmit と、useEqValOmit の useRenderer 対応
	 * @og.rev 5.9.17.0 (2017/12/01) レンデラー利用カラム追加
	 *
	 * @param  startNo	  表示開始位置
	 * @param  pageSize   表示件数
	 *
	 * @return	DBTableModelから作成された HTML文字列
	 */
	@Override
	public String create( final int startNo, final int pageSize )  {
		//if( getRowCount() == 0 ) { return ""; }	// 暫定処置

		paramInit();

		// 5.9.27.0 (2017/12/01) レンデラー利用カラムの指定（JSONのみの特殊判定）
		boolean[] rendCols = new boolean[clmCnt];
	//	Arrays.fill( rendCols ,false );
		setBooleanArray( rendererCols,true,rendCols );

		headerLine	 = null;
		final int lastNo = getLastNo( startNo, pageSize );

		final StringBuilder out = new StringBuilder( BUFFER_LARGE );

		// 6.8.3.0 (2017/11/27) 処理速度向上(カラムのキャッシュ)
		final String[] clms    = new String[clmCnt];
		final String[] oldDiff = new String[clmCnt];		// 6.8.3.1 (2017/12/01) 一つ前と比較するための変数
		final String[] oldVals = new String[clmCnt];		// useRenderer が加味された値
		for(int clm = 0; clm < clmCnt; clm++) {
			clms[clm] = "\"" + getColumnName( clm ) + "\":\"" ;
		}

		//JSON開始
//		out.append("{").append( CR );
		out.append( '{' ).append( CR );

		int rowcnt = 0;
		out.append( '"' ).append( dataName ).append( "\":[" );
		for( int row=startNo; row<lastNo; row++ ) {
			if( isSkip( row ) || isSkipNoEdit( row ) ) { continue; } 
//			if(rowcnt > 0 ){ out.append(","); }
			if(rowcnt > 0 ){ out.append( ',' ); }
			rowcnt++;
//			out.append( "{" );
			out.append( '{' );

			int clmcount = 0;
			for(int clm = 0; clm < clmCnt; clm++) {
//				if( ( val == null || val.isEmpty() ) && ( useNullOmit && useZeroOmit ) ) { continue; }
//				if( ( "0".equals( val ) || "0.0".equals( val ) || "0.00".equals( val ) ) && useZeroOmit ) { continue; }

				if( isColumnDisplay( clm ) ) {						// 6.8.3.0 (2017/11/27) continue 処理を囲う形で前に持ってきます。
					// 6.7.7.0 (2017/03/31)
					final String val = getValue( row,clm );

					if( ( val == null || val.isEmpty() ) && ( useNullOmit || useZeroOmit ) ||
						( "0".equals( val ) || "0.0".equals( val ) || "0.00".equals( val ) ) && useZeroOmit ||
						val.equals( oldDiff[clm] ) && useEqValOmit ) { continue; } 		// 6.8.3.0 (2017/11/27) 同一値のomit処理(useEqValOmit) 追加

					oldDiff[clm] = val;													// 6.8.3.0 (2017/11/27) 同一値のomit処理(useEqValOmit) 追加
					oldVals[clm] = StringUtil.jsonFilter( 								// 6.8.3.1 (2017/12/01)
//										useRenderer ? getValueLabel(row,clm) : val
										useRenderer || rendCols[clm] ? getValueLabel(row,clm) : val		// 5.9.27.0 (2017/12/01)
									);

//					if( clmcount > 0 ){ out.append( "," );}
					if( clmcount > 0 ){ out.append( ',' );}
					clmcount++;

					out.append( clms[clm] )												// 6.8.3.1 (2017/12/01)
						.append( oldVals[clm] )
						.append( '"' );

////					out.append( '"' ).append( getColumnName( clm ) ).append( "\":\"" );
//					out.append( clms[clm] );													// 6.8.3.0 (2017/11/27) 処理速度向上(カラムのキャッシュ)
//					if( useRenderer ){
//						out.append( StringUtil.jsonFilter( getValueLabel(row,clm) ) );
//					}
//					else{
////						out.append( StringUtil.jsonFilter( getValue(row,clm) ) );
//						out.append( StringUtil.jsonFilter( val ) );								// 6.8.3.0 (2017/11/27) 処理速度向上(カラムのキャッシュ)
//					}
////					out.append( "\"" );
//					out.append( '"' );
				}
			}
//			out.append( "}" );
			out.append( '}' );
		}

		// 6.8.3.0 (2017/11/27) 同一値のomit処理(useEqValOmit) 追加の後処理
		if( useEqValOmit ) {
			out.append( ',' )
				.append( '{' );
			int clmcount = 0;
			for(int clm = 0; clm < clmCnt; clm++) {
				if( isColumnDisplay( clm ) ) {
					if( clmcount > 0 ){ out.append( ',' );}
					clmcount++;
					out.append( clms[clm] )
//						.append( StringUtil.jsonFilter( oldVals[clm] ) )
						.append( oldVals[clm] )
						.append( '"' );
				}
			}
			out.append( '}' );
		}

//		out.append("]").append( CR );
		out.append( ']' ).append( CR );

		if( useHead ){
//			out.append(",").append( getHeader() ).append( CR );
			out.append( ',' ).append( getHeader() ).append( CR );
		}
		if( useInfo ){
//			out.append(",").append( getInfo(rowcnt) ).append( CR );
			out.append( ',' ).append( getInfo(rowcnt) ).append( CR );
		}

		//JSON終わり
//		out.append("}").append( CR );
		out.append( '}' ).append( CR );

		return out.toString();
	}

	/**
	 * パラメータ内容を初期化します。
	 *
	 * @og.rev 6.7.7.0 (2017/03/31) ViewJsonParam属性を、文字列から、boolean に変更
	 * @og.rev 6.8.3.0 (2017/11/27) useEqValOmit属性の追加
	 * @og.rev 5.9.17.0 (2017/12/01) レンデラー利用カラム追加
	 *
	 */
	private void paramInit() {
//		useHead		= StringUtil.nval( getParam( ViewJsonParam.JSON_HEAD_KEY		,	ViewJsonParam.USE_JSON_HEAD		), true);
//		useInfo		= StringUtil.nval( getParam( ViewJsonParam.JSON_INFO_KEY		,	ViewJsonParam.USE_JSON_INFO		), true);
//		useRenderer	= StringUtil.nval( getParam( ViewJsonParam.JSON_RENDERER_KEY	,	ViewJsonParam.USE_JSON_RENDERER ), false);
//		useUtfEncode= StringUtil.nval( getParam( ViewJsonParam.JSON_UTF_ENCODE		,	ViewJsonParam.USE_JSON_UTFENC	), false);
//		useHead		= StringUtil.nval( getParam( ViewJsonParam.JSON_HEAD_KEY		,	ViewJsonParam.USE_JSON_HEAD		), true);

		dataName	= getParam( ViewJsonParam.JSON_DATANAME_KEY	, ViewJsonParam.JSON_DATANAME		);
		useHead		= StringUtil.nval( getParam( ViewJsonParam.JSON_HEAD_KEY			) , ViewJsonParam.USE_JSON_HEAD		);
		useInfo		= StringUtil.nval( getParam( ViewJsonParam.JSON_INFO_KEY			) , ViewJsonParam.USE_JSON_INFO		);
		useRenderer	= StringUtil.nval( getParam( ViewJsonParam.JSON_RENDERER_KEY		) , ViewJsonParam.USE_JSON_RENDERER	);
		useNullOmit	= StringUtil.nval( getParam( ViewJsonParam.JSON_NULLOMIT_KEY		) , ViewJsonParam.USE_JSON_NULLOMIT	);	// 6.7.7.0 (2017/03/31)
		useZeroOmit	= StringUtil.nval( getParam( ViewJsonParam.JSON_ZEROOMIT_KEY		) , ViewJsonParam.USE_JSON_ZEROOMIT	);	// 6.7.7.0 (2017/03/31)
		useEqValOmit= StringUtil.nval( getParam( ViewJsonParam.JSON_EQVALOMIT_KEY		) , ViewJsonParam.USE_JSON_EQVALOMIT);	// 6.8.3.0 (2017/11/27)
		useUtfEncode= StringUtil.nval( getParam( ViewJsonParam.JSON_UTF_ENCODE			) , ViewJsonParam.USE_JSON_UTFENC	);

		rendererCols= getParam( ViewJsonParam.JSON_RENDERER_COLS_KEY , ViewJsonParam.JSON_RENDERER_COLS );						// 5.9.17.0 (2017/12/01)

		clmCnt = getColumnCount();
	}

	/**
	 * DBTableModel から テーブルのヘッダータグ文字列を作成して返します。
	 *
	 *
	 * @return	テーブルのヘッダータグ文字列
	 */
	protected String getHeader() {
		return "\"HEAD\":{" + getTableHead() + "}";
	}

	/**
	 * DBTableModel から テーブルのタグ文字列を作成して返します。
	 *
	 *
	 * @return	テーブルのタグ文字列
	 */
	protected String getTableHead() {
//		StringBuilder buf = new StringBuilder( BUFFER_MIDDLE );
//		buf.append( getHeadLine() );
//		return buf.toString();

		return getHeadLine();
	}

	/**
	 * ヘッダー繰り返し部を、getTableHead()メソッドから分離。
	 *
	 *
	 * @return	テーブルのタグ文字列
	 */
	protected String getHeadLine() {
		if( headerLine != null ) { return headerLine; }		// キャッシュを返す。

		final StringBuilder buf = new StringBuilder( BUFFER_MIDDLE );

		for(int clm = 0; clm < clmCnt; clm++) {
			if( isColumnDisplay( clm ) ) {
				if( buf.length() > 0 ){ buf.append( ',' ); }
				buf.append( '"' )
					.append( getColumnName( clm ) )
					.append( "\":\"" )
					.append( StringUtil.jsonFilter( getColumnLabel( clm ) ) )
					.append(  '"' );
//				if( buf.length() > 0 ){ buf.append(","); }
//				buf.append( "\"" + getColumnName( clm ) + "\"" );
//				buf.append(":");
//				buf.append( "\"" + StringUtil.jsonFilter( getColumnLabel( clm ) ) + "\"" );
			}
		}

		headerLine = buf.toString();
		return headerLine;
	}

	/**
	 * DBTableModel から テーブルのヘッダータグ文字列を作成して返します。
	 *
	 * @param	rowcount 行番号
	 *
	 * @return	テーブルのヘッダータグ文字列
	 */
	protected String getInfo( final int rowcount ) {
		return new StringBuilder( BUFFER_MIDDLE )
						.append( "\"INFO\":{\"COUNT\":\"" )
						.append( rowcount )
						.append( "\"}")
						.toString();

//		StringBuilder buf = new StringBuilder( BUFFER_MIDDLE );
//
//		buf.append( "\"INFO\":{" )
//		.append( "\"COUNT\":").append( "\"" + rowcount + "\"" )
//		.append( "}");
//		return buf.toString();
	}

	/**
	 * ビューで表示したカラムの一覧をカンマ区切りで返します。
	 *
	 * @og.rev 5.1.6.0 (2010/05/01) 新規追加
	 * @og.rev 5.8.6.0 (2015/04/03) オリジナルカラム対応
	 *
	 * @return	ビューで表示したカラムの一覧
	 */
	@Override
	public String getViewClms() {
		if( viewClms == null ) { return super.getViewClms(); }
		return viewClms;
	}

	/**
	 * フォーマットメソッドを使用できるかどうかを問い合わせます。
	 *
	 * @return  使用可能(true)/ 使用不可能(false)
	 */
	public boolean canUseFormat() {
		return false;
	}
}
