/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.business;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.model.DataModel;
import org.opengion.fukurou.model.NativeType;
import org.opengion.fukurou.system.HybsConst;

public class ArrayTableModel
implements DataModel<String> {
    private final String[] names;
    private final String[][] vals;
    private final String[] modTypes;
    private final ConcurrentMap<Integer, String[]> rtnMap = new ConcurrentHashMap<Integer, String[]>();

    public ArrayTableModel(String[] stringArray, String[][] stringArray2) {
        this(stringArray, stringArray2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArrayTableModel(String[] stringArray, String[][] stringArray2, String[] stringArray3) {
        if (stringArray == null) throw new IllegalArgumentException("\u5f15\u6570\u306e\u540d\u524d\u914d\u5217\u306b\u3001null \u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306e\u540d\u524d\u914d\u5217\u306b\u3001null \u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (stringArray2 == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306e\u5024\u914d\u5217\u306b\u3001null \u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        if (stringArray2.length > 0 && (stringArray2[0] == null || stringArray2[0].length == 0 || stringArray.length != stringArray2[0].length)) {
            String string = "\u540d\u524d\u914d\u5217\u3068\u5024\u914d\u5217\u306e\u30ab\u30e9\u30e0\u6570\u304c\u7570\u306a\u308a\u307e\u3059\u3002" + HybsConst.CR + "   nms   =" + Arrays.toString(stringArray) + HybsConst.CR + "   vs[0] =" + Arrays.toString(stringArray2[0]);
            throw new IllegalArgumentException(string);
        }
        int n = stringArray.length;
        this.names = new String[n];
        System.arraycopy(stringArray, 0, this.names, 0, n);
        int n2 = stringArray2.length;
        this.vals = new String[n2][n];
        for (int i = 0; i < n2; ++i) {
            System.arraycopy(stringArray2[i], 0, this.vals[i], 0, n);
        }
        if (stringArray3 != null && stringArray3.length > 0) {
            if (stringArray2.length == stringArray3.length) {
                this.modTypes = new String[n2];
                System.arraycopy(stringArray3, 0, this.modTypes, 0, n2);
                return;
            }
            String string = "\u5909\u66f4\u533a\u5206\u3092\u6307\u5b9a\u3059\u308b\u5834\u5408\u3001\u5024\u914d\u5217\u306e\u884c\u6570\u3068\u4e00\u81f4\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" + HybsConst.CR + "   \u5909\u66f4\u533a\u5206 \u884c\u6570 =" + stringArray3.length + HybsConst.CR + "   \u5024\u914d\u5217   \u884c\u6570 =" + stringArray2.length;
            throw new IllegalArgumentException(string);
        }
        this.modTypes = null;
    }

    public void setValues(String[] stringArray, int n) {
        if (n < 0 || n > this.getRowCount()) {
            String string = "\u5f15\u6570\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306f\u30010\uff5e" + (this.getRowCount() - 1) + " \u306e\u9593\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002index=[" + n + "]";
            throw new IllegalArgumentException(string);
        }
        if (stringArray == null || stringArray.length == 0) {
            String string = "\u5f15\u6570\u306e\u5024\u914d\u5217\u306b\u3001null\u3001\u307e\u305f\u306f 0\u4ef6\u914d\u5217\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002index=[" + n + "]";
            throw new IllegalArgumentException(string);
        }
        if (stringArray.length != this.names.length) {
            String string = "\u5f15\u6570\u306e\u5024\u914d\u5217\u306e\u500b\u6570\u3068\u3001\u5185\u90e8\u30ab\u30e9\u30e0\u6570\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002 index=[" + n + "] : \u5f15\u6570\u500b\u6570=[" + stringArray.length + "] != \u5185\u90e8\u30ab\u30e9\u30e0\u6570=[" + this.names.length + "]";
            throw new IllegalArgumentException(string);
        }
        int n2 = this.names.length;
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        this.rtnMap.put(n, stringArray2);
    }

    public ConcurrentMap<Integer, String[]> getModifyVals() {
        return this.rtnMap;
    }

    @Override
    public int getColumnNo(String string) {
        if (string == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306e\u30ab\u30e9\u30e0\u540d\u306b\u3001null \u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        int n = -1;
        for (int i = 0; i < this.names.length; ++i) {
            if (!string.equalsIgnoreCase(this.names[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    public int[] getColumnNos(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return new int[0];
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = -1;
            for (int j = 0; j < this.names.length; ++j) {
                if (!stringArray[i].equalsIgnoreCase(this.names[j])) continue;
                n = j;
                break;
            }
            nArray[i] = n;
        }
        return nArray;
    }

    @Override
    public String[] getNames() {
        return (String[])this.names.clone();
    }

    protected String[][] getValues(String ... stringArray) {
        int[] nArray = this.getColumnNos(stringArray);
        String[][] stringArray2 = new String[this.vals.length][nArray.length];
        for (int i = 0; i < this.vals.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                int n = nArray[j];
                stringArray2[i][n] = this.vals[i][n];
            }
        }
        return stringArray2;
    }

    public String[] getValues(int n) {
        return (String[])this.vals[n].clone();
    }

    @Override
    public String getValue(int n, int n2) {
        return this.vals[n][n2];
    }

    public String getValue(int n, String string) {
        return this.vals[n][this.getColumnNo(string)];
    }

    @Override
    public int getRowCount() {
        return this.vals.length;
    }

    @Override
    public String getModifyType(int n) {
        return this.modTypes == null ? "" : this.modTypes[n];
    }

    @Override
    public void setModifyType(int n, String string) {
        if (this.modTypes[n].isEmpty()) {
            this.modTypes[n] = string;
        }
    }

    @Override
    public NativeType getNativeType(int n) {
        return NativeType.getType(this.vals[0][n]);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("NAMES=").append(Arrays.toString(this.names)).append(HybsConst.CR).append(" COL_LEN=").append(this.names == null ? -1 : this.names.length).append(HybsConst.CR).append(" ROW_LEN=").append(this.vals == null ? -1 : this.vals.length).append(HybsConst.CR);
        return stringBuilder.toString();
    }
}

