
package org.opengion.penguin.math.statistics;

/**
 * 与える配列が{x,y}の組み合わせの、単回帰系回帰処理用のインターフェースです。
 */
public interface HybsRegression {

	/**
	 * 回帰式の係数を配列で返します。
	 * 
	 * @return 係数配列
	 * 
	 */
	double[] getCoefficient();

	/**
	 * 決定係数の取得。
	 *
	 * @return 決定係数
	 */
	double getRSquare();

	/**
	 * 回帰式f(x)を計算して返す。
	 * 
	 * @param in_x 必要な大きさの変数配列
	 * @return 計算結果
	 */
	double predict( double... in_x ) ;

}
