/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.fukurou.mail.MailTX;
import org.opengion.fukurou.system.LogWriter;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.EnumType;
import org.opengion.fukurou.util.ErrorMessage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.common.UserSummary;
import org.opengion.hayabusa.resource.GUIInfo;
import org.opengion.hayabusa.resource.UserInfo;
import org.opengion.hayabusa.taglib.CommonTagSupport;
import org.opengion.hayabusa.taglib.TaglibUtil;

public class ErrorTag
extends CommonTagSupport {
    private static final String VERSION = "6.8.5.0 (2018/01/09)";
    private static final long serialVersionUID = 685020180109L;
    private static final EnumType<String> LOG_MSGTYPE = new EnumType("\u30ed\u30b0\u30e1\u30c3\u30bb\u30fc\u30b8\u30bf\u30a4\u30d7", (Comparable)((Object)"MEDIUM")).append((Comparable)((Object)"LONG"), "\u8a73\u7d30\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002").append((Comparable)((Object)"MEDIUM"), "\u6a19\u6e96\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002").append((Comparable)((Object)"SHORT"), "\u7c21\u6613\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002").append((Comparable)((Object)"NONE"), "\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u305b\u3093\u3002");
    private static final EnumType<String> VIEW_MSGTYPE = new EnumType("\u8868\u793a\u30e1\u30c3\u30bb\u30fc\u30b8\u30bf\u30a4\u30d7", (Comparable)((Object)"SHORT")).append((Comparable)((Object)"LONG"), "\u8a73\u7d30\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002").append((Comparable)((Object)"MEDIUM"), "\u6a19\u6e96\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002").append((Comparable)((Object)"SHORT"), "\u7c21\u6613\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u3059\u3002").append((Comparable)((Object)"NONE"), "\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u4f5c\u6210\u3057\u307e\u305b\u3093\u3002").append((Comparable)((Object)"ALLNONE"), "\u4f55\u3082\u51fa\u529b\u3057\u307e\u305b\u3093\u3002").append((Comparable)((Object)"TABLE"), "\u30c6\u30fc\u30d6\u30eb\u5f62\u5f0f\u3067\u30a8\u30e9\u30fc\u30e1\u30c3\u30bb\u30fc\u30b8\u306e\u307f\u3092\u8868\u793a\u3057\u307e\u3059\u3002").append((Comparable)((Object)"TABLE_ST"), "\u30c6\u30fc\u30d6\u30eb\u5f62\u5f0f\uff0b\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9\u60c5\u5831\u3002");
    private final String MAIL_SERVER = StringUtil.nval((String)HybsSystem.sys("COMMON_MAIL_SERVER"), null);
    private final String MAIL_USERS = StringUtil.nval((String)HybsSystem.sys("ERROR_MAIL_TO_USERS"), null);
    private final String FROM_USER = StringUtil.nval((String)HybsSystem.sys("ERROR_MAIL_FROM_USER"), (String)"ENGINE@DUMMY");
    private final String TITLE = "\u3010" + HybsSystem.sys("SYSTEM_ID") + "\u3011" + HybsSystem.sys("GUI_TOP_TITLE") + "Error!";
    private boolean useMail = true;
    private String logMsgType = (String)((Object)LOG_MSGTYPE.getDefault());
    private String viewMsgType = (String)((Object)VIEW_MSGTYPE.getDefault());
    private boolean skipPage;
    private String messageBody;

    @Override
    public int doStartTag() {
        return 2;
    }

    @Override
    public int doAfterBody() {
        this.messageBody = this.getBodyString();
        return 0;
    }

    @Override
    public int doEndTag() {
        Object object;
        String string;
        Comparable<UserSummary> comparable;
        this.debugPrint();
        StringBuilder stringBuilder = new StringBuilder(200).append(CR).append("Title :").append(this.TITLE).append(CR).append("Version :").append("openGion 6.8.5.0 Release6 Builds (2018009)").append(CR);
        String string2 = null;
        try {
            comparable = (UserInfo)this.getSessionAttribute("h_uInfo");
            if (comparable != null) {
                string2 = ((UserInfo)comparable).getUserID();
                stringBuilder.append("ID=[").append(string2).append("] LOGIN=[").append(HybsSystem.getDate(((UserInfo)comparable).getLoginTime())).append(']');
            }
        }
        catch (HybsSystemException hybsSystemException) {
            stringBuilder.append("User is null");
        }
        stringBuilder.append(CR).append("GUI Information  : ");
        comparable = (GUIInfo)this.getSessionAttribute("h_gInfo");
        if (comparable == null) {
            string = null;
            stringBuilder.append("GUI is null");
        } else {
            ((GUIInfo)comparable).addErrorCount();
            string = ((GUIInfo)comparable).getKey();
            stringBuilder.append("KEY=[").append(string).append("] LABEL=[").append(((GUIInfo)comparable).getLabel()).append(']');
        }
        stringBuilder.append(CR);
        Exception exception = this.pageContext.getException();
        if (exception != null) {
            stringBuilder.append(exception.getMessage()).append(CR);
        }
        stringBuilder.append("-----").append(CR);
        String string3 = stringBuilder.toString();
        String string4 = this.getStackTrace(exception, this.logMsgType);
        String string5 = new StringBuilder(200).append("[User=").append(string2).append(" , Gui=").append(string).append(" , Msg=").append(this.messageBody).append(']').append(CR).append(string3).append(CR).append(string4).append(CR).toString();
        LogWriter.log((String)string5);
        if (this.useMail && this.MAIL_SERVER != null && this.MAIL_USERS != null) {
            object = StringUtil.csv2Array((String)this.MAIL_USERS);
            MailTX mailTX = new MailTX(this.MAIL_SERVER);
            mailTX.setFrom(this.FROM_USER);
            mailTX.setTo(object);
            mailTX.setSubject(this.TITLE);
            mailTX.setMessage(string5);
            mailTX.sendmail();
        }
        if (!"ALLNONE".equals(this.viewMsgType)) {
            object = this.logMsgType.equals(this.viewMsgType) ? string5 : ("TABLE".equals(this.viewMsgType) ? this.getTableMsg(this.pageContext.getException(), false) : ("TABLE_ST".equals(this.viewMsgType) ? string3 + this.getTableMsg(this.pageContext.getException(), true) : string3 + this.getStackTrace(this.pageContext.getException(), this.viewMsgType)));
            this.jspPrint((String)object);
        }
        return this.skipPage ? 5 : 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.useMail = true;
        this.logMsgType = (String)((Object)LOG_MSGTYPE.getDefault());
        this.viewMsgType = (String)((Object)VIEW_MSGTYPE.getDefault());
        this.skipPage = false;
        this.messageBody = null;
    }

    private String getStackTrace(Throwable throwable, String string) {
        if ("NONE".equals(string) || "ALLNONE".equals(string)) {
            return "";
        }
        if ("SHORT".equals(string)) {
            return ThrowUtil.ogThrowMsg(null, (Throwable)throwable);
        }
        return ThrowUtil.ogStackTrace((Throwable)throwable);
    }

    private String getTableMsg(Throwable throwable, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(200);
        ErrorMessage errorMessage = new ErrorMessage("System Error!");
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            String string = StringUtil.nval((String)throwable2.getMessage(), (String)"System Error(null)");
            if (string == null || stringBuilder.indexOf(string) >= 0) continue;
            stringBuilder.append(string);
            errorMessage.addMessage(0, 2, "SYSERR", new String[]{string});
            if (!bl) continue;
            errorMessage.addMessage(0, 2, "SYSERR", new String[]{ThrowUtil.ogStackTrace((Throwable)throwable)});
            Throwable throwable3 = this.getCommonTagThrowable();
            if (throwable3 == null) continue;
            errorMessage.addMessage(0, 2, "SYSERR", new String[]{ThrowUtil.ogStackTrace((Throwable)throwable3)});
        }
        return TaglibUtil.makeHTMLErrorTable(errorMessage, this.getResource());
    }

    public void setUseMail(String string) {
        this.useMail = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useMail);
    }

    public void setLogMsgType(String string) {
        this.logMsgType = (String)((Object)LOG_MSGTYPE.nval(string));
    }

    public void setViewMsgType(String string) {
        this.viewMsgType = (String)((Object)VIEW_MSGTYPE.nval(string));
    }

    public void setSkipPage(String string) {
        this.skipPage = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.skipPage);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("useMail", (Object)this.useMail).println("logMsgType", (Object)this.logMsgType).println("viewMsgType", (Object)this.viewMsgType).println("messageBody", (Object)this.messageBody).println("skipPage", (Object)this.skipPage).println("COMMON_MAIL_SERVER", (Object)this.MAIL_SERVER).println("ERROR_MAIL_TO_USERS", (Object)this.MAIL_USERS).println("MAIL_DAEMON_DEFAULT_USER", (Object)this.FROM_USER).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

