/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.fukurou.util.XHTMLTag;

/**
 * 【廃止】RADIO2 エディターは、カラムのデータをラジオボタンで編集する場合に使用するクラスです。
 *
 * このエディターは、RADIOとは異なり、コードリソースでの制御など、ラジオボタン特有の制御を全く行いません。
 * 特性としては、typeがradioであるという1点を除いて、TEXT エディターと同じです
 *
 * カラムの表示に必要な属性は, DBColumn オブジェクト より取り出します。
 * このクラスは、DBColumn オブジェクト毎に１つ作成されます。
 *
 * 6.4.4.0 (2016/03/11) 廃止します。
 *
 * @og.group データ編集
 *
 * @version  4.0
 * @author   Hiroki Nakamura
 * @since    JDK5.0,
 */
public class Editor_RADIO2 extends AbstractEditor {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "6.4.4.0 (2016/03/11)" ;

	/**
	 * 【廃止】デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 * @og.rev 6.4.1.1 (2016/01/16) PMD refactoring. It is a good practice to call super() in a constructor
	 */
	public Editor_RADIO2() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * 【廃止】コンストラクター。
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	private Editor_RADIO2( final DBColumn clm ) {
		super( clm );

		attributes.set( "type", "radio" );
		tagBuffer.add( XHTMLTag.inputAttri( attributes ) );
	}

	/**
	 * 【廃止】各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @og.rev 6.4.4.0 (2016/03/11) 廃止します。
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 * @og.rtnNotNull
	 */
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_RADIO2( clm );
	}

	/**
	 * 【廃止】データの編集用文字列を返します。
	 *
	 * @og.rev 6.4.4.0 (2016/03/11) 廃止します。
	 *
	 * @param	value 値
	 *
	 * @return	データの編集用文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final String value ) {
		return new StringBuilder( BUFFER_MIDDLE )
					.append( "<label>" )
					.append( super.getValue( value ) )
					.append( value )
					.append( "</label>" )
					.toString();
	}

	/**
	 * 【廃止】name属性を変えた、データ表示/編集用のHTML文字列を作成します。
	 * テーブル上の name に 行番号を付加して、名前_行番号 で登録するキーを作成し,
	 * リクエスト情報を１つ毎のフィールドで処理できます。
	 *
	 * @og.rev 6.4.4.0 (2016/03/11) 廃止します。
	 *
	 * @param	row   行番号
	 * @param	value 値
	 *
	 * @return	データ表示/編集用の文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final int row,final String value ) {
		return new StringBuilder( BUFFER_MIDDLE )
					.append( "<label>" )
					.append( super.getValue( row,value ) )
					.append( value )
					.append( "</label>" )
					.toString();
	}
}
