/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xslf.usermodel.XSLFPictureData;

public class XSLFImageRenderer {
    public boolean drawImage(Graphics2D graphics, XSLFPictureData data, Rectangle2D anchor) {
        return this.drawImage(graphics, data, anchor, null);
    }

    public boolean drawImage(Graphics2D graphics, XSLFPictureData data, Rectangle2D anchor, Insets clip) {
        BufferedImage img;
        boolean isClipped = true;
        if (clip == null) {
            isClipped = false;
            clip = new Insets(0, 0, 0, 0);
        }
        try {
            img = ImageIO.read(data.getPackagePart().getInputStream());
        }
        catch (Exception e) {
            return false;
        }
        if (img == null) {
            return false;
        }
        int iw = img.getWidth();
        int ih = img.getHeight();
        double cw = (double)(100000 - clip.left - clip.right) / 100000.0;
        double ch = (double)(100000 - clip.top - clip.bottom) / 100000.0;
        double sx = anchor.getWidth() / ((double)iw * cw);
        double sy = anchor.getHeight() / ((double)ih * ch);
        double tx = anchor.getX() - (double)iw * sx * (double)clip.left / 100000.0;
        double ty = anchor.getY() - (double)ih * sy * (double)clip.top / 100000.0;
        AffineTransform at = new AffineTransform(sx, 0.0, 0.0, sy, tx, ty);
        Shape clipOld = graphics.getClip();
        if (isClipped) {
            graphics.clip(anchor.getBounds2D());
        }
        graphics.drawRenderedImage(img, at);
        graphics.setClip(clipOld);
        return true;
    }

    public BufferedImage readImage(PackagePart packagePart) throws IOException {
        return ImageIO.read(packagePart.getInputStream());
    }
}

