/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.math.BigDecimal;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

class FBFloatField
extends FBField {
    FBFloatField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    @Override
    public byte getByte() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        Float value = new Float(this.field.decodeFloat(this.getFieldData()));
        if (value.floatValue() > 127.0f || value.floatValue() < -128.0f) {
            throw (SQLException)FBFloatField.createException(BYTE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.byteValue();
    }

    @Override
    public short getShort() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        Float value = new Float(this.field.decodeFloat(this.getFieldData()));
        if (value.floatValue() > 32767.0f || value.floatValue() < -32768.0f) {
            throw (SQLException)FBFloatField.createException(SHORT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.shortValue();
    }

    @Override
    public int getInt() throws SQLException {
        if (this.getFieldData() == null) {
            return 0;
        }
        Float value = new Float(this.field.decodeFloat(this.getFieldData()));
        if (value.floatValue() > 2.1474836E9f || value.floatValue() < -2.1474836E9f) {
            throw (SQLException)FBFloatField.createException(INT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.intValue();
    }

    @Override
    public long getLong() throws SQLException {
        if (this.getFieldData() == null) {
            return 0L;
        }
        Float value = new Float(this.field.decodeFloat(this.getFieldData()));
        if (value.floatValue() > 9.223372E18f || value.floatValue() < -9.223372E18f) {
            throw (SQLException)FBFloatField.createException(LONG_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        return value.longValue();
    }

    @Override
    public float getFloat() throws SQLException {
        if (this.getFieldData() == null) {
            return 0.0f;
        }
        return this.field.decodeFloat(this.getFieldData());
    }

    @Override
    public double getDouble() throws SQLException {
        if (this.getFieldData() == null) {
            return 0.0;
        }
        return this.field.decodeFloat(this.getFieldData());
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        if (this.getFieldData() == null) {
            return BIGDECIMAL_NULL_VALUE;
        }
        return new BigDecimal(this.field.decodeFloat(this.getFieldData()));
    }

    @Override
    public boolean getBoolean() throws SQLException {
        if (this.getFieldData() == null) {
            return false;
        }
        return this.field.decodeFloat(this.getFieldData()) == 1.0f;
    }

    @Override
    public String getString() throws SQLException {
        if (this.getFieldData() == null) {
            return STRING_NULL_VALUE;
        }
        return String.valueOf(this.field.decodeFloat(this.getFieldData()));
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == STRING_NULL_VALUE) {
            this.setNull();
            return;
        }
        try {
            this.setFloat(Float.parseFloat(value));
        }
        catch (NumberFormatException nfex) {
            throw (SQLException)FBFloatField.createException(FLOAT_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
    }

    @Override
    public void setShort(short value) throws SQLException {
        this.setFloat(value);
    }

    @Override
    public void setBoolean(boolean value) throws SQLException {
        this.setFloat(value ? 1.0f : 0.0f);
    }

    @Override
    public void setFloat(float value) throws SQLException {
        this.setFieldData(this.field.encodeFloat(value));
    }

    @Override
    public void setDouble(double value) throws SQLException {
        if (value > 3.4028234663852886E38 || value < -3.4028234663852886E38) {
            throw (SQLException)FBFloatField.createException(DOUBLE_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setFloat((float)value);
    }

    @Override
    public void setLong(long value) throws SQLException {
        if ((float)value > Float.MAX_VALUE || (float)value < -3.4028235E38f) {
            throw (SQLException)FBFloatField.createException(LONG_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setFloat(value);
    }

    @Override
    public void setInteger(int value) throws SQLException {
        this.setFloat(value);
    }

    @Override
    public void setByte(byte value) throws SQLException {
        this.setFloat(value);
    }

    @Override
    public void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == BIGDECIMAL_NULL_VALUE) {
            this.setNull();
            return;
        }
        if (value.compareTo(new BigDecimal(3.4028234663852886E38)) > 0 || value.compareTo(new BigDecimal(-3.4028234663852886E38)) < 0) {
            throw (SQLException)FBFloatField.createException(BIGDECIMAL_CONVERSION_ERROR + " " + value).fillInStackTrace();
        }
        this.setFloat(value.floatValue());
    }
}

