/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FBStringField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class FBLongVarCharField
extends FBStringField
implements FBFlushableField {
    private static final int BUFF_SIZE = 4096;
    private FBBlob blob;
    private int length;
    private byte[] bytes;
    private InputStream binaryStream;
    private Reader characterStream;

    FBLongVarCharField(XSQLVAR field, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(field, dataProvider, requiredType);
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.blob != null) {
                this.blob.close();
            }
        }
        catch (IOException ioex) {
            throw new FBSQLException(ioex);
        }
        finally {
            this.blob = null;
            this.bytes = null;
            this.binaryStream = null;
            this.characterStream = null;
            this.length = 0;
        }
    }

    @Override
    public Blob getBlob() throws SQLException {
        if (this.blob != null) {
            return this.blob;
        }
        byte[] fieldData = this.getFieldData();
        if (fieldData == null) {
            return BLOB_NULL_VALUE;
        }
        this.blob = new FBBlob(this.gdsHelper, this.field.decodeLong(fieldData));
        return this.blob;
    }

    @Override
    public Clob getClob() throws SQLException {
        FBBlob blob = (FBBlob)this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return CLOB_NULL_VALUE;
        }
        return new FBClob(blob);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return STREAM_NULL_VALUE;
        }
        return blob.getBinaryStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == BLOB_NULL_VALUE) {
            return BYTES_NULL_VALUE;
        }
        InputStream in = blob.getBinaryStream();
        if (in == STREAM_NULL_VALUE) {
            return BYTES_NULL_VALUE;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        try {
            int counter;
            byte[] buff = new byte[4096];
            while ((counter = in.read(buff)) != -1) {
                bout.write(buff, 0, counter);
            }
        }
        catch (IOException ioex) {
            chain.append(FBLongVarCharField.createException(BYTES_CONVERSION_ERROR + " " + ioex.getMessage()));
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioex) {
                chain.append(new FBSQLException(ioex));
            }
        }
        if (chain.hasException()) {
            throw chain.getException();
        }
        return bout.toByteArray();
    }

    @Override
    public byte[] getCachedData() throws SQLException {
        if (this.getFieldData() != null) {
            return this.getBytes();
        }
        if (this.bytes != null) {
            return this.bytes;
        }
        return BYTES_NULL_VALUE;
    }

    @Override
    public FBFlushableField.CachedObject getCachedObject() throws SQLException {
        if (this.getFieldData() == null) {
            return new FBFlushableField.CachedObject(this.bytes, this.binaryStream, this.characterStream, this.length);
        }
        byte[] bytes = this.getBytes();
        return new FBFlushableField.CachedObject(bytes, null, null, 0);
    }

    @Override
    public void setCachedObject(FBFlushableField.CachedObject cachedObject) throws SQLException {
        this.setNull();
        this.bytes = cachedObject.bytes;
        this.binaryStream = cachedObject.binaryStream;
        this.characterStream = cachedObject.characterStream;
        this.length = cachedObject.length;
    }

    @Override
    public String getString() throws SQLException {
        byte[] data = this.getBytes();
        if (data == BYTES_NULL_VALUE) {
            return STRING_NULL_VALUE;
        }
        return this.field.decodeString(data, this.javaEncoding, this.mappingPath);
    }

    @Override
    public void setBlob(FBBlob blob) throws SQLException {
        this.setNull();
        this.setFieldData(this.field.encodeLong(blob.getBlobId()));
        this.blob = blob;
    }

    @Override
    public void setClob(FBClob clob) throws SQLException {
        FBBlob blob = clob.getWrappedBlob();
        this.setBlob(blob);
    }

    @Override
    public void setCharacterStream(Reader in, int length) throws SQLException {
        this.setNull();
        if (in != READER_NULL_VALUE) {
            this.characterStream = in;
            this.length = length;
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        this.setNull();
        if (value != STRING_NULL_VALUE) {
            this.setBytes(this.field.encodeString(value, this.javaEncoding, this.mappingPath));
        }
    }

    @Override
    public void setBytes(byte[] value) throws SQLException {
        this.setNull();
        if (value != BYTES_NULL_VALUE) {
            this.bytes = value;
            this.length = value.length;
        }
    }

    @Override
    public void setBinaryStream(InputStream in, int length) throws SQLException {
        this.setNull();
        if (in != STREAM_NULL_VALUE) {
            this.binaryStream = in;
            this.length = length;
        }
    }

    @Override
    public void flushCachedData() throws SQLException {
        if (this.binaryStream != null) {
            this.copyBinaryStream(this.binaryStream, this.length);
        } else if (this.characterStream != null) {
            this.copyCharacterStream(this.characterStream, this.length, this.javaEncoding);
        } else if (this.bytes != null) {
            this.copyBytes(this.bytes, this.length);
        } else if (this.blob == null) {
            this.setNull();
        }
        this.characterStream = null;
        this.binaryStream = null;
        this.bytes = null;
        this.length = 0;
    }

    @Override
    public void setNull() {
        super.setNull();
        try {
            if (this.blob != null) {
                this.blob.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.blob = null;
            this.binaryStream = null;
            this.characterStream = null;
            this.bytes = null;
            this.length = 0;
        }
    }

    private void copyBinaryStream(InputStream in, int length) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyStream(in, length);
        this.setFieldData(this.field.encodeLong(blob.getBlobId()));
    }

    private void copyCharacterStream(Reader in, int length, String encoding) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyCharacterStream(in, length, encoding);
        this.setFieldData(this.field.encodeLong(blob.getBlobId()));
    }

    private void copyBytes(byte[] bytes, int length) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyBytes(bytes, 0, length);
        this.setFieldData(this.field.encodeLong(blob.getBlobId()));
    }
}

