/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleResultSet;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.REF;
import oracle.sql.STRUCT;

@ProxyFor(value={OracleResultSet.class})
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableResultSet
extends TxnReplayableBase
implements JDBCReplayable {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;

    protected TxnReplayableResultSet() {
        this.thisProxyNameInLog = "RSET" + this.thisProxyNameInLog;
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="getARRAY", args={int.class}), @Signature(name="getARRAY", args={String.class}), @Signature(name="getBfile", args={int.class}), @Signature(name="getBFILE", args={int.class}), @Signature(name="getBfile", args={String.class}), @Signature(name="getBFILE", args={String.class}), @Signature(name="getBLOB", args={int.class}), @Signature(name="getBLOB", args={String.class}), @Signature(name="getCLOB", args={int.class}), @Signature(name="getCLOB", args={String.class}), @Signature(name="getOPAQUE", args={int.class}), @Signature(name="getOPAQUE", args={String.class}), @Signature(name="getREF", args={int.class}), @Signature(name="getREF", args={String.class}), @Signature(name="getSTRUCT", args={int.class}), @Signature(name="getSTRUCT", args={String.class}), @Signature(name="updateARRAY", args={int.class, ARRAY.class}), @Signature(name="updateARRAY", args={String.class, ARRAY.class}), @Signature(name="updateBfile", args={int.class, BFILE.class}), @Signature(name="updateBFILE", args={int.class, BFILE.class}), @Signature(name="updateBfile", args={String.class, BFILE.class}), @Signature(name="updateBFILE", args={String.class, BFILE.class}), @Signature(name="updateBLOB", args={int.class, BLOB.class}), @Signature(name="updateBLOB", args={String.class, BLOB.class}), @Signature(name="updateCLOB", args={int.class, CLOB.class}), @Signature(name="updateCLOB", args={String.class, CLOB.class}), @Signature(name="updateREF", args={int.class, REF.class}), @Signature(name="updateREF", args={String.class, REF.class}), @Signature(name="updateSTRUCT", args={int.class, STRUCT.class}), @Signature(name="updateSTRUCT", args={String.class, STRUCT.class})})
    protected void preForMethodWithConcreteClass(Method method, Object object, Object ... objectArray) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 397, "Replay disabled because of concrete class usage", null);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="updateAsciiStream", args={String.class, InputStream.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class, long.class})})
    protected void preForUpdateStreams(Method method, Object object, Object ... objectArray) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
        }
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        this.onErrorForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="last", args={})})
    protected boolean onErrorForLast(Method method, SQLException sQLException) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw sQLException;
        }
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (sQLException instanceof SQLRecoverableException && replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
        return (Boolean)super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        Object object = super.replayOneCall(callHistoryEntry, sQLRecoverableException);
        return object;
    }
}

