/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.networking.internal.ext;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.networking.ext.AgentService;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.propagation.PropagateOnStatus;
import org.openstack4j.model.network.Agent;
import org.openstack4j.openstack.networking.domain.NeutronAgent;
import org.openstack4j.openstack.networking.internal.BaseNetworkingServices;

public class AgentServiceImpl
extends BaseNetworkingServices
implements AgentService {
    @Override
    public List<? extends Agent> list() {
        return this.get(NeutronAgent.Agents.class, this.uri("/agents", new Object[0])).execute().getList();
    }

    @Override
    public Agent getAgent(String agentId) {
        Preconditions.checkNotNull((Object)agentId);
        return this.get(NeutronAgent.class, this.uri("/agents/%s", agentId)).execute();
    }

    @Override
    public Agent setAdminStateUp(String agentId, boolean state) {
        Preconditions.checkNotNull((Object)agentId);
        String json = String.format("{\"%s\": { \"%s\": \"%b\"}}", "agent", "admin_state_up", state);
        return this.put(NeutronAgent.class, this.uri("/agents/%s", agentId)).json(json).execute(ExecutionOptions.create(PropagateOnStatus.on(404)));
    }
}

