/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.util.ArrayList;
import java.util.List;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.ErrMsg;

public final class ErrorMessage {
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int NG = 2;
    public static final int EXCEPTION = 8;
    public static final int ORCL_ERR = 9;
    private int maxKekka = 0;
    private String title = "";
    private final List<ErrMsg> list = new ArrayList<ErrMsg>();
    private boolean setPgStep;

    public ErrorMessage() {
        this.setTitle("NO TITLE");
    }

    public ErrorMessage(String string) {
        this.setTitle(string);
    }

    public ErrorMessage addMessage(String ... stringArray) {
        if (stringArray != null) {
            this.addMessage(0, 2, "", stringArray);
        }
        return this;
    }

    public ErrorMessage addMessage(int n, int n2, String string, String ... stringArray) {
        if (string != null) {
            ErrMsg errMsg = new ErrMsg(n, n2, null, null, string, stringArray);
            this.list.add(errMsg);
            if (this.maxKekka < n2) {
                this.maxKekka = n2;
            }
        }
        return this;
    }

    public ErrorMessage addMessage(Throwable throwable) {
        if (throwable != null) {
            String string = ThrowUtil.ogThrowMsg(throwable.getMessage(), throwable);
            int n = this.list.size();
            if (n == 0) {
                this.addMessage(0, 2, "", string);
            } else {
                ErrMsg errMsg = this.list.get(n - 1);
                this.addMessage(errMsg.getNo(), 2, errMsg.getId(), string);
            }
        }
        return this;
    }

    public ErrorMessage addMessage(ErrMsg errMsg) {
        if (errMsg != null) {
            this.list.add(errMsg);
            if (this.maxKekka < errMsg.getKekka()) {
                this.maxKekka = errMsg.getKekka();
            }
            if (errMsg.getPg() != null || errMsg.getStep() != null) {
                this.setPgStep = true;
            }
        }
        return this;
    }

    public ErrorMessage append(ErrorMessage errorMessage) {
        if (errorMessage != null) {
            if (this.maxKekka < errorMessage.getKekka()) {
                this.maxKekka = errorMessage.getKekka();
            }
            ErrMsg[] errMsgArray = errorMessage.toArray();
            for (int i = 0; i < errMsgArray.length; ++i) {
                this.list.add(errMsgArray[i]);
            }
        }
        return this;
    }

    public ErrorMessage append(int n, ErrorMessage errorMessage) {
        if (errorMessage != null) {
            if (this.maxKekka < errorMessage.getKekka()) {
                this.maxKekka = errorMessage.getKekka();
            }
            ErrMsg[] errMsgArray = errorMessage.toArray();
            for (int i = 0; i < errMsgArray.length; ++i) {
                this.list.add(errMsgArray[i].copy(n));
            }
        }
        return this;
    }

    public ErrMsg[] toArray() {
        return this.list.toArray(new ErrMsg[this.list.size()]);
    }

    public int size() {
        return this.list.size();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getKekka() {
        return this.maxKekka;
    }

    public boolean isOK() {
        return this.maxKekka == 0;
    }

    public boolean isSetPgStep() {
        return this.setPgStep;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200).append(this.getTitle()).append(HybsConst.CR);
        for (ErrMsg errMsg : this.list) {
            stringBuilder.append(errMsg).append(HybsConst.CR);
        }
        return stringBuilder.toString();
    }
}

