/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.develop;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.develop.JspEnumeration;

public final class JspConvertEntity {
    private static final String[] DBKEY = new String[]{"SYSTEM_ID", "PGID", "NMSYORI", "SEQ", "CLM", "CLM_NAME", "KBACCS", "MUST", "DEFAULT_VAL", "TABLE_NAME", "ZOKUSEI", "SETU", "NMSYS", "NMPG", "HPGID", "USE_ORDER", "AS_CLM", "JOINTYPE", "AS_TABLE", "CLS_NAME"};
    private static final int PGID = 1;
    private static final int NMSYORI = 2;
    private static final int CLM = 4;
    private static final int CLM_NAME = 5;
    private static final int MUST = 7;
    private static final int DEFAULT_VAL = 8;
    private static final int TABLE_NAME = 9;
    private static final int ZOKUSEI = 10;
    private static final int NMSYS = 12;
    private static final int NMPG = 13;
    private static final int USE_ORDER = 15;
    private static final int AS_CLM = 16;
    private static final int JOINTYPE = 17;
    private static final int AS_TABLE = 18;
    private static final int CLS_NAME = 19;
    private final String _type;
    private final String _column_name;
    private final String _clm_name_ja;
    private final String _table_name;
    private final String _as_table_name;
    private final String _as_column_name;
    private final String _default_value;
    private final String _remarks;
    private final String _must;
    private final String _nmsys;
    private final String _pgid;
    private final String _nmpg;
    private final String _use_order;
    private final boolean _is_number;
    private final String _join_type;
    private final JspConvertEntity _join_column;

    public static JspConvertEntity newInstance(String[] stringArray, int[] nArray) {
        String string = stringArray[nArray[2]];
        String string2 = stringArray[nArray[10]];
        return StringUtil.isNull((CharSequence[])new CharSequence[]{string2}) && ("QUERY".equals(string) || "JOIN".equals(string) || "CONST".equals(string)) ? null : new JspConvertEntity(stringArray, nArray);
    }

    private JspConvertEntity(String[] stringArray, int[] nArray) {
        this._type = stringArray[nArray[2]];
        this._table_name = stringArray[nArray[9]];
        this._as_table_name = stringArray[nArray[18]];
        this._column_name = stringArray[nArray[4]];
        this._clm_name_ja = stringArray[nArray[5]];
        this._as_column_name = stringArray[nArray[16]];
        this._default_value = stringArray[nArray[8]];
        this._remarks = stringArray[nArray[10]];
        this._must = stringArray[nArray[7]];
        this._use_order = stringArray[nArray[15]];
        this._is_number = "NUMBER".equals(stringArray[nArray[19]]);
        this._join_type = stringArray[nArray[17]];
        this._nmsys = stringArray[nArray[12]];
        this._pgid = stringArray[nArray[1]];
        this._nmpg = stringArray[nArray[13]];
        this._join_column = "JOIN".equals(this._type) ? this.createLeftTable(this._remarks) : null;
    }

    private JspConvertEntity(String string, String string2, String string3, String string4) {
        this._type = string;
        this._table_name = string2;
        this._as_table_name = string3;
        this._column_name = string4;
        this._clm_name_ja = null;
        this._as_column_name = null;
        this._default_value = null;
        this._remarks = null;
        this._must = null;
        this._use_order = null;
        this._is_number = false;
        this._join_type = null;
        this._join_column = null;
        this._nmsys = null;
        this._pgid = null;
        this._nmpg = null;
    }

    public static String[] getDBKEY() {
        return (String[])DBKEY.clone();
    }

    public String getType() {
        return this._type;
    }

    public String getTableName() {
        return this._table_name;
    }

    public String getColumnName() {
        return this._column_name;
    }

    public String getColumnCommentName() {
        return this._clm_name_ja;
    }

    public String getFullColumnName() {
        String string = "";
        string = StringUtil.isNull((CharSequence[])new CharSequence[]{this._as_table_name}) ? this._table_name : this._as_table_name;
        Matcher matcher = null;
        for (JspEnumeration.TREATS_STRING_FUNCTIONS tREATS_STRING_FUNCTIONS : JspEnumeration.TREATS_STRING_FUNCTIONS.values()) {
            String string2 = tREATS_STRING_FUNCTIONS.toString();
            matcher = Pattern.compile("(((\\s*?)|\\()" + string2 + "(\\s+?))|(((\\s*?)|\\()" + string2.toLowerCase(Locale.JAPAN) + "(\\s+?))").matcher(this._column_name);
            if (!matcher.find()) continue;
            return tREATS_STRING_FUNCTIONS.update(this._column_name, new String[0]);
        }
        return string + "." + this._column_name;
    }

    public JspConvertEntity getJoinColumn() {
        return this._join_column;
    }

    public String getAsTableName() {
        return this._as_table_name;
    }

    public String getAsColumnName() {
        return this._as_column_name;
    }

    public String getSelectPartColumnName() {
        if (StringUtil.isNull((CharSequence[])new CharSequence[]{this._remarks}) || "DISP".equalsIgnoreCase(this._remarks)) {
            if (StringUtil.isNull((CharSequence[])new CharSequence[]{this._as_column_name})) {
                return this.getFullColumnName();
            }
            return this.getFullColumnName() + " as " + this._as_column_name;
        }
        if (StringUtil.isNull((CharSequence[])new CharSequence[]{this._as_column_name})) {
            return this._remarks + "(" + this.getFullColumnName() + ")";
        }
        return this._remarks + "(" + this.getFullColumnName() + ") as " + this._as_column_name;
    }

    public String getFromPartTableName() {
        return StringUtil.isNull((CharSequence[])new CharSequence[]{this._as_table_name}) ? this._table_name : this._table_name + " " + this._as_table_name;
    }

    public String getDefaultValue() {
        return this._default_value;
    }

    public String getRemarks() {
        return this._remarks;
    }

    public String getMust() {
        return this._must;
    }

    public String getUseOrder() {
        return this._use_order;
    }

    public boolean isNumber() {
        return this._is_number;
    }

    public String getNmSys() {
        return this._nmsys;
    }

    public String getPgid() {
        return this._pgid;
    }

    public String getNmpg() {
        return this._nmpg;
    }

    public String getJoinType() {
        return this._join_type;
    }

    private JspConvertEntity createLeftTable(String string) {
        JspConvertEntity jspConvertEntity = null;
        String[] stringArray = string.split("__");
        if (stringArray.length == 3) {
            String string2 = stringArray[1];
            String string3 = stringArray[2].substring(0, stringArray[2].indexOf(46));
            String string4 = stringArray[2].substring(stringArray[2].indexOf(46) + 1);
            jspConvertEntity = new JspConvertEntity("JOIN", string2, string3, string4);
        }
        return jspConvertEntity;
    }
}

