/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opengion.fukurou.fileexec.CommandLine;
import org.opengion.fukurou.fileexec.FileExec;
import org.opengion.fukurou.fileexec.MsgUtil;
import org.opengion.fukurou.fileexec.StringUtil;
import org.opengion.fukurou.fileexec.XLogger;

public final class MainProcess {
    private static final XLogger LOGGER = XLogger.getLogger(MainProcess.class.getName());
    private final ConcurrentMap<Integer, FileExec> execMap = new ConcurrentHashMap<Integer, FileExec>();
    public static final String USAGE = "Usage: java org.opengion.fukurou.fileexec.MainProcess [-LOOP n(\u79d2)] [-help]";

    public void startTask(CommandLine commandLine) {
        int n = Integer.parseInt(commandLine.getValue(CommandLine.GE70.RSRV_NO));
        this.stopTask(n);
        String string = commandLine.getValue(CommandLine.GE70.FGYKAN);
        if ("1".equals(string) || "3".equals(string)) {
            FileExec fileExec = new FileExec(commandLine);
            LOGGER.info(() -> "startTask: yoyakuNo=[" + n + "]");
            fileExec.watchStart();
            this.execMap.put(n, fileExec);
        } else {
            LOGGER.warning(() -> "\u3010WARNING\u3011startTask: yoyakuNo=[" + n + "] , fgkan=[" + string + "]");
        }
    }

    private void stopTask(int n) {
        FileExec fileExec = (FileExec)this.execMap.remove(n);
        if (fileExec != null) {
            fileExec.watchStop();
        }
        LOGGER.info(() -> "stopTask: yoyakuNo=[" + n + "]");
    }

    public void watchStop() {
        this.execMap.forEach((n, fileExec) -> fileExec.watchStop());
    }

    public static void main(String[] stringArray) {
        int n = 10;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("-help".equalsIgnoreCase(string)) {
                System.out.println(USAGE);
                return;
            }
            if (!"-LOOP".equalsIgnoreCase(string)) {
                throw MsgUtil.throwException("MSG2011", Arrays.toString(stringArray));
            }
            n = Integer.parseInt(stringArray[++i]);
        }
        MainProcess mainProcess = new MainProcess();
        boolean bl = true;
        int n2 = 0;
        while (true) {
            try {
                while (true) {
                    List<CommandLine> list = CommandLine.dbCommand(bl);
                    list.forEach(commandLine -> mainProcess.startTask((CommandLine)commandLine));
                    try {
                        Thread.sleep((long)n * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    bl = false;
                    System.out.println(StringUtil.getTimeFormat("yyyyMMdd HH:mm:ss [" + n2++ + "]"));
                }
            }
            catch (Throwable throwable) {
                MsgUtil.errPrintln(throwable, "MSG0021", throwable.getMessage());
                mainProcess.watchStop();
                continue;
            }
            break;
        }
    }
}

