<?xml version="1.0" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6230"
	title	= "LDAP+MAIL"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 複数選択されたC社員番号を、カンマ区切りで連結します。(action="APPEND") -->
<og:value key="uidx"  value="{@uid}" action="APPEND" />
<og:value key="to" command="SET" value="{@uidadd},{@uidx}" action="MERGE" />

<!-- タイトルの設定。簡易的に 画面IDを ラベルリソースに登録しておいて、それを取り出しています。-->
<og:value key="subject" command="SET" >{@GUIKEY}:<og:message lbl="{@GUIKEY}" /></og:value>

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンを作成します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry"   lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset"   lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
</og:writeCheck>

<!-- メールに渡すパラメータの設定。-->
<!-- og:link useDirectJump="true" で、ダイレクトジャンプのURLを作成しています。-->
<!-- og:file action="read" で、本文ファイルを読み込んでいます。-->
<table border="0" frame="border" summary="form" >
<tr><og:input name="subject" lbl="Subject" value="{@subject}" size="100"  colspan="3" /></tr>
<tr><og:input name="to"      lbl="To"      value="{@to}"      size="80"  /></tr>
<tr><og:input name="host"    lbl="Host"    value="{@SYS.COMMON_MAIL_SERVER}"  size="80"  /></tr>
<tr><og:textarea name="message" rows="15" cols="80" lbl="Message" >
<og:link gamenId="{@GUIKEY}"  href="index.jsp" useDirectJump="true" useRequestCache="true" keys="command" vals="NEW" />
<og:file action="read" fileURL="{@SYS.REAL_PATH}jsp/{@GUI.ADDRESS}/" file1="sample.txt" >Error</og:file>
</og:textarea>
</tr>
</table>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
