/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.ResultSetValue;
import org.opengion.fukurou.db.Transaction;
import org.opengion.fukurou.db.TransactionReal;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.util.StringUtil;

public final class DBUtil {
    private static final int DB_FETCH_SIZE = 1001;

    private DBUtil() {
    }

    public static String[][] dbExecute(String string, String[] stringArray, ApplicationInfo applicationInfo) {
        try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
            String[][] stringArray2 = DBUtil.dbExecute(string, stringArray, transactionReal, null, false);
            return stringArray2;
        }
    }

    public static String[][] dbExecute(String string, String[] stringArray, Transaction transaction) {
        return DBUtil.dbExecute(string, stringArray, transaction, null, false);
    }

    public static String[][] dbExecute(String string, String[] stringArray, ApplicationInfo applicationInfo, String string2) {
        try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
            String[][] stringArray2 = DBUtil.dbExecute(string, stringArray, transactionReal, string2, false);
            return stringArray2;
        }
    }

    public static String[][] dbExecute(String string, String[] stringArray, Transaction transaction, String string2) {
        return DBUtil.dbExecute(string, stringArray, transaction, string2, false);
    }

    public static String[][] dbExecute(String string, String[] stringArray, ApplicationInfo applicationInfo, String string2, boolean bl) {
        try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
            String[][] stringArray2 = DBUtil.dbExecute(string, stringArray, transactionReal, string2, bl);
            return stringArray2;
        }
    }

    public static String[][] dbExecute(String string, String[] stringArray, Transaction transaction, String string2, boolean bl) {
        String[][] stringArray2 = null;
        try {
            Connection connection = transaction.getConnection(string2);
            try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                Object object;
                preparedStatement.setFetchSize(1001);
                if (stringArray != null && stringArray.length > 0) {
                    boolean bl2 = ConnectionFactory.useParameterMetaData(string2);
                    if (bl2) {
                        object = preparedStatement.getParameterMetaData();
                        for (int i = 0; i < stringArray.length; ++i) {
                            int n = object.getParameterType(i + 1);
                            String string3 = stringArray[i];
                            if (string3 == null || string3.isEmpty()) {
                                preparedStatement.setNull(i + 1, n);
                                continue;
                            }
                            preparedStatement.setObject(i + 1, (Object)string3, n);
                        }
                    } else {
                        for (int i = 0; i < stringArray.length; ++i) {
                            preparedStatement.setObject(i + 1, stringArray[i]);
                        }
                    }
                }
                if (preparedStatement.execute()) {
                    ResultSet resultSet = preparedStatement.getResultSet();
                    object = null;
                    try {
                        stringArray2 = DBUtil.resultToArray(resultSet, bl);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (resultSet != null) {
                            if (object != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                resultSet.close();
                            }
                        }
                    }
                }
                transaction.commit();
            }
        }
        catch (SQLException sQLException) {
            transaction.rollback();
            String string4 = sQLException.getMessage() + ":" + sQLException.getSQLState() + HybsConst.CR + "SQL=[" + string + "]" + HybsConst.CR + "ARG=[" + StringUtil.array2csv(stringArray) + "]" + HybsConst.CR + "DBID=[" + string2 + "]" + HybsConst.CR;
            throw new OgRuntimeException(string4, sQLException);
        }
        return stringArray2;
    }

    public static String[] dbCallExecute(String string, String[] stringArray, ApplicationInfo applicationInfo) {
        try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
            String[] stringArray2 = DBUtil.dbCallExecute(string, stringArray, transactionReal, null);
            return stringArray2;
        }
    }

    public static String[] dbCallExecute(String string, String[] stringArray, Transaction transaction) {
        return DBUtil.dbCallExecute(string, stringArray, transaction, null);
    }

    public static String[] dbCallExecute(String string, String[] stringArray, ApplicationInfo applicationInfo, String string2) {
        try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
            String[] stringArray2 = DBUtil.dbCallExecute(string, stringArray, transactionReal, string2);
            return stringArray2;
        }
    }

    public static String[] dbCallExecute(String string, String[] stringArray, Transaction transaction, String string2) {
        String[] stringArray2 = new String[2];
        try {
            Connection connection = transaction.getConnection(string2);
            try (CallableStatement callableStatement = connection.prepareCall(string);){
                callableStatement.setFetchSize(1001);
                callableStatement.registerOutParameter(1, 4);
                callableStatement.registerOutParameter(2, 12);
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        callableStatement.setObject(i + 3, (Object)stringArray[i]);
                    }
                }
                callableStatement.execute();
                stringArray2[0] = String.valueOf(callableStatement.getInt(1));
                stringArray2[1] = callableStatement.getString(2);
                transaction.commit();
            }
        }
        catch (SQLException sQLException) {
            transaction.rollback();
            String string3 = sQLException.getMessage() + ":" + sQLException.getSQLState() + HybsConst.CR + "SQL=[" + string + "]" + HybsConst.CR + "ARG=[" + StringUtil.array2csv(stringArray) + "]" + HybsConst.CR + "DBID=[" + string2 + "]" + HybsConst.CR;
            throw new OgRuntimeException(string3, sQLException);
        }
        return stringArray2;
    }

    public static int dbExist(String string, String[] stringArray, ApplicationInfo applicationInfo, String string2) {
        try (TransactionReal transactionReal = new TransactionReal(applicationInfo);){
            int n = DBUtil.dbExist(string, stringArray, transactionReal, string2);
            return n;
        }
    }

    public static int dbExist(String string, String[] stringArray, Transaction transaction, String string2) {
        int n = -1;
        try {
            Connection connection = transaction.getConnection(string2);
            try (PreparedStatement preparedStatement = connection.prepareStatement(string);){
                Object object;
                preparedStatement.setFetchSize(1001);
                if (stringArray != null) {
                    boolean bl = ConnectionFactory.useParameterMetaData(string2);
                    if (bl) {
                        object = preparedStatement.getParameterMetaData();
                        for (int i = 0; i < stringArray.length; ++i) {
                            int n2 = object.getParameterType(i + 1);
                            String string3 = stringArray[i];
                            if (string3 == null || string3.isEmpty()) {
                                preparedStatement.setNull(i + 1, n2);
                                continue;
                            }
                            preparedStatement.setObject(i + 1, (Object)string3, n2);
                        }
                    } else {
                        for (int i = 0; i < stringArray.length; ++i) {
                            preparedStatement.setObject(i + 1, stringArray[i]);
                        }
                    }
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                object = null;
                try {
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (resultSet != null) {
                        if (object != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
            transaction.commit();
        }
        catch (SQLException sQLException) {
            transaction.rollback();
            String string4 = sQLException.getMessage() + ":" + sQLException.getSQLState() + HybsConst.CR + "SQL=[" + string + "]" + HybsConst.CR + "ARG=[" + StringUtil.array2csv(stringArray) + "]" + HybsConst.CR + "DBID=[" + string2 + "]" + HybsConst.CR;
            throw new OgRuntimeException(string4, sQLException);
        }
        return n;
    }

    public static String[][] resultToArray(ResultSet resultSet, boolean bl) throws SQLException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ResultSetValue resultSetValue = new ResultSetValue(resultSet);
        if (bl) {
            arrayList.add(resultSetValue.getNames());
        }
        while (resultSetValue.next()) {
            arrayList.add(resultSetValue.getValues());
        }
        int n = arrayList.size();
        String[][] stringArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String[])arrayList.get(i);
        }
        return stringArray;
    }

    public static String getProductName(Connection connection) {
        String string;
        try {
            string = connection.getMetaData().getDatabaseProductName().toUpperCase(Locale.JAPAN);
        }
        catch (SQLException sQLException) {
            string = "none";
        }
        return string;
    }
}

