/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.UnaryOperator;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.CSVTokenizer;

public final class StringUtil {
    private static final String MODULUS_43 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";
    private static final String[] UTF_STR = new String[]{"&#x0000", "&#x000", "&#x00", "&#x0", "&#x"};
    private static final DecimalFormat[] FMT1 = new DecimalFormat[]{new DecimalFormat("#,##0"), new DecimalFormat("#,##0.0"), new DecimalFormat("#,##0.00"), new DecimalFormat("#,##0.000"), new DecimalFormat("#,##0.0000")};
    private static final String ZERO = "00000000000000000000";
    private static final String UN_CHANGE = ":/?=&._~";

    private StringUtil() {
    }

    public static String urlEncode(String string) {
        if (string == null) {
            return "";
        }
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "UnsupportedEncodingException [UTF-8]" + HybsConst.CR + unsupportedEncodingException.getMessage();
            throw new OgRuntimeException(string2, unsupportedEncodingException);
        }
        catch (RuntimeException runtimeException) {
            String string3 = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc value=[" + string + "] , encode=[UTF-8]" + HybsConst.CR + runtimeException.getMessage();
            throw new OgRuntimeException(string3, runtimeException);
        }
    }

    public static String urlEncode2(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        StringBuilder stringBuilder2 = new StringBuilder(200);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u007f' || UN_CHANGE.indexOf(c) < 0) {
                stringBuilder2.append(c);
                continue;
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder.append(StringUtil.urlEncode(stringBuilder2.toString()));
                stringBuilder2.setLength(0);
            }
            stringBuilder.append(c);
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append(StringUtil.urlEncode(stringBuilder2.toString()));
        }
        return stringBuilder.toString();
    }

    public static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string2 = "UnsupportedEncodingException [UTF-8]" + HybsConst.CR + unsupportedEncodingException.getMessage();
            throw new OgRuntimeException(string2, unsupportedEncodingException);
        }
        catch (RuntimeException runtimeException) {
            String string3 = "\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc value=[" + string + "] , encode=[UTF-8]" + HybsConst.CR + runtimeException.getMessage();
            throw new OgRuntimeException(string3, runtimeException);
        }
    }

    public static String rTrim(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        for (n2 = n = string.length(); 0 < n2 && string.charAt(n2 - 1) <= ' '; --n2) {
        }
        return n2 < n ? string.substring(0, n2) : string;
    }

    public static String toNumber(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        int n3 = string2.indexOf(46);
        if (n3 >= 0) {
            for (n2 = n = string2.length(); n3 < n2 && ".0".indexOf(string2.charAt(n2 - 1)) >= 0; --n2) {
            }
        }
        if (n2 < n) {
            string2 = string2.substring(0, n2);
        }
        if (n3 == 0) {
            string2 = "0" + string2;
        }
        return string2;
    }

    public static String lTrim0(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        int n2 = string2.length();
        for (n = 0; n2 > n && string2.charAt(n) == '0'; ++n) {
        }
        if (n == 0) {
            return string2;
        }
        if (n == n2) {
            return "0";
        }
        if (string2.charAt(n) == '.') {
            return "0" + string2.substring(n);
        }
        return string2.substring(n);
    }

    public static String[] rTrims(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = StringUtil.rTrim(stringArray[i]);
        }
        return stringArray2;
    }

    public static String csvOutQuote(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.startsWith("'0")) {
            string2 = string2.substring(1);
        } else {
            int n = string2.length();
            if (n >= 2 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
                string2 = string2.substring(1, n - 1);
            }
        }
        return string2;
    }

    public static String makeString(byte[] byArray, int n, int n2, String string) {
        if (string.startsWith("Unicode")) {
            String string2 = "Unicode\u6587\u5b57\u5217\u306f\u3001\u5909\u63db\u3067\u304d\u307e\u305b\u3093\u3002[" + string + "]" + HybsConst.CR;
            throw new OgRuntimeException(string2);
        }
        String string3 = null;
        if (byArray != null) {
            try {
                string3 = new String(byArray, n, n2, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string4 = "\u6587\u5b57\u5909\u63db\u30b3\u30fc\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002[" + string + "]" + HybsConst.CR + unsupportedEncodingException.getMessage();
                throw new OgRuntimeException(string4, unsupportedEncodingException);
            }
        }
        return string3;
    }

    public static byte[] makeByte(String string, String string2) {
        byte[] byArray = new byte[]{};
        if (string != null) {
            try {
                byArray = string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                String string3 = "\u6587\u5b57\u5909\u63db\u30b3\u30fc\u30c9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002[" + string2 + "]" + HybsConst.CR + unsupportedEncodingException.getMessage();
                throw new OgRuntimeException(string3, unsupportedEncodingException);
            }
        }
        return byArray;
    }

    public static String stringXFill(String string, int n) {
        char[] cArray = string == null ? new char[]{} : string.toCharArray();
        int n2 = cArray.length;
        if (n < n2) {
            String string2 = "\u5143\u306e\u6587\u5b57\u6570\u304c\u30d5\u30a9\u30fc\u30e0\u3088\u308a\u9577\u3044\u3067\u3059\u3002(\u6570\u5b57\u304c\u58ca\u308c\u307e\u3059\u3002)su_fill[" + n + "], len[" + n2 + "]" + HybsConst.CR + "input=[" + string + "]" + HybsConst.CR;
            throw new OgRuntimeException(string2);
        }
        char[] cArray2 = new char[n];
        Arrays.fill(cArray2, ' ');
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        return new String(cArray2);
    }

    public static String stringFill(String string, int n, String string2) {
        if (n < 0) {
            String string3 = "\u6307\u5b9a\u6587\u5b57\u6570\u304c\u8ca0\u3067\u3059\u3002[" + n + "]";
            throw new OgRuntimeException(string3);
        }
        byte[] byArray = StringUtil.makeByte(string, string2);
        int n2 = byArray.length;
        if (n2 >= n) {
            return StringUtil.makeString(byArray, 0, n, string2);
        }
        byte[] byArray2 = StringUtil.makeByte(" ", string2);
        int n3 = byArray2.length;
        if (n3 == 4) {
            byArray2[0] = byArray2[2];
            byArray2[1] = byArray2[3];
            n3 = 2;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        int n4 = 0;
        for (int i = n2; i < n; ++i) {
            if (n4 >= n3) {
                n4 = 0;
            }
            byArray3[i] = byArray2[n4++];
        }
        return StringUtil.makeString(byArray3, 0, n, string2);
    }

    public static String intFill(String string, int n) {
        if (n < 0) {
            String string2 = "\u6307\u5b9a\u6587\u5b57\u6570\u304c\u8ca0\u3067\u3059\u3002[" + n + "]";
            throw new OgRuntimeException(string2);
        }
        char[] cArray = new char[n];
        Arrays.fill(cArray, '0');
        if (string == null) {
            return new String(cArray);
        }
        char[] cArray2 = string.toCharArray();
        int n2 = cArray2.length;
        if (n < n2) {
            String string3 = "\u5143\u306e\u6587\u5b57\u6570\u304c\u30d5\u30a9\u30fc\u30e0\u3088\u308a\u9577\u3044\u3067\u3059\u3002(\u6570\u5b57\u304c\u58ca\u308c\u307e\u3059\u3002) su_fill[" + n + "], len[" + n2 + "]";
            throw new OgRuntimeException(string3);
        }
        System.arraycopy(cArray2, 0, cArray, n - n2, n2);
        return new String(cArray);
    }

    public static String intFill(int n, int n2) {
        if (n < 0 || n2 < 0) {
            String string = "\u6307\u5b9a\u6587\u5b57\u6570\u304c\u8ca0\u3067\u3059\u3002num=[" + n + "] , su_fill=[" + n2 + "]";
            throw new OgRuntimeException(string);
        }
        String string = String.valueOf(n);
        int n3 = n2 - string.length();
        if (n3 > 0) {
            string = ZERO.substring(0, n3) + string;
        }
        return string;
    }

    public static String stringKFill(String string, int n, String string2) {
        if (n < 0) {
            String string3 = "\u6307\u5b9a\u6587\u5b57\u6570\u304c\u8ca0\u3067\u3059\u3002[" + n + "]";
            throw new OgRuntimeException(string3);
        }
        byte[] byArray = StringUtil.makeByte(string, string2);
        int n2 = byArray.length;
        if (n2 >= n) {
            return StringUtil.makeString(byArray, 0, n, string2);
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byte[] byArray3 = StringUtil.makeByte("\u3000", string2);
        int n3 = byArray3.length;
        int n4 = 0;
        for (int i = n2; i < n; ++i) {
            if (n4 >= n3) {
                n4 = 0;
            }
            byArray2[i] = byArray3[n4++];
        }
        return StringUtil.makeString(byArray2, 0, n, string2);
    }

    public static String realFill(String string, double d) {
        if (d < 0.0) {
            String string2 = "\u6307\u5b9a\u6587\u5b57\u6570\u304c\u8ca0\u3067\u3059\u3002[" + d + "]";
            throw new OgRuntimeException(string2);
        }
        int n = (int)d;
        int n2 = (int)(d * 10.0 - (double)(n * 10));
        char[] cArray = new char[n + n2 + 1];
        Arrays.fill(cArray, '0');
        if (string == null) {
            cArray[n] = 46;
            return new String(cArray);
        }
        int n3 = string.indexOf(46);
        if (n3 < 0) {
            throw new OgRuntimeException("\u5143\u306e\u6587\u5b57\u5217\u306b\u5c0f\u6570\u70b9\u304c\u3001\u542b\u307e\u308c\u307e\u305b\u3093\u3002");
        }
        int n4 = n - n3;
        if (n4 < 0) {
            String string3 = "\u5143\u306e\u6570\u5b57\u304c\u3001\u30d5\u30a9\u30fc\u30e0\u3088\u308a\u9577\u3044\u3067\u3059\u3002(\u6570\u5b57\u304c\u58ca\u308c\u307e\u3059\u3002) form[" + d + "]";
            throw new OgRuntimeException(string3);
        }
        char[] cArray2 = string.toCharArray();
        int n5 = cArray2.length - n3 - 1;
        int n6 = n2 < n5 ? n + n2 + 1 : n + n5 + 1;
        int n7 = 0;
        while (n4 < n6) {
            cArray[n4++] = cArray2[n7++];
        }
        return new String(cArray);
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null || string.indexOf(string2) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = string.indexOf(string2, n);
        while (n2 >= 0) {
            stringBuilder.append(string.substring(n, n2));
            stringBuilder.append(string3);
            n = n2 + string2.length();
            n2 = string.indexOf(string2, n);
        }
        if (n > 0) {
            stringBuilder.append(string.substring(n));
            return stringBuilder.toString();
        }
        return string;
    }

    public static String replaceText(String string, String string2, String string3, UnaryOperator<String> unaryOperator) {
        if (StringUtil.isEmpty(string, string2, string3) || unaryOperator == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        int n = 0;
        int n2 = string.indexOf(string2);
        int n3 = string2.length();
        int n4 = string3.length();
        while (n2 >= 0) {
            String string4;
            int n5 = string.indexOf(string3, n2);
            if (n5 >= 0) {
                stringBuilder.append(string.substring(n, n2));
                string4 = string.substring(n2 + n3, n5);
                stringBuilder.append((String)unaryOperator.apply(string4));
                n = n5 + n4;
                n2 = string.indexOf(string2, n);
                continue;
            }
            string4 = string + "\u306e\u3001prefix[" + string2 + "] \u3068\u3001suffix[" + string3 + "]\u306e\u6574\u5408\u6027\u304c\u53d6\u308c\u3066\u3044\u307e\u305b\u3093\u3002";
            throw new OgRuntimeException(string4);
        }
        return stringBuilder.append(string.substring(n)).toString();
    }

    public static String caseReplace(String string, String string2, boolean bl) {
        String string3;
        int n;
        String string4;
        if (string == null) {
            return string;
        }
        String string5 = string4 = bl ? string.toUpperCase(Locale.JAPAN) : string;
        if (string2 != null && (n = (string3 = " " + string2.trim() + " ").indexOf(" " + string4 + ":")) >= 0) {
            int n2 = string3.indexOf(58, n + 1);
            int n3 = string3.indexOf(32, n2 + 1);
            if (n2 >= 0 && n3 >= 0) {
                string4 = string3.substring(n2 + 1, n3);
            }
        }
        return string4;
    }

    public static String array2csv(String ... stringArray) {
        return StringUtil.array2line(stringArray, ",", 0);
    }

    public static String array2line(String[] stringArray, String string) {
        return StringUtil.array2line(stringArray, string, 0);
    }

    public static String array2line(String[] stringArray, String string, int n) {
        if (stringArray == null || stringArray.length <= n) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(StringUtil.valueOf(stringArray[n]));
        for (int i = n + 1; i < stringArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(StringUtil.valueOf(stringArray[i]));
        }
        return stringBuilder.toString();
    }

    public static Object[] enume2Array(Enumeration<?> enumeration) {
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return new Object[0];
        }
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray();
    }

    public static Object[] enume2Array(Enumeration<?> enumeration, Object[] objectArray) {
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return objectArray;
        }
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList.toArray(objectArray);
    }

    public static String iterator2line(Iterator<?> iterator, String string) {
        if (iterator == null || !iterator.hasNext()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append(StringUtil.valueOf(iterator.next()));
        while (iterator.hasNext()) {
            stringBuilder.append(string);
            stringBuilder.append(StringUtil.valueOf(iterator.next()));
        }
        return stringBuilder.toString();
    }

    public static String[] csv2Array(String string) {
        return StringUtil.csv2Array(string, ',', 0);
    }

    public static String[] csv2Array(String string, char c) {
        return StringUtil.csv2Array(string, c, 0);
    }

    public static String[] csv2Array(String string, char c, int n) {
        int n2;
        if (StringUtil.isEmpty(string)) {
            Object[] objectArray = new String[n];
            Arrays.fill(objectArray, "");
            return objectArray;
        }
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string, c);
        int n3 = n > 0 ? n : cSVTokenizer.countTokens();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3 && cSVTokenizer.hasNext(); ++n2) {
            stringArray[n2] = cSVTokenizer.next().trim();
        }
        while (n2 < n3) {
            stringArray[n2] = "";
            ++n2;
        }
        return stringArray;
    }

    public static String[] csv2Array(String string, char c, int n, String string2) {
        String[] stringArray = StringUtil.csv2Array(string, c, n);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].isEmpty()) continue;
            stringArray[i] = string2;
        }
        return stringArray;
    }

    public static String[] csv2ArrayOnly(String string) {
        if (StringUtil.isEmpty(string)) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Integer[] csv2ArrayExt(String string, int n) {
        if (StringUtil.isEmpty(string)) {
            return new Integer[0];
        }
        String string2 = string.replace("-*", "-" + n);
        string2 = string2.replace("*", "0-" + n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String[] stringArray = string2.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            int n2 = string3.indexOf(45);
            if (n2 > 0) {
                int n3;
                int n4 = Integer.parseInt(string3.substring(0, n2));
                if (n4 < (n3 = Integer.parseInt(string3.substring(n2 + 1)))) {
                    while (n4 <= n3) {
                        arrayList.add(n4++);
                    }
                    continue;
                }
                while (n4 >= n3) {
                    arrayList.add(n4--);
                }
                continue;
            }
            arrayList.add(Integer.valueOf(string3));
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    public static String valueOf(Object object) {
        return object == null ? "" : object.toString();
    }

    public static String htmlFilter(String string) {
        return StringUtil.htmlFilter(string, false);
    }

    public static String htmlFilter(String string, boolean bl) {
        if (StringUtil.isEmpty(string)) {
            return "";
        }
        String string2 = string;
        if (bl) {
            string2 = string2.replaceAll("<[bB][rR][\\s/]*>", "\n");
            string2 = string2.replaceAll("\\\\n", "\n");
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        block7: for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String yenN2br(String string) {
        return StringUtil.isEmpty(string) ? "" : string.replaceAll("\\\\n", "<br/>");
    }

    public static String quoteFilter(String string) {
        if (StringUtil.isEmpty(string)) {
            return "";
        }
        if (string.indexOf(39) < 0 && string.indexOf(34) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\x22");
                    continue block4;
                }
                case '\'': {
                    stringBuilder.append("\\x27");
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String jsonFilter(String string) {
        if (StringUtil.isEmpty(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                case '/': {
                    stringBuilder.append("\\/");
                    continue block10;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String deleteChar(String string, char c) {
        if (string == null || string.indexOf(c) < 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == c) continue;
            cArray[n++] = cArray[i];
        }
        return String.valueOf(cArray, 0, n);
    }

    public static int countChar(String string, char c) {
        if (string == null || string.indexOf(c) < 0) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            ++n;
        }
        return n;
    }

    public static String code39(String string, boolean bl) {
        char c;
        String string2;
        String string3 = string2 = string == null ? "" : string;
        if (!bl) {
            return "*" + string2 + "*";
        }
        int n = 0;
        for (c = '\u0000'; c < string2.length(); ++c) {
            int n2 = MODULUS_43.indexOf(string2.charAt(c));
            if (n2 < 0) {
                String string4 = "\u6307\u5b9a\u306e\u6587\u5b57\u4e2d\u306b\u3001CODE39 \u898f\u5b9a\u5916\u6587\u5b57\u304c\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002[" + string2.charAt(c) + "]";
                throw new OgRuntimeException(string4);
            }
            n += n2;
        }
        c = MODULUS_43.charAt(n % 43);
        return "*" + string2 + c + "*";
    }

    public static String nval(String string, String string2) {
        return StringUtil.isEmpty(string) ? string2 : string;
    }

    public static int nval(String string, int n) {
        return StringUtil.isNull(string) ? n : Integer.parseInt(string);
    }

    public static long nval(String string, long l) {
        return StringUtil.isNull(string) ? l : Long.parseLong(string);
    }

    public static double nval(String string, double d) {
        return StringUtil.isNull(string) ? d : Double.parseDouble(string);
    }

    public static boolean nval(String string, boolean bl) {
        if (string != null && string.length() > 1 && !"true".equalsIgnoreCase(string) && !"false".equalsIgnoreCase(string)) {
            String string2 = "\u6307\u5b9a\u306e\u6587\u5b57\u5217\u306b\u306f\u3001true \u304b\u3001false \u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002[" + string + "]";
            throw new OgRuntimeException(string2);
        }
        return StringUtil.isNull(string) ? bl : (string.length() == 1 ? !"0".equals(string) : "true".equalsIgnoreCase(string));
    }

    public static String nval2(String string, String string2) {
        return StringUtil.isEmpty(string) || "_".equals(string) ? string2 : string.intern();
    }

    public static String nval2(String string, String string2, String string3) {
        return StringUtil.isEmpty(string) ? string2 : ("_".equals(string) ? string3 : string.intern());
    }

    public static String nvalAdd(CharSequence ... charSequenceArray) {
        StringBuilder stringBuilder = new StringBuilder(200);
        for (CharSequence charSequence : charSequenceArray) {
            if (charSequence == null) continue;
            stringBuilder.append(charSequence);
        }
        return stringBuilder.toString();
    }

    public static String coalesce(CharSequence ... charSequenceArray) {
        for (CharSequence charSequence : charSequenceArray) {
            if (StringUtil.isEmpty(charSequence)) continue;
            return charSequence.toString();
        }
        return null;
    }

    public static boolean contains(String string, String ... stringArray) {
        if (string != null && stringArray != null) {
            for (String string2 : stringArray) {
                if (string2 == null || !string.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static String join(String string, CharSequence ... charSequenceArray) {
        if (string == null) {
            return StringUtil.nvalAdd(charSequenceArray);
        }
        StringJoiner stringJoiner = new StringJoiner(string);
        for (CharSequence charSequence : charSequenceArray) {
            if (StringUtil.isEmpty(charSequence)) continue;
            stringJoiner.add(charSequence);
        }
        return stringJoiner.toString();
    }

    public static boolean isEmpty(CharSequence ... charSequenceArray) {
        if (charSequenceArray != null && charSequenceArray.length > 0) {
            for (CharSequence charSequence : charSequenceArray) {
                if (charSequence != null && charSequence.length() != 0) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isNull(CharSequence ... charSequenceArray) {
        if (charSequenceArray != null && charSequenceArray.length > 0) {
            for (CharSequence charSequence : charSequenceArray) {
                if (charSequence == null || charSequence.length() == 0) {
                    return true;
                }
                boolean bl = true;
                for (int i = 0; i < charSequence.length(); ++i) {
                    if (Character.isWhitespace(charSequence.charAt(i))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isNotNull(CharSequence ... charSequenceArray) {
        return !StringUtil.isNull(charSequenceArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String numberFormat(String string, int n) {
        String string2;
        block7: {
            if (StringUtil.isNull(string)) {
                return string;
            }
            string2 = string;
            try {
                double d = StringUtil.parseDouble(string2);
                if (FMT1.length > n) {
                    DecimalFormat decimalFormat = FMT1[n];
                    synchronized (decimalFormat) {
                        string2 = FMT1[n].format(d);
                        break block7;
                    }
                }
                String string3 = "#,##0." + ZERO.substring(0, n);
                string2 = new DecimalFormat(string3).format(d);
            }
            catch (Throwable throwable) {
                String string4 = "ERROR:" + throwable.getLocalizedMessage() + HybsConst.CR + " in=[" + string + "] , minFraction=[" + n + "]";
                System.err.println(ThrowUtil.ogThrowMsg(string4, throwable));
            }
        }
        return string2;
    }

    public static Object newInstance(String string) {
        return StringUtil.newInstance(string, Thread.currentThread().getContextClassLoader());
    }

    public static Object newInstance(String string, ClassLoader classLoader) {
        try {
            return Class.forName(string, true, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            String string2 = "\u6307\u5b9a\u306e\u30e1\u30bd\u30c3\u30c9(\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf)\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002class=[" + string + "]" + HybsConst.CR + reflectiveOperationException.getMessage();
            throw new OgRuntimeException(string2, reflectiveOperationException);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            String string3 = "Class.forName( String,boolean,ClassLoader ).newInstance() \u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f class=[" + string + "]" + HybsConst.CR + reflectiveOperationException.getMessage();
            throw new OgRuntimeException(string3, reflectiveOperationException);
        }
    }

    public static String urlAppend(CharSequence charSequence, CharSequence ... charSequenceArray) {
        StringBuilder stringBuilder = new StringBuilder(200);
        if (StringUtil.isNotNull(charSequence)) {
            stringBuilder.append(charSequence);
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!StringUtil.isNotNull(charSequence2)) continue;
            if (stringBuilder.length() == 0 || charSequence2.charAt(0) == '/' || charSequence2.length() > 1 && charSequence2.charAt(1) == ':' || charSequence2.charAt(0) == '\\') {
                stringBuilder.setLength(0);
                stringBuilder.append(charSequence2);
                continue;
            }
            char c = stringBuilder.charAt(stringBuilder.length() - 1);
            if (c == '/' || c == '\\') {
                stringBuilder.append(charSequence2);
                continue;
            }
            stringBuilder.append('/').append(charSequence2);
        }
        return stringBuilder.toString();
    }

    public static String getUnicodeEscape(CharSequence charSequence) {
        if (StringUtil.isEmpty(charSequence)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(charSequence.length() * 4);
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c > '\u00ff') {
                String string = Integer.toHexString(c);
                stringBuilder.append(UTF_STR[string.length()]).append(string).append(';');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String getReplaceEscape(String string) {
        if (StringUtil.isEmpty(string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = stringBuilder.indexOf("&#");
        while (n >= 0) {
            if (n + 7 < stringBuilder.length() && stringBuilder.charAt(n + 7) == ';') {
                int n2 = Integer.parseInt(stringBuilder.substring(n + 3, n + 7), 16);
                stringBuilder.replace(n, n + 8, Character.toString((char)n2));
            }
            n = stringBuilder.indexOf("&#", n + 1);
        }
        return stringBuilder.toString();
    }

    public static double parseDouble(String string) {
        double d = StringUtil.isNull(string) || string.equals("_") ? 0.0 : (string.indexOf(44) < 0 ? Double.parseDouble(string) : Double.parseDouble(string.replaceAll(",", "")));
        return d;
    }

    public static String spanCut(String string) {
        String string2 = string;
        if (string != null && string.startsWith("<span")) {
            int n = string.indexOf(62);
            int n2 = string.indexOf("</span>", n);
            string2 = string.substring(n + 1, n2);
        }
        return string2;
    }

    public static String tagCut(String string) {
        if (StringUtil.isEmpty(string) || string.indexOf(60) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                bl = false;
                continue;
            }
            if (c == '>') {
                bl = true;
                continue;
            }
            if (!bl) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static ConcurrentMap<String, String> cssParse(String string) {
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        if (string != null) {
            int n;
            StringBuilder stringBuilder = new StringBuilder(string);
            int n2 = stringBuilder.indexOf("/*");
            while (n2 >= 0) {
                n = stringBuilder.indexOf("*/", n2);
                if (n < 0) {
                    stringBuilder = stringBuilder.delete(n2, stringBuilder.length());
                    break;
                }
                stringBuilder = stringBuilder.delete(n2, n + 2);
                n2 = stringBuilder.indexOf("/*");
            }
            n2 = stringBuilder.indexOf("{");
            n = stringBuilder.indexOf("}", n2);
            if (n2 >= 0 && n > 0) {
                String string2 = stringBuilder.substring(n2 + 1, n);
                for (String string3 : string2.split(";")) {
                    int n3 = string3.indexOf(58);
                    if (n3 <= 0) continue;
                    String string4 = string3.substring(0, n3).trim();
                    String string5 = string3.substring(n3 + 1).trim();
                    if (string4.isEmpty() || string5.isEmpty()) continue;
                    concurrentHashMap.put(string4, string5);
                }
            }
        }
        return concurrentHashMap;
    }

    public static boolean startsChar(CharSequence charSequence, char c) {
        return charSequence != null && charSequence.length() > 0 && charSequence.charAt(0) == c;
    }

    public static String cut(String string, int n, String string2) {
        try {
            if (StringUtil.isEmpty(string, string2) || n <= 0 || string.getBytes(string2).length <= n) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder(200);
            StringBuilder stringBuilder2 = new StringBuilder(200);
            for (int i = 0; i < string.length(); ++i) {
                String string3 = string.substring(i, i + 1);
                if (n < stringBuilder2.toString().getBytes(string2).length + string3.getBytes(string2).length) {
                    stringBuilder.append(stringBuilder2.toString());
                    break;
                }
                stringBuilder2.append(string3);
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string4 = "\u30a8\u30f3\u30b3\u30fc\u30c9\u304c\u4e0d\u6b63\u306e\u305f\u3081\u3001\u30d0\u30a4\u30c8\u30ab\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093\u3002 org=[" + string + "] , byteSize=[" + n + "] , encode=[" + string2 + "]";
            System.err.println(ThrowUtil.ogThrowMsg(string4, unsupportedEncodingException));
            return string;
        }
    }

    public static String cut(String string, int n) {
        return StringUtil.cut(string, n, "UTF-8");
    }
}

