/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.util.ArraySet;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelSorter;
import org.opengion.hayabusa.io.JsChartData;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class JsChartTag
extends CommonTagSupport {
    private static final String VERSION = "6.9.2.0 (2018/03/05)";
    private static final long serialVersionUID = 692020180305L;
    public static final String CTYPE_LINE = "line";
    public static final String CTYPE_BAR = "bar";
    public static final String CTYPE_HBAR = "horizontalBar";
    public static final String CTYPE_RADAR = "radar";
    public static final String CTYPE_PA = "polarArea";
    public static final String CTYPE_PIE = "pie";
    public static final String CTYPE_DOUGHNUT = "doughnut";
    private static final Set<String> CTYPE_SET = new ArraySet((Object[])new String[]{"line", "bar", "horizontalBar", "radar", "polarArea", "pie", "doughnut"});
    private static final String[] CTYPE_CI = new String[]{"radar", "polarArea", "pie", "doughnut"};
    private static final String TYPE_CATEGORY = "category";
    private static final String TYPE_TIME = "time";
    private static final String TYPE_LINEAR = "linear";
    private static final Set<String> SET_POSITION = new ArraySet((Object[])new String[]{"top", "right", "bottom", "left"});
    private static final Set<String> SET_TIMEUNIT = new ArraySet((Object[])new String[]{"year", "quarter", "month", "week", "day", "hour", "minute", "second", "millsecond"});
    private static final Set<String> SET_XSCALE = new ArraySet((Object[])new String[]{"category", "time", "linear"});
    private static final Set<String> SET_YSCALE = new ArraySet((Object[])new String[]{"linear", "category"});
    private static final Set<String> SET_BOOLEAN = new ArraySet((Object[])new String[]{"true", "false"});
    private static final String CANVAS_NAME = "hybscanvas";
    private static final String MARK_DEF_COLOR = "BLUE";
    private static final String MARK_DEF_ADJUST = "-6";
    private final List<JsChartData> jsChartData = new ArrayList<JsChartData>();
    private String chartType;
    private String labelColumn;
    private String id;
    private String height = "400";
    private String width = "400";
    private String title;
    private String titlePosition;
    private String legendPosition;
    private String legendDisplay;
    private String barWidthPer = "0.8";
    private String onClick;
    private String usePointStyle;
    private String xlabel;
    private String xscaleCallback;
    private String xscaleType = "category";
    private boolean xbeginAtZero = true;
    private String xmax;
    private String xmin;
    private String xstepSize;
    private String timeUnit;
    private String timeUnitStepSize;
    private String timeSetFormat;
    private String timeLblFormat;
    private String timeMax;
    private String timeMin;
    private String ylabel;
    private String yscaleCallback;
    private String yscaleType = "linear";
    private String stepSize;
    private String ycategoryList;
    private boolean ybeginAtZero = true;
    private String max;
    private String min;
    private String tableId = "h_tblmdl";
    private String markValues;
    private String markColors;
    private String markLbls;
    private String markAdjust;
    private boolean useZoom;
    private String widthEventColumn;
    private String heightEventColumn;
    private String minEventColumn;
    private String maxEventColumn;
    private boolean useZeroDataOmit;
    private boolean useRenderer;
    private String sortColumn;
    private String optionAttributes;

    @Override
    protected void release2() {
        super.release2();
        this.jsChartData.clear();
        this.chartType = null;
        this.id = null;
        this.height = "400";
        this.width = "400";
        this.labelColumn = null;
        this.title = null;
        this.titlePosition = null;
        this.legendPosition = null;
        this.legendDisplay = null;
        this.barWidthPer = "0.8";
        this.onClick = null;
        this.usePointStyle = null;
        this.xlabel = null;
        this.xscaleCallback = null;
        this.xscaleType = TYPE_CATEGORY;
        this.xbeginAtZero = true;
        this.xmax = null;
        this.xmin = null;
        this.xstepSize = null;
        this.timeUnit = null;
        this.timeUnitStepSize = null;
        this.timeSetFormat = null;
        this.timeLblFormat = null;
        this.timeMax = null;
        this.timeMin = null;
        this.ylabel = null;
        this.yscaleCallback = null;
        this.yscaleType = TYPE_LINEAR;
        this.ycategoryList = null;
        this.ybeginAtZero = true;
        this.max = null;
        this.min = null;
        this.stepSize = null;
        this.tableId = "h_tblmdl";
        this.markValues = null;
        this.markColors = null;
        this.markLbls = null;
        this.markAdjust = null;
        this.useZoom = false;
        this.widthEventColumn = null;
        this.heightEventColumn = null;
        this.maxEventColumn = null;
        this.minEventColumn = null;
        this.useZeroDataOmit = false;
        this.useRenderer = false;
        this.sortColumn = null;
        this.optionAttributes = null;
    }

    @Override
    public int doStartTag() {
        if (!this.useTag()) {
            return 0;
        }
        this.checkData();
        return 2;
    }

    private void checkData() {
        if (TYPE_LINEAR.equals(this.xscaleType) && TYPE_CATEGORY.equals(this.yscaleType)) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u6307\u5b9a\u306e\uff7d\uff79\uff70\uff99\uff80\uff72\uff8c\uff9f\u306e\u7d44\u307f\u5408\u308f\u305b\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002").append(CR).append("xscaleType:").append(this.xscaleType).append(" yscaleType:").append(this.yscaleType);
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (!this.useTag()) {
            return 6;
        }
        this.id = this.id == null ? CANVAS_NAME + this.tableId : this.id;
        this.jspPrint(this.jsChartOutput());
        return 6;
    }

    private String jsChartOutput() {
        int n;
        Object object;
        String[] stringArray;
        int n2;
        Object object2;
        Object object3;
        int n3;
        StringBuilder stringBuilder = new StringBuilder(200);
        String string = "qd_" + this.id;
        String string2 = "cd_" + this.id;
        String string3 = "chart_" + this.id;
        String string4 = this.labelColumn + this.id;
        Object object4 = (DBTableModel)this.getObject(this.tableId);
        if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.sortColumn})) {
            n3 = object4.getColumnNo(this.sortColumn, false);
            object3 = new DBTableModelSorter();
            ((DBTableModelSorter)object3).setModel((DBTableModel)this.getObject(this.tableId));
            ((DBTableModelSorter)object3).sortByColumn(n3, true);
            object4 = object3;
        }
        n3 = object4.getRowCount();
        if (this.useZeroDataOmit) {
            object3 = this.jsChartData.iterator();
            while (object3.hasNext()) {
                object2 = (JsChartData)object3.next();
                String string5 = ((JsChartData)object2).getChartColumn();
                int n4 = object4.getColumnNo(string5, false);
                n2 = 1;
                if (n4 >= 0) {
                    for (int i = 0; i < object4.getRowCount(); ++i) {
                        stringArray = (String[])object4.getValue(i, n4);
                        if (StringUtil.isNull((CharSequence[])new CharSequence[]{stringArray}) || "0".equals(stringArray) || "0.0".equals(stringArray) || "0.00".equals(stringArray)) continue;
                        n2 = 0;
                        break;
                    }
                }
                if (n2 == 0) continue;
                object3.remove();
            }
        }
        int n5 = this.jsChartData.size();
        object2 = new int[n5];
        int n6 = object4.getColumnNo(this.labelColumn, false);
        DBColumn dBColumn = object4.getDBColumn(n6);
        for (n2 = 0; n2 < n5; ++n2) {
            String string6 = this.jsChartData.get(n2).getChartColumn();
            object2[n2] = object4.getColumnNo(string6, false);
        }
        stringBuilder.append("<canvas class=\"").append(CANVAS_NAME).append("\" id=\"").append(this.id).append("\" width=\"").append(this.width).append("\" height=\"").append(this.height).append("\"><!-- --></canvas>").append("<script>var ").append(string).append("={\"DATA\":[");
        n2 = TYPE_CATEGORY.equals(this.yscaleType) ? 1 : 0;
        boolean bl = TYPE_LINEAR.equals(this.xscaleType);
        if (bl) {
            stringArray = object4.getNames();
            for (int i = 0; i < object4.getRowCount(); ++i) {
                stringBuilder.append("{\"").append(stringArray[n6]).append("\":\"").append((String)object4.getValue(i, n6)).append('\"');
                object = object2;
                int n7 = ((Object)object).length;
                for (int j = 0; j < n7; ++j) {
                    Object object5 = object[j];
                    String string7 = (String)object4.getValue(i, object5);
                    stringBuilder.append(",\"").append(stringArray[object5]).append("\":\"").append(string7).append('\"');
                }
                stringBuilder.append("},");
            }
            stringBuilder.append("]};").append(CR);
        } else {
            for (int i = 0; i < object4.getRowCount(); ++i) {
                String string8 = (String)object4.getValue(i, n6);
                object = this.useRenderer ? StringUtil.jsonFilter((String)dBColumn.getRendererValue(i, string8)) : string8;
                stringBuilder.append('[').append('\"').append((String)object).append('\"');
                for (Object object6 : object2) {
                    String string9 = (String)object4.getValue(i, (int)object6);
                    stringBuilder.append(',');
                    if (n2 != 0) {
                        stringBuilder.append('\"').append(string9).append('\"');
                        continue;
                    }
                    stringBuilder.append(string9);
                }
                stringBuilder.append("],");
            }
            stringBuilder.append("]};").append(CR);
        }
        for (n = 0; n < n5; ++n) {
            stringBuilder.append(" var ").append(this.jsChartData.get(n).getChartColumn()).append("=[];");
        }
        stringBuilder.append("var ").append(string4).append("=[];");
        stringBuilder.append("for(var i=0; i < ").append(string).append(".DATA.length; i++){");
        for (n = 0; n < n5; ++n) {
            String string10 = this.jsChartData.get(n).getChartColumn();
            if (bl) {
                stringBuilder.append(string10).append("[i]={x:").append(string).append(".DATA[i].").append(this.labelColumn).append(",y:").append(string).append(".DATA[i].").append(string10).append("};");
                continue;
            }
            stringBuilder.append(string10).append("[i]=").append(string).append(".DATA[i][").append(n + 1).append("];");
        }
        if (bl) {
            stringBuilder.append(string4).append("[i]=").append(string).append(".DATA[i].").append(this.labelColumn).append(";}");
        } else {
            stringBuilder.append(string4).append("[i]=").append(string).append(".DATA[i][0];}");
        }
        if (n2 != 0) {
            stringBuilder.append("var ycateList=[];");
            if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.ycategoryList})) {
                Pattern pattern = Pattern.compile(" *, *");
                object = pattern.matcher(this.ycategoryList);
                stringBuilder.append("ycateList=['").append(((Matcher)object).replaceAll("','")).append("'];");
            }
        }
        stringBuilder.append("var ").append(string2).append("={labels:").append(string4);
        if (n2 != 0) {
            stringBuilder.append(",yLabels:ycateList");
        }
        stringBuilder.append(",datasets:[");
        for (n = 0; n < n5; ++n) {
            if (n != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.jsChartData.get(n).getParameter());
        }
        stringBuilder.append("]};");
        stringBuilder.append("var ").append(string3).append("=new Chart(").append(this.id).append(",{type:'").append(this.chartType).append("',data:").append(string2).append(",options:{responsive:false");
        if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.onClick})) {
            stringBuilder.append(",onClick:function(event,obj){").append(this.onClick).append('}');
        }
        if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.title})) {
            stringBuilder.append(",title:{display:true");
            this.setProp(stringBuilder, ",text:'", this.title, "'");
            this.setProp(stringBuilder, ",position:'", this.titlePosition, "'");
            stringBuilder.append('}');
        }
        if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.legendDisplay})) {
            stringBuilder.append(",legend:{");
            this.setProp(stringBuilder, "display:", this.legendDisplay);
            this.setProp(stringBuilder, ",position:'", this.legendPosition, "'");
            stringBuilder.append('}');
        }
        this.setProp(stringBuilder, ",usePointStyle:", this.usePointStyle);
        List<String> list = Arrays.asList(CTYPE_CI);
        if (list.contains(this.chartType)) {
            stringBuilder.append(",scale:{ticks:{beginAtZero:").append(this.ybeginAtZero);
            this.setProp(stringBuilder, ",max:", this.max);
            this.setProp(stringBuilder, ",min:", this.min);
            this.setProp(stringBuilder, ",stepSize:", this.stepSize);
            stringBuilder.append("}}");
        } else {
            stringBuilder.append(",scales:{");
            if (CTYPE_HBAR.equals(this.chartType)) {
                stringBuilder.append("xAxes");
            } else {
                stringBuilder.append("yAxes");
            }
            stringBuilder.append(":[{type:'").append(this.yscaleType).append('\'');
            if (n2 != 0) {
                stringBuilder.append(",position:'left'");
            }
            if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.ylabel})) {
                stringBuilder.append(",scaleLabel:{display:true").append(",labelString:'").append(this.ylabel).append("'}");
            }
            stringBuilder.append(",ticks:{beginAtZero:").append(this.ybeginAtZero);
            this.setProp(stringBuilder, ",max:", this.max);
            this.setProp(stringBuilder, ",min:", this.min);
            this.setProp(stringBuilder, ",stepSize:", this.stepSize);
            this.setProp(stringBuilder, ",callback:", this.yscaleCallback);
            stringBuilder.append("}}],");
            if (CTYPE_HBAR.equals(this.chartType)) {
                stringBuilder.append("yAxes");
            } else {
                stringBuilder.append("xAxes");
            }
            stringBuilder.append(":[{type:'").append(this.xscaleType).append('\'');
            this.setProp(stringBuilder, ",categoryPercentage:", this.barWidthPer);
            if (bl) {
                stringBuilder.append(",position:'bottom'");
            }
            if (CTYPE_HBAR.equals(this.chartType)) {
                stringBuilder.append(",position:'left'");
            }
            if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.xlabel})) {
                stringBuilder.append(",scaleLabel:{display:true,").append("labelString:'").append(this.xlabel).append("'}");
            }
            stringBuilder.append(",time:{");
            this.setProp(stringBuilder, "format:'", this.timeSetFormat, "',");
            if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.timeLblFormat})) {
                stringBuilder.append("displayFormats:{year:'").append(this.timeLblFormat).append("',quarter:'").append(this.timeLblFormat).append("',month:'").append(this.timeLblFormat).append("',week:'").append(this.timeLblFormat).append("',day:'").append(this.timeLblFormat).append("',hour:'").append("',minute:'").append(this.timeLblFormat).append("',second:'").append(this.timeLblFormat).append("',millisecond:''},");
            }
            this.setProp(stringBuilder, "max:", this.timeMax, ",");
            this.setProp(stringBuilder, "min:", this.timeMin, ",");
            this.setProp(stringBuilder, "unit:", this.timeUnit, ",");
            this.setProp(stringBuilder, "unitStepSize:", this.timeUnitStepSize, ",");
            stringBuilder.append("},");
            stringBuilder.append("ticks:{");
            this.setProp(stringBuilder, "callback:", this.xscaleCallback, ",");
            if (bl) {
                this.setProp(stringBuilder, "beginAtZero:", String.valueOf(this.xbeginAtZero), ",");
                this.setProp(stringBuilder, "max:", this.xmax, ",");
                this.setProp(stringBuilder, "min:", this.xmin, ",");
                this.setProp(stringBuilder, "stepSize:", this.xstepSize, ",");
            }
            stringBuilder.append("}}]}");
            String[] stringArray2 = StringUtil.csv2Array((String)this.markValues);
            int n8 = stringArray2.length;
            if (n8 > 0) {
                String[] stringArray3 = StringUtil.csv2Array((String)this.markColors, (char)',', (int)n8, (String)MARK_DEF_COLOR);
                String[] stringArray4 = StringUtil.csv2Array((String)this.markLbls, (char)',', (int)n8);
                String[] stringArray5 = StringUtil.csv2Array((String)this.markAdjust, (char)',', (int)n8, (String)MARK_DEF_ADJUST);
                stringBuilder.append(",annotation:{annotations:[");
                for (int i = 0; i < n8; ++i) {
                    stringBuilder.append("{type:'line',scaleID:'y-axis-0',mode:'horizontal',borderWidth:2");
                    this.setProp(stringBuilder, ",value:", stringArray2[i]);
                    this.setProp(stringBuilder, ",borderColor:'", stringArray3[i], "'");
                    if (!stringArray4[i].isEmpty()) {
                        stringBuilder.append(",label:{enabled:'true',position:'left',backgroundColor:'rgba(0,0,0,0)',fontSize:10");
                        this.setProp(stringBuilder, ",yAdjust:", stringArray5[i]);
                        this.setProp(stringBuilder, ",content:'", stringArray4[i], "'");
                        this.setProp(stringBuilder, ",fontColor:'", stringArray3[i], "'");
                        stringBuilder.append('}');
                    }
                    stringBuilder.append("},");
                }
                stringBuilder.append("]}");
            }
            if (this.useZoom) {
                stringBuilder.append(",pan:{enabled:true,mode:'xy'},zoom:{enabled:true,drag:false,mode:'xy'}");
            }
        }
        this.setProp(stringBuilder, ",", this.optionAttributes);
        stringBuilder.append("}});");
        if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.widthEventColumn})) {
            stringBuilder.append("$(document).delegate('#").append(this.widthEventColumn).append("','mouseup keyup',function(){").append("var width=$(this).val();").append("$('#").append(this.id).append("').attr('width',width);").append(string3).append(".chart.width=width;").append(string3).append(".update();").append("});").append("$(function(){").append("var chartWidth=$('#").append(this.id).append("').attr('width');").append("$('#").append(this.widthEventColumn).append("').val(chartWidth);").append("});");
        }
        if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.heightEventColumn})) {
            stringBuilder.append("$(document).delegate('#").append(this.heightEventColumn).append("','mouseup keyup',function(){").append("var height=$(this).val();").append("$('#").append(this.id).append("').attr('height',height);").append(string3).append(".chart.height=height;").append(string3).append(".update();").append("});").append("$(function(){").append("var chartHeight=$('#").append(this.id).append("').attr('height');").append("$('#").append(this.heightEventColumn).append("').val(chartHeight);").append("});");
        }
        if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.minEventColumn})) {
            stringBuilder.append("$(document).delegate('#").append(this.minEventColumn).append("','mouseup keyup',function(){").append("var min=parseFloat($(this).val());").append(string3).append(".options.scales.yAxes[0].ticks.min = min;").append(string3).append(".update();").append("});").append("$(function(){").append("var chartMax=").append(string3).append(".scales['y-axis-0'].max;").append("var chartMin=").append(string3).append(".scales['y-axis-0'].min;").append("$('#").append(this.minEventColumn).append("').val(chartMin);").append("$('#").append(this.minEventColumn).append("').attr({'max':chartMax});").append("$('#").append(this.minEventColumn).append("').attr({'min':chartMin});").append("});");
        }
        if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.maxEventColumn})) {
            stringBuilder.append("$(document).delegate('#").append(this.maxEventColumn).append("','mouseup keyup',function(){").append("var max=parseFloat($(this).val());").append(string3).append(".options.scales.yAxes[0].ticks.max = max;").append(string3).append(".update();").append("});").append("$(function(){").append("var chartMax=").append(string3).append(".scales['y-axis-0'].max;").append("var chartMin=").append(string3).append(".scales['y-axis-0'].min;").append("$('#").append(this.maxEventColumn).append("').val(chartMax);").append("$('#").append(this.maxEventColumn).append("').attr({'max':chartMax});").append("$('#").append(this.maxEventColumn).append("').attr({'min':chartMin});").append("});");
        }
        if (this.useZoom) {
            stringBuilder.append("window.onload=function(){$('#").append(this.id).append("').dblclick(function(){window.").append(string3).append(".resetZoom();});}");
        }
        stringBuilder.append("</script>");
        return stringBuilder.toString();
    }

    private void setProp(StringBuilder stringBuilder, String string, String string2) {
        if (!StringUtil.isNull((CharSequence[])new CharSequence[]{string2})) {
            stringBuilder.append(string).append(string2);
        }
    }

    private void setProp(StringBuilder stringBuilder, String string, String string2, String string3) {
        if (!StringUtil.isNull((CharSequence[])new CharSequence[]{string2})) {
            stringBuilder.append(string).append(string2).append(string3);
        }
    }

    private void checkPara(String string, Set<String> set, String string2) {
        if (!StringUtil.isNull((CharSequence[])new CharSequence[]{string}) && !this.check(string, set)) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u6307\u5b9a\u306e").append(string2).append("\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093\u3002").append(CR).append(string2).append("=[").append(string).append("]").append(CR);
            for (String string3 : set) {
                stringBuilder.append(" | ");
                stringBuilder.append(string3);
            }
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void setChartType(String string) {
        this.chartType = this.getRequestParameter(string);
        if (!StringUtil.isNull((CharSequence[])new CharSequence[]{this.chartType}) && !this.check(this.chartType, CTYPE_SET)) {
            StringBuilder stringBuilder = new StringBuilder(200).append("\u6307\u5b9a\u306e\u30c1\u30e3\u30fc\u30c8\u30bf\u30a4\u30d7\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002").append(CR).append("chartType=[").append(this.chartType).append("]").append(CR);
            for (String string2 : CTYPE_SET) {
                stringBuilder.append(" | ").append(string2);
            }
            throw new HybsSystemException(stringBuilder.toString());
        }
    }

    public void setId(String string) {
        this.id = StringUtil.nval((String)this.getRequestParameter(string), (String)this.id);
    }

    public void setHeight(String string) {
        this.height = StringUtil.nval((String)this.getRequestParameter(string), (String)this.height);
    }

    public void setWidth(String string) {
        this.width = StringUtil.nval((String)this.getRequestParameter(string), (String)this.width);
    }

    public void setLabelColumn(String string) {
        this.labelColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.labelColumn);
    }

    public void setTitle(String string) {
        this.title = this.getRequestParameter(string);
    }

    public void setTitlePosition(String string) {
        this.titlePosition = this.getRequestParameter(string);
        this.checkPara(this.titlePosition, SET_POSITION, "titlePosition");
    }

    public void setXlabel(String string) {
        this.xlabel = this.getRequestParameter(string);
    }

    public void setYlabel(String string) {
        this.ylabel = this.getRequestParameter(string);
    }

    public void setLegendPosition(String string) {
        this.legendPosition = this.getRequestParameter(string);
        this.checkPara(this.legendPosition, SET_POSITION, "legendPosition");
    }

    public void setLegendDisplay(String string) {
        this.legendDisplay = this.getRequestParameter(string);
        this.checkPara(this.legendDisplay, SET_BOOLEAN, "legendDisplay");
    }

    public void setXscaleCallback(String string) {
        this.xscaleCallback = this.getRequestParameter(string);
    }

    public void setYscaleCallback(String string) {
        this.yscaleCallback = this.getRequestParameter(string);
    }

    public void setXscaleType(String string) {
        this.xscaleType = this.getRequestParameter(string);
        this.checkPara(this.xscaleType, SET_XSCALE, "xscaleType");
    }

    public void setXbeginAtZero(String string) {
        this.xbeginAtZero = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.xbeginAtZero);
    }

    public void setYbeginAtZero(String string) {
        this.ybeginAtZero = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.ybeginAtZero);
    }

    public void setYscaleType(String string) {
        this.yscaleType = this.getRequestParameter(string);
        this.checkPara(this.yscaleType, SET_YSCALE, "yscaleType");
    }

    public void setYcategoryList(String string) {
        this.ycategoryList = this.getRequestParameter(string);
    }

    public void setXmax(String string) {
        this.xmax = this.getRequestParameter(string);
    }

    public void setXmin(String string) {
        this.xmin = this.getRequestParameter(string);
    }

    public void setXstepSize(String string) {
        this.xstepSize = this.getRequestParameter(string);
    }

    public void setBarWidthPer(String string) {
        this.barWidthPer = this.getRequestParameter(string);
    }

    protected void addJsChartData(JsChartData jsChartData) {
        this.jsChartData.add(jsChartData);
    }

    protected int getJsChartDataSize() {
        return this.jsChartData.size();
    }

    public void setTimeUnit(String string) {
        this.timeUnit = this.getRequestParameter(string);
        this.checkPara(this.timeUnit, SET_TIMEUNIT, "timeUnit");
    }

    public void setTimeUnitStepSize(String string) {
        this.timeUnitStepSize = this.getRequestParameter(string);
    }

    public void setTimeSetFormat(String string) {
        this.timeSetFormat = this.getRequestParameter(string);
    }

    public void setTimeLblFormat(String string) {
        this.timeLblFormat = this.getRequestParameter(string);
    }

    public void setTimeMax(String string) {
        this.timeMax = this.getRequestParameter(string);
    }

    public void setTimeMin(String string) {
        this.timeMin = this.getRequestParameter(string);
    }

    public void setMax(String string) {
        this.max = StringUtil.nval((String)this.getRequestParameter(string), (String)this.max);
    }

    public void setMin(String string) {
        this.min = StringUtil.nval((String)this.getRequestParameter(string), (String)this.min);
    }

    public void setStepSize(String string) {
        this.stepSize = StringUtil.nval((String)this.getRequestParameter(string), (String)this.stepSize);
    }

    public void setOnClick(String string) {
        this.onClick = StringUtil.nval((String)this.getRequestParameter(string), (String)this.onClick);
    }

    public void setUsePointStyle(String string) {
        this.usePointStyle = StringUtil.nval((String)this.getRequestParameter(string), (String)this.usePointStyle);
    }

    public void setTableId(String string) {
        this.tableId = this.getRequestParameter(string);
    }

    public void setMarkValues(String string) {
        this.markValues = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markValues);
    }

    public void setMarkColors(String string) {
        this.markColors = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markColors);
    }

    public void setMarkLbls(String string) {
        this.markLbls = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markLbls);
    }

    public void setMarkAdjust(String string) {
        this.markAdjust = StringUtil.nval((String)this.getRequestParameter(string), (String)this.markAdjust);
    }

    public void setUseZoom(String string) {
        this.useZoom = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useZoom);
    }

    public void setWidthEventColumn(String string) {
        this.widthEventColumn = this.getRequestParameter(string);
    }

    public void setHeightEventColumn(String string) {
        this.heightEventColumn = this.getRequestParameter(string);
    }

    public void setMinEventColumn(String string) {
        this.minEventColumn = this.getRequestParameter(string);
    }

    public void setMaxEventColumn(String string) {
        this.maxEventColumn = this.getRequestParameter(string);
    }

    public void setUseZeroDataOmit(String string) {
        this.useZeroDataOmit = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useZeroDataOmit);
    }

    public void setUseRenderer(String string) {
        this.useRenderer = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useRenderer);
    }

    public void setSortColumn(String string) {
        this.sortColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.sortColumn);
    }

    public void setOptionAttributes(String string) {
        this.optionAttributes = StringUtil.nval((String)this.getRequestParameter(string), (String)this.optionAttributes);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("id", (Object)this.id).println("tableId", (Object)this.tableId).println("chartType", (Object)this.chartType).println("width", (Object)this.width).println("height", (Object)this.height).println("max", (Object)this.max).println("min", (Object)this.min).println("stepSize", (Object)this.stepSize).println("barWidthPer", (Object)this.barWidthPer).println("timeUnit", (Object)this.timeUnit).println("timeUnitStepSize", (Object)this.timeUnitStepSize).println("timeLblFormat", (Object)this.timeLblFormat).println("timeSetFormat", (Object)this.timeSetFormat).println("timeMax", (Object)this.timeMax).println("timeMin", (Object)this.timeMin).println("title", (Object)this.title).println("titlePosition", (Object)this.titlePosition).println("xlabel", (Object)this.xlabel).println("ylabel", (Object)this.ylabel).println("legendPosition", (Object)this.legendPosition).println("legendDisplay", (Object)this.legendDisplay).println("yscaleCallback", (Object)this.yscaleCallback).println("xscaleCallback", (Object)this.xscaleCallback).println("xscaleType", (Object)this.xscaleType).println("xmax", (Object)this.xmax).println("xmin", (Object)this.xmin).println("xstepSize", (Object)this.xstepSize).println("yscaleType", (Object)this.yscaleType).println("ycategoryList", (Object)this.ycategoryList).println("widthEventColumn", (Object)this.widthEventColumn).println("heightEventColumn", (Object)this.heightEventColumn).println("minEventColumn", (Object)this.minEventColumn).println("maxEventColumn", (Object)this.maxEventColumn).println("optionAttributes", (Object)this.optionAttributes).fixForm().toString();
    }
}

