/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.ConnectionFactory;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report.ExcelDataPickup;
import org.opengion.hayabusa.report.ExcelLayout;
import org.opengion.hayabusa.report.HybsHSSFListener;

public class ExcelInsert {
    private final StringBuilder errMsg;
    private final String EXCELIN;
    private final String SYSTEM_ID;
    private final String YKNO;
    private final String LISTID;
    private final boolean DEBUG;
    private String modelDIR;
    private String modelFILE;
    private String[] sheetNO;
    private String[] sheetREF;
    private String[] headDBID;
    private String[] bodyDBID;
    private String[] loopCLM;
    private ExcelLayout layout;
    private static final String GE54_GE57_SELECT = "SELECT A.MODELDIR,A.MODELFILE,B.SHEETNO,B.SHEETREF,B.HEADDBID,B.BODYDBID,B.LOOPCLM FROM GE54 A INNER JOIN GE57 B ON   A.SYSTEM_ID = B.SYSTEM_ID AND A.LISTID = B.LISTID WHERE A.FGJ = '1' AND B.FGJ = '1' AND  A.SYSTEM_ID = ? AND  A.LISTID = ? ORDER BY B.SHEETNO";
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");

    public ExcelInsert(String string, String string2, String string3, String string4, boolean bl) {
        this.SYSTEM_ID = string;
        this.YKNO = string2;
        this.LISTID = string3;
        this.EXCELIN = string4;
        this.DEBUG = bl;
        this.errMsg = new StringBuilder(200);
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYSTEM_ID, HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("ExcelInsert", this.YKNO, this.LISTID);
        } else {
            this.appInfo = null;
        }
    }

    public boolean execute() {
        boolean bl;
        System.out.print("ExcelInsert Started ... ");
        try {
            bl = this.initialDataSet();
            if (bl) {
                System.out.print("INIT,");
            }
            File file = null;
            if (bl) {
                file = FileUtil.checkFile((String)this.modelDIR, (String)(this.modelFILE + ".xls"));
                boolean bl2 = bl = file != null;
                if (bl) {
                    System.out.print("MDL IN,");
                } else {
                    this.errMsg.append("ExcelInsert MODELFILE Not Found Error!").append(HybsConst.CR);
                    this.errMsg.append("==============================").append(HybsConst.CR);
                    this.errMsg.append("MODELDIR=").append(this.modelDIR).append(HybsConst.CR);
                    this.errMsg.append("MODELFILE=").append(this.modelFILE).append(".xls");
                    this.errMsg.append(HybsConst.CR);
                }
            }
            File file2 = null;
            if (bl) {
                file2 = FileUtil.checkFile((String)this.EXCELIN, (String)(this.YKNO + ".xls"));
                boolean bl3 = bl = file2 != null;
                if (bl) {
                    System.out.print("XLS IN,");
                } else {
                    this.errMsg.append("ExcelInsert EXCELIN Not Found Error!").append(HybsConst.CR);
                    this.errMsg.append("==============================").append(HybsConst.CR);
                    this.errMsg.append("DIR=").append(this.EXCELIN).append(HybsConst.CR);
                    this.errMsg.append("FILE=").append(this.YKNO).append(".xls");
                    this.errMsg.append(HybsConst.CR);
                }
            }
            if (bl && (bl = this.getModelData(file))) {
                System.out.print("MDL DT,");
            }
            if (bl && (bl = this.readAndInsertDB(file2))) {
                System.out.print("IN DB,");
            }
        }
        catch (RuntimeException runtimeException) {
            this.errMsg.append("ExcelInsert Execute Exception Error!").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append(ThrowUtil.ogStackTrace((Throwable)runtimeException)).append(HybsConst.CR);
            bl = false;
        }
        System.out.println("End.");
        return bl;
    }

    private boolean initialDataSet() {
        String[] stringArray = new String[]{this.SYSTEM_ID, this.LISTID};
        String[][] stringArray2 = DBUtil.dbExecute((String)GE54_GE57_SELECT, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
        if (stringArray2 == null || stringArray2.length == 0) {
            this.errMsg.append("Data does not exist in GE54 table.").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , LISTID=[").append(this.LISTID).append(']').append(HybsConst.CR);
            return false;
        }
        this.modelDIR = StringUtil.nval((String)stringArray2[0][0], (String)this.modelDIR);
        this.modelFILE = StringUtil.nval((String)stringArray2[0][1], (String)this.modelFILE);
        if (this.modelDIR == null || this.modelDIR.isEmpty() || this.modelFILE == null || this.modelFILE.isEmpty()) {
            this.errMsg.append("MODELDIR and MODELFILE is necessary in GE54 table.").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , LISTID=[").append(this.LISTID).append("] , MODELDIR=[").append(this.modelDIR).append("] , MODELFILE=[").append(this.modelFILE).append("] ").append(HybsConst.CR);
            return false;
        }
        int n = stringArray2.length;
        this.sheetNO = new String[n];
        this.sheetREF = new String[n];
        this.headDBID = new String[n];
        this.bodyDBID = new String[n];
        this.loopCLM = new String[n];
        for (int i = 0; i < n; ++i) {
            this.sheetNO[i] = StringUtil.nval((String)stringArray2[i][2], null);
            this.sheetREF[i] = StringUtil.nval((String)stringArray2[i][3], null);
            this.headDBID[i] = StringUtil.nval((String)stringArray2[i][4], null);
            this.bodyDBID[i] = StringUtil.nval((String)stringArray2[i][5], null);
            this.loopCLM[i] = StringUtil.nval((String)stringArray2[i][6], null);
            if (this.sheetNO[i] != null && this.sheetREF[i] != null && (this.headDBID[i] != null || this.bodyDBID[i] != null)) continue;
            this.errMsg.append("SHEETNO \u3068 SHEETREF \u306f\u3001\u3069\u3061\u3089\u300e\u3082\u300f\u5fc5\u9808").append(HybsConst.CR).append("HEADDBID \u3068 BODYDBID \u306f\u3001\u3069\u3061\u3089\u300e\u304b\u300f\u5fc5\u9808").append(HybsConst.CR).append("==============================").append(HybsConst.CR).append("SYSTEM_ID=[").append(this.SYSTEM_ID).append("] , LISTID=[").append(this.LISTID).append("] , SHEETNO=[").append(this.sheetNO[i]).append("] , SHEETREF=[").append(this.sheetREF[i]).append("] , HEADDBID=[").append(this.headDBID[i]).append("] , BODYDBID=[").append(this.bodyDBID[i]).append("] ").append(HybsConst.CR);
            return false;
        }
        return true;
    }

    private boolean getModelData(File file) {
        try {
            this.layout = HybsHSSFListener.makeExcelLayout(file, false);
        }
        catch (IOException iOException) {
            this.errMsg.append("Template Excel File can not ModelData.").append(HybsConst.CR);
            this.errMsg.append("==============================").append(HybsConst.CR);
            this.errMsg.append("File=").append(file.getAbsolutePath());
            this.errMsg.append(ThrowUtil.ogStackTrace((Throwable)iOException));
            this.errMsg.append(HybsConst.CR);
            return false;
        }
        return true;
    }

    private boolean readAndInsertDB(File file) {
        ExcelDataPickup excelDataPickup = new ExcelDataPickup(this.layout, file, this.DEBUG);
        int n = excelDataPickup.getSheetSize();
        int[] nArray = this.makeSheetReference(n, this.sheetREF);
        DatabaseExecute databaseExecute = new DatabaseExecute();
        databaseExecute.setApplicationInfo(this.appInfo);
        int n2 = Integer.parseInt(this.YKNO);
        for (int i = 0; i < n; ++i) {
            String[] stringArray;
            int n3 = nArray[i];
            if (n3 < 0) continue;
            excelDataPickup.execute(Integer.parseInt(this.sheetNO[n3]), i, this.loopCLM[n3]);
            String string = this.layout.getHeaderInsertQuery(this.headDBID[n3]);
            if (string != null) {
                databaseExecute.setStatement(string);
                stringArray = this.layout.getHeaderInsertData(this.SYSTEM_ID, n2, i);
                databaseExecute.dbExecute(stringArray);
            }
            if ((stringArray = this.layout.getBodyInsertQuery(this.bodyDBID[n3])) == null) continue;
            databaseExecute.setStatement((String)stringArray);
            List<String[]> list = this.layout.getBodyInsertData(this.SYSTEM_ID, n2, i);
            for (int j = 0; j < list.size(); ++j) {
                databaseExecute.dbExecute(list.get(j));
            }
        }
        databaseExecute.commit();
        excelDataPickup.close();
        return true;
    }

    private int[] makeSheetReference(int n, String ... stringArray) {
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        int n2 = -1;
        block0: for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = StringUtil.csv2Array((String)stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                int n3;
                if (stringArray2[j].equals("LAST")) {
                    for (n3 = n2; n3 < n; ++n3) {
                        nArray[n3] = i;
                    }
                    i = n;
                    continue block0;
                }
                n3 = Integer.parseInt(stringArray2[j]);
                if (n3 < n) {
                    nArray[n3] = i;
                    if (n2 >= n3) continue;
                    n2 = n3 + 1;
                    continue;
                }
                String string = "\u30c7\u30fc\u30bf\u30b7\u30fc\u30c8\u3068\u96db\u5f62\u660e\u7d30\u5b9a\u7fa9\u306e\u5bfe\u5fdc\u304c\u3067\u304d\u307e\u305b\u3093\u3002 \u30c7\u30fc\u30bf\u30b7\u30fc\u30c8\u7dcf\u4ef6\u6570=[" + n + "]  sheetRef[" + i + "]=" + stringArray[i];
                throw new HybsSystemException(string);
            }
        }
        return nArray;
    }

    public String getErrMsg() {
        return this.errMsg.toString();
    }

    private static final class DatabaseExecute {
        private static final int DB_FETCH_SIZE = HybsSystem.sysInt("DB_FETCH_SIZE");
        private static final String DBID = null;
        private Connection conn;
        private PreparedStatement pstmt;
        private String tempSql;
        private ApplicationInfo appInfo;

        private DatabaseExecute() {
        }

        public void setApplicationInfo(ApplicationInfo applicationInfo) {
            this.appInfo = applicationInfo;
        }

        public void setStatement(String string) {
            boolean bl = true;
            this.tempSql = string;
            try {
                if (this.conn == null) {
                    this.conn = ConnectionFactory.connection((String)DBID, (ApplicationInfo)this.appInfo);
                }
                Closer.stmtClose((Statement)this.pstmt);
                this.pstmt = this.conn.prepareStatement(string);
                this.pstmt.setFetchSize(DB_FETCH_SIZE);
                bl = false;
            }
            catch (SQLException sQLException) {
                String string2 = "Statement \u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + "SQL=[" + string + "]" + sQLException.getMessage() + ":" + sQLException.getSQLState();
                throw new HybsSystemException(string2, sQLException);
            }
            finally {
                if (bl) {
                    this.errorFinally();
                }
            }
        }

        public void commit() {
            boolean bl = true;
            try {
                this.conn.commit();
                bl = false;
            }
            catch (SQLException sQLException) {
                Closer.rollback((Connection)this.conn);
                String string = "Connection \u3092\u30b3\u30df\u30c3\u30c8\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + sQLException.getMessage() + ":" + sQLException.getSQLState();
                throw new HybsSystemException(string, sQLException);
            }
            finally {
                Closer.stmtClose((Statement)this.pstmt);
                if (bl) {
                    ConnectionFactory.remove((Connection)this.conn, (String)DBID);
                } else {
                    ConnectionFactory.close((Connection)this.conn, (String)DBID);
                }
                this.conn = null;
            }
        }

        public void dbExecute(String ... stringArray) {
            boolean bl = true;
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.pstmt.setString(i + 1, stringArray[i]);
                }
                this.pstmt.execute();
                bl = false;
            }
            catch (SQLException sQLException) {
                String string = "\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u51e6\u7406\u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + HybsConst.CR + "ARGS=[" + StringUtil.array2csv((String[])stringArray) + "]" + HybsConst.CR + "SQL=[" + this.tempSql + "]" + sQLException.getMessage() + ":" + sQLException.getSQLState();
                throw new HybsSystemException(string, sQLException);
            }
            finally {
                if (bl) {
                    this.errorFinally();
                }
            }
        }

        private void errorFinally() {
            Closer.stmtClose((Statement)this.pstmt);
            this.pstmt = null;
            Closer.rollback((Connection)this.conn);
            ConnectionFactory.remove((Connection)this.conn, (String)DBID);
            this.conn = null;
        }
    }
}

